// zither_subst.c
// $Id: zither_subst.c,v 1.3 2007/07/19 03:44:41 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>
#include<sys/types.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/wait.h>
#include<string.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<pthread.h>

#include"zither.h"
#include"almemsys.h"
#include"jpreturn.h"

#ifdef POSTGRES_IN
  #include "/usr/local/pgsql/include/libpq-fe.h"
  extern PGconn * conn;
  extern PGresult * res;
#endif


extern global_data_t gd;

int get_logi(private_data_t *);
int put_logi(private_data_t *);
int ver_logi(private_data_t *);
int vers_logi(private_data_t *);
int quit_logi(private_data_t *);
int com_check(char *);
int neg_logi(private_data_t *);
/* int private_data_list(private_data_t *); */
int mail_send(private_data_t *, char *, char *);
int err_logi(private_data_t *);
/* char * errdata_tok(private_data_t *, unsigned char *); */
int errdata_tok(private_data_t *, unsigned char *);
int set_logi(private_data_t *);
int setg_logi(private_data_t *);
int bat_logi(private_data_t *);
int dif_logi(private_data_t *);
int life_logi(private_data_t *);
int life_thread(private_data_t *);
int global_data_list(private_data_t *);
char * check_strtol(char *);
char * mail_form(char *, private_data_t *, unsigned char *, int *);




/*----------------- STAG-NEG ---------------- */
int stag_neg(private_data_t * pd)
{
static int ret;
char * getdata;
char * getdata2;
char * tmp;

char * swap = (char *)calloc(IP_LEN, sizeof(char));

swap = safe_memcpy(swap, pd->getdata, BUF_MAX);
getdata = strstr(swap, "DATA: ");

ret = 0;
if(' '!= pd->getdata[0] && NULL!=strstr(pd->getdata," COM: ") &&
NULL!=strstr(pd->getdata," DATA: ") && NULL!=strstr(pd->getdata, " :: ")){ 
   if( 24 >= strlen(pd->rec.user = safe_memcpy(pd->rec.user, strtok_r(pd->getdata, " :: ", &tmp), BUF_MAX))){
      if( 5 >= strlen(pd->rec.com = safe_memcpy(pd->rec.com, strtok_r(NULL, " COM: ", &tmp), BUF_MAX))){
         if((getdata2 = (strchr(getdata, ' ')+1))!=NULL){
            pd->rec.data = safe_memcpy(pd->rec.data, getdata2, BUF_MAX);
            rm_crlf(pd->rec.user, (int)strlen(pd->rec.user));
            rm_crlf(pd->rec.com, (int)strlen(pd->rec.com));
            rm_crlf(pd->rec.data, (int)strlen(pd->rec.data));
            if( 0!=strlen(pd->rec.user)){
               #ifdef DEBUG
               printf("user %s\n", pd->rec.user);
               printf("com %s\n", pd->rec.com);
               printf("data %s\n", pd->rec.data);
               #endif
               switch((int)com_check(pd->rec.com)){

                  case 0 : ret = socket_send(gd.ms.sk[pd->rec.fdno], 
                                  "500 NG Illegal method.\n",
                             //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
                                  pd->life.life_int);
                       #ifdef LOG_OUT
                       pthread_mutex_lock(&con_mutex);
                       log_out(gd.fp.con_fd, pd->rec.user,
                        "<Not>", "Illegal method.", gd.ms.inip_addr[pd->rec.fdno]);
                       pthread_mutex_unlock(&con_mutex);
                       #endif
                       break; 
                  case 1 : ret = get_logi(pd);             break; /* User */
                  case 2 : ret = put_logi(pd);             break; /* User */
                  case 3 : ret = life_logi(pd);            break; /* User */
                  case 4 : ret = quit_logi(pd);            break; /* General */
                  case 5 : ret = vers_logi(pd);            break; /* General */
                  case 7 : ret = bat_logi(pd);             break; /* User */
                  case 8 : ret = err_logi(pd);             break; /* User */
                  case 9 : ret = set_logi(pd);             break; /* User */
           /*     case 10: private_data_list(pd);          break;   */
                  case 11: ret = setg_logi(pd);            break; /* administrator */
                  case 12: global_data_list(pd);           break;
                  case 13 : ret = dif_logi(pd);            break; /* User */
                  default : ret = socket_send(gd.ms.sk[pd->rec.fdno],
                                   "500 NG Illegal method.\n",
                              //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
                                   pd->life.life_int);
                       #ifdef LOG_OUT
                       pthread_mutex_lock(&con_mutex);
                       log_out(gd.fp.con_fd, pd->rec.user,
                        "<Not>", "Illegal method.", gd.ms.inip_addr[pd->rec.fdno]);
                       pthread_mutex_unlock(&con_mutex);
                       #endif
                       break;
                  }
               }
            }
         } else {
             ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG data size\n",
               //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
                    pd->life.life_int);
                }
      }
   }
else {
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG No data!\n",
     //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user,
    "<Not>", "prease check send data.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif
   }

free(swap);

return(ret);
}



/*----------------- START-NEG ----------------*/
int start_neg(private_data_t * pd)
{
static int ret;
char * getdata;
char * getdata2;
char * tmp; 

char * swap = (char *)calloc(IP_LEN, sizeof(char));

swap = safe_memcpy(swap, pd->getdata, BUF_MAX);
getdata = strstr(swap, "DATA: ");

ret = 0;
if(' '!= pd->getdata[0] && NULL!=strstr(pd->getdata," COM: ") &&
NULL!=strstr(pd->getdata," DATA: ") && NULL!=strstr(pd->getdata, " :: ")){ 
   if( 24 >= strlen(pd->rec.user = safe_memcpy(pd->rec.user, strtok_r(pd->getdata, " :: ", &tmp), BUF_MAX))){
      if( 5 >= strlen(pd->rec.com = safe_memcpy(pd->rec.com, strtok_r(NULL, " COM: ", &tmp), BUF_MAX))){
         if((getdata2 = (strchr(getdata, ' ')+1))!=NULL){
            pd->rec.data = safe_memcpy(pd->rec.data, getdata2, BUF_MAX);
            rm_crlf(pd->rec.user, (int)strlen(pd->rec.user));
            rm_crlf(pd->rec.com, (int)strlen(pd->rec.com));
            rm_crlf(pd->rec.data, (int)strlen(pd->rec.data));
            if( 0!=strlen(pd->rec.user)){
               #ifdef DEBUG
               printf("user %s\n", pd->rec.user);
               printf("com %s\n", pd->rec.com);
               printf("data %s\n", pd->rec.data);
               #endif
               switch((int)com_check(pd->rec.com)){
                  case 0 : socket_send(gd.ms.sk[pd->rec.fdno],
                             "500 NG Illegal method.\n",
                       //    (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
                             gd.bs.life_int);
                            ret = -1;
                            free(swap);
                            return(ret);
                            break;

                  case 5 : ret = ver_logi(pd);             break;
                  case 6 : ret = neg_logi(pd);             break;

                  default : socket_send(gd.ms.sk[pd->rec.fdno],
                              "500 NG Illegal method.\n",
                       //     (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
                              gd.bs.life_int);
                            ret = -1;
                            free(swap);
                            return(ret);
                            break;
                  }
               }
            }
         }
      else{
         socket_send(gd.ms.sk[pd->rec.fdno],
           "500 NG data size\n",
       //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
           gd.bs.life_int);
         ret = -1;
         free(swap);
         return(ret);
         }
      }
   }
else{
   socket_send(gd.ms.sk[pd->rec.fdno],
     "500 NG No data!\n",
  //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
      gd.bs.life_int);
   ret = -1;
   free(swap);
   return(ret);
   }

free(swap);
return(ret);
}





/*--------------- NEG_LOGIC ------------------- */
int neg_logi(private_data_t * pd)
{
static int stat;
stat = 0;
int count = 0;
char * tmp;

if(((int)neg(pd->rec.user, gd.fp.neg_conf, gd.ms.inip_addr[pd->rec.fdno]))==1){
   pd->file.lock_filename = chack_lockfile(pd->rec.user, pd->rec.info, pd->file.lock_filename, gd.fp.lock_path, &stat);

   pd->file.clock_filename = filename_create(pd->file.clock_filename, gd.fp.clock_path, "_lock", pd->rec.user);
   lock_remove(pd->file.clock_filename);

   #ifdef DEBUG
   printf("my lock file name & path. %s\n", pd->file.lock_filename);
   printf("my clock file name & path. %s\n", pd->file.clock_filename);
   #endif

   if(stat == 1){

      pd->rec.def_user = safe_memcpy(pd->rec.def_user, pd->rec.user, BUF_MAX);

      count = mem_count(pd->rec.data, ',');
      if(2 < count && count < ((int)strlen(pd->rec.data) - 2)){
         pd->rec.ver = safe_memcpy(pd->rec.ver, strtok_r(pd->rec.data, ",", &tmp), BUF_MAX);
         pd->rec.info = safe_memcpy(pd->rec.info, strtok_r(NULL, ",", &tmp), BUF_MAX);
         }
      else{
         pd->rec.ver = safe_memcpy(pd->rec.ver, "NON", BUF_MAX);
         pd->rec.info = safe_memcpy(pd->rec.info, pd->rec.data, BUF_MAX);
         }

      pd->mail.server = safe_memcpy(pd->mail.server, gd.md.ch_MailServ, BUF_MAX);
      pd->mail.rcptto = safe_memcpy(pd->mail.rcptto, gd.md.ch_MailRcptTo, BUF_MAX);
      pd->mail.from = safe_memcpy(pd->mail.from, gd.md.ch_MailFrom, BUF_MAX);
      pd->mail.cc = safe_memcpy(pd->mail.cc, gd.md.ch_MailCc, BUF_MAX);

      pd->life.life_int = gd.bs.life_int;
      pd->life.life_los = gd.bs.life_los; 
      pd->life.onoff = 1;                    // life default on

      pd->file.bat_filename = filename_create(pd->file.bat_filename, gd.fp.file_conf, ".command", pd->rec.user);

      #ifdef DEBUG
      printf("bat_filename <%s>\n", pd->file.bat_filename);
      #endif

      pd->file.scan_filename = filename_create(pd->file.scan_filename, gd.fp.file_conf, ".list", pd->rec.user);

      #ifdef DEBUG
      printf("scan_filename <%s>\n", pd->file.scan_filename);
      #endif

      pd->file.conf_filename = filename_create(pd->file.conf_filename, gd.fp.file_conf, ".conf", pd->rec.user);

      #ifdef DEBUG
      printf("conf_filename <%s>\n", pd->file.conf_filename);
      #endif

      pd->file.stat_filename = filename_create(pd->file.stat_filename, gd.fp.file_conf, ".stat", pd->rec.user);

      #ifdef DEBUG
      printf("stat_filename <%s>\n", pd->file.stat_filename);
      #endif

      #ifdef LOG_OUT
      pthread_mutex_lock(&con_mutex);
      log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "It was newly connected.", gd.ms.inip_addr[pd->rec.fdno]);
      pthread_mutex_unlock(&con_mutex);
      #endif

      #ifdef POSTGRES_IN
      char * swap = (char *)calloc(2, sizeof(char));
      swap = safe_sprintf(swap, BUF_MAX, "%s('%d.%d.%d.%d', '%s', '%s', '%ld', '%ld', '%ld', '%ld' , '%ld', '%ld', '%ld', '%ld', '%s', '%s', '%s', '%ld', '%ld', '%s', '%s', '%ld', '%s', '%s', '%s', '%s');",
        "INSERT INTO errlog VALUES ",
        gd.ms.inip_addr[pd->rec.fdno][0],
        gd.ms.inip_addr[pd->rec.fdno][1],
        gd.ms.inip_addr[pd->rec.fdno][2],
        gd.ms.inip_addr[pd->rec.fdno][3],
        pd->rec.user,
        "CONNECT",
        u_time(),
        ctime_getr('y'),
        ctime_getr('m'),
        ctime_getr('d'),
        ctime_getr('h'),
        ctime_getr('i'),
        ctime_getr('s'),
        0,
        "NOT",
        "NOT",
        "NOT",
        0,
        0,
        pd->rec.info,
        "sitar client new connection.",
        1,
        "NON",
        "NON",
        "NON",
        "NON");

      #ifdef POSTGRES_DEBUG
      printf("%s\n", swap);
      #endif

      pthread_mutex_lock(&pg_mutex);
      pqexec_datain(swap);
      pthread_mutex_unlock(&pg_mutex);
      free(swap);
      #endif

      #ifndef BIG_WOOD
      if(gd.md.in_mailonoff == 1){
         mail_grsend(pd->mail.server,
                  pd->mail.from,
                  pd->mail.rcptto,
                  pd->mail.cc,
                  pd->rec.def_user,
                  pd->rec.info,
                  CLIENT_BODY_5, 
                  "new connection");
         }
      #endif

      stat = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK\n",
         //   (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
              gd.bs.life_int);
      } 
   else {
      fprintf(stderr,"This account is used.\n");
      socket_send(gd.ms.sk[pd->rec.fdno],"500 NG This account is used.\n",
    //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
        gd.bs.life_int);

      stat = -1;
      return(stat);
      }
   }
else {
   fprintf(stderr,"The permission is illegal.\n");
   socket_send(gd.ms.sk[pd->rec.fdno],"500 NG No User&IP!\n",
 //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
     gd.bs.life_int);
   stat = -1;
   return(stat);
   }

return(stat);
}





/*--------------- DIF_LOGIC ------------------- */
int dif_logi(private_data_t * pd)
{
static int stat;

char * swap = (char *)calloc(IP_LEN, sizeof(char));

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

stat = 0; 
if(ustat == 0 && astat != 0 && cgstat != 0){ 
  #ifdef LOG_OUT
  pthread_mutex_lock(&con_mutex);
  log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data, gd.ms.inip_addr[pd->rec.fdno]);
  pthread_mutex_unlock(&con_mutex);
  #endif
  if(0 == (memcmp("COMAND", pd->rec.data, 6))){
//   swap = file_send(gd.ms.sk[pd->rec.fdno],
     swap = diff_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.bat_filename, swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  if(0 == (memcmp("PORT", pd->rec.data, 4))){
//   swap = file_send(gd.ms.sk[pd->rec.fdno],
     swap = diff_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.scan_filename,
                  swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  }
else{
  stat = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG BAT command.\n",
      //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);
  } 

free(swap);
return(stat);
}







/*--------------- BAT_LOGIC ------------------- */
int bat_logi(private_data_t * pd)
{
static int stat;

char * swap = (char *)calloc(IP_LEN, sizeof(char));

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

stat = 0; 
if(ustat == 0 && astat != 0 && cgstat != 0){ 
  #ifdef LOG_OUT
  pthread_mutex_lock(&con_mutex);
  log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data, gd.ms.inip_addr[pd->rec.fdno]);
  pthread_mutex_unlock(&con_mutex);
  #endif
  if(0 == (memcmp("COMAND", pd->rec.data, 6))){
     swap = file_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.bat_filename, swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  if(0 == (memcmp("PORT", pd->rec.data, 4))){
     swap = file_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.scan_filename,
                  swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  if(0 == (memcmp("CONFIG", pd->rec.data, 6))){
     swap = file_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.conf_filename,
                  swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  if(0 == (memcmp("STAT", pd->rec.data, 4))){
     swap = file_send(gd.ms.sk[pd->rec.fdno],
                  pd->file.stat_filename,
                  swap,
                  &stat,
                  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     }
  }
else{
  stat = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG BAT command.\n",
      //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);
  } 

free(swap);
return(stat);
}



/*--------------- SET_LOGIC ------------------- */
int set_logi(private_data_t * pd)
{
static int ret;
int stat;

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

ret = 0; 
if(ustat == 0 && astat != 0 && cgstat != 0){ 
  #ifdef LOG_OUT
  pthread_mutex_lock(&con_mutex);
  log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data, gd.ms.inip_addr[pd->rec.fdno]);
  pthread_mutex_unlock(&con_mutex);
  #endif
  stat = client_set(pd);

  if(stat == 1){
     ret = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK client set.\n",
        //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
            gd.bs.life_int);
     }
  else{
     ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG Not client set.\n",
        //   (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
             gd.bs.life_int);
     }
  }
else{
  ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG No permit.\n",
     //  (gd.bs.life_int + gd.bs.life_los + INT_PLUS));
         gd.bs.life_int);
  } 
return(ret);
}








/*--------------- SETG_LOGIC ------------------- */
int setg_logi(private_data_t * pd)
{
static int ret;
int stat;

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

ret = 0; 
if(ustat == 0 && astat == 0 && cgstat != 0){ 
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data, gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif

   stat = client_setg(pd);

   if(stat == 1){
      ret = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK client set.\n",
         //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
             pd->life.life_int);
      }
   else{
      ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG Not client set.\n",
         //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
              pd->life.life_int);
      }
   }
else{
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG The name is different.\n",
       //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
           pd->life.life_int);
   } 
return(ret);
}





/* --------------- LIFE THREAD ----------------- */ 
int life_thread(private_data_t * pd)
{
long int intime = 0;
long int oldtime = 0; 
int lostime = 0;
int count = 0;

pthread_detach(pthread_self());

#ifdef LIFE_DEBUG
printf("LIFE THREAD_START> %s\n", pd->rec.def_user);
#endif

oldtime = pd->life.in_life[0];

for(count = (pd->life.life_int + pd->life.life_los + 1); count > 0; count--){
   sleep(1);
   #ifdef LIFE_DEBUG
   printf("LIFE THREAD_SLEEP_COUNT> %s count=%d life_cancel=%d\n", pd->rec.def_user, count, pd->life.cancel);
   #endif
   if( pd->life.cancel == -1 ){
      return 0;
      }
   }

#ifdef LIFE_DEBUG
printf("LIFE THREAD_TIME_STAT> %s oldtime=%ld in_life=%ld\n", pd->rec.def_user, oldtime, pd->life.in_life[0]);
#endif

if(oldtime == pd->life.in_life[0]){
   intime = u_time();
   lostime = intime - pd->life.in_life[0];

   #ifdef LIFE_DEBUG
   printf("LIFE ERR_MAIL_SEND (2)> %s\n", pd->rec.def_user);
   #endif

   pd->life.swap4 = safe_sprintf(pd->life.swap4, BUF_MAX,
    "%s %d %s", CLIENT_HEAD_1, CLIENT_HEAD_2, lostime);

   if(gd.md.in_mailonoff == 1){
      mail_grsend(pd->mail.server,
               pd->mail.from,
               pd->mail.rcptto,
               pd->mail.cc,
               pd->rec.def_user,
               pd->rec.info,
               pd->life.swap4,
               CLIENT_BODY_6);
      }

   }

#ifdef LIFE_DEBUG
printf("LIFE THREAD_STOP> %s\n", pd->rec.def_user);
#endif

return 0;
}



/*--------------- LIFE_LOGIC ------------------- */
int life_logi(private_data_t * pd)
{
static int ret;
int checktime = 0;
int bstat =0;
int cstat =0;
int fstat =0;
int sstat =0;

char * swap2 = (char *)calloc(IP_LEN, sizeof(char));
char * swap3 = (char *)calloc(IP_LEN, sizeof(char));

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));


ret = 0; 
if(ustat == 0 && astat != 0 && cgstat != 0){ 
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com,
    "LIFE command reception", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif


   if(pd->life.onoff == 1){
      // life thread 
      pthread_create( &pd->life.life_t, NULL, (void *)life_thread, pd );
      checktime = life_check(pd);
      #ifdef LIFE_DEBUG
      printf("LIFE CHECK_TIME> %s >checktime=%d life_los=%d\n",
        pd->rec.def_user, checktime, pd->life.life_los);
      #endif

      // life mail send
      if(checktime >= pd->life.life_los){ 
         pd->life.swap1 = safe_sprintf(pd->life.swap1, BUF_MAX,
            "%s %s %d", CLIENT_HEAD_1, CLIENT_HEAD_2, checktime);

         if(gd.md.in_mailonoff == 1){
            mail_grsend(pd->mail.server,
                     pd->mail.from,
                     pd->mail.rcptto,
                     pd->mail.cc,
                     pd->rec.def_user,
                     pd->rec.info,
                     pd->life.swap1,
                     CLIENT_BODY_6);
            }
         #ifdef LIFE_DEBUG
         printf("LIFE ERR_MAIL_SEND (1)> %s\n", pd->rec.def_user);
         #endif
         }
      }
   else{
      #ifdef LIFE_DEBUG
      printf("LIFE NOT START pd->life.onoff=%d\n", pd->life.onoff);
      #endif
      }

   pd->life.bat_stat = stat_check(pd->life.bat_stat, pd->file.bat_filename, TIME_LEN, &bstat);
   pd->life.scan_stat = stat_check(pd->life.scan_stat, pd->file.scan_filename, TIME_LEN, &cstat);
   pd->life.conf_stat = stat_check(pd->life.conf_stat, pd->file.conf_filename, TIME_LEN, &fstat);
   pd->life.stat_stat = stat_check(pd->life.stat_stat, pd->file.stat_filename, TIME_LEN, &sstat);

      swap2 = safe_memcpy(swap2, "CHECK", BUF_SLEN);
   if(0 > bstat){
      swap2 = safe_strncat(swap2, "_BAT", BUF_SLEN);
      }
   if(0 > cstat){
      swap2 = safe_strncat(swap2, "_SCA", BUF_SLEN);
      }
   if(0 > fstat){
      swap2 = safe_strncat(swap2, "_CONF", BUF_SLEN);
      }
   if(0 > sstat){
      swap2 = safe_strncat(swap2, "_STAT", BUF_SLEN);
      }

   if(0 == memcmp(swap2, "CHECK_", 6) && 5 < (int)strlen(swap2)){
      swap3 = safe_sprintf(swap3, BUF_MAX,"%s 200 OK\n", swap2);
      #ifdef LIFE_DEBUG
      printf("LIFE SEND> %s > %s\n", pd->rec.def_user, swap3);
      #endif
      ret = socket_send(gd.ms.sk[pd->rec.fdno], swap3,
              pd->life.life_int);
      }
   else{
      ret = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK\n",
              pd->life.life_int);
      #ifdef LIFE_DEBUG
      printf("LIFE SEND> %s > 200OK\n", pd->rec.def_user);
      #endif
      }

   }
else{
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n",
           pd->life.life_int);
   #ifdef LIFE_DEBUG
   printf("LIFE SEND> %s > 500OK\n", pd->rec.def_user);
   #endif
   } 


free(swap2);
free(swap3);

return(ret);
}






/*--------------- GLOBAL DATA LIST(FOR DEBUG) --------------- */
int global_data_list(private_data_t * pd)
{
int ret;
ret = 0;

char * putdata = (char *)calloc(IP_LEN, sizeof(char));

if(0 == memcmp(pd->rec.user, "administrator", 13)){
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com,
    "check global data struct.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif
   putdata = safe_sprintf(putdata, BUF_MAX,
   "200 KO\n%s%s\n%s%d\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%d\n%s%d\n%s%d\n%s%d\n%s%s\n",
     "gd.ms.ip_addr:       ",gd.ms.ip_addr,
     "gd.ms.port:          ",gd.ms.port,
     "gd.ms.max_count:     ",gd.ms.max_count,
     "gd.fp.lock_path:     ",gd.fp.lock_path,
     "gd.fp.file_conf:     ",gd.fp.file_conf,
     "gd.fp.neg_conf:      ",gd.fp.neg_conf,
     "gd.md.ch_MailFrom:   ",gd.md.ch_MailFrom,
     "gd.md.ch_MailRcptTo: ",gd.md.ch_MailRcptTo,
     "gd.md.ch_MailServ:   ",gd.md.ch_MailServ,
     "gd.md.ch_MailCc:     ",gd.md.ch_MailCc,
     "gd.bs.life_int:      ",gd.bs.life_int,
     "gd.bs.life_los:      ",gd.bs.life_los,
     "gd.exid.uid:         ",gd.exid.uid,
     "gd.md.in_mailonoff:  ",gd.md.in_mailonoff,
     "CL_VAR:              ",CL_VAR);

   swap_mem(putdata, '\n', ';', (int)strlen(putdata));
   putdata = safe_strncat(putdata, "\n", BUF_MAX);

   ret = socket_send(gd.ms.sk[pd->rec.fdno], putdata,
          pd->life.life_int);
   }
else{
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n",
          pd->life.life_int);
   } 

free(putdata);
return ret ;
}









/*--------------- VER_LOGIC -------------------*/
int ver_logi(private_data_t * pd)
{
static int ret;

char * putdata = (char *)calloc(IP_LEN, sizeof(char));

ret = 0;
putdata = safe_sprintf(putdata, BUF_MAX, "200 KO \n  %s\n  http://zither.ms-n.com\n", CL_VAR);
socket_send(gd.ms.sk[pd->rec.fdno], putdata,
//(pd->life.life_int + pd->life.life_los + INT_PLUS));
  pd->life.life_int);

ret = -1;
free(putdata);
return(ret);
}


/*--------------- VERS_LOGIC ------------------- */
int vers_logi(private_data_t * pd)
{
static int ret;
 
int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

char * putdata = (char *)calloc(IP_LEN, sizeof(char));

ret = 0;
if(ustat == 0 || astat == 0 || cgstat == 0){ 
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "version checkd.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif
   putdata = safe_sprintf(putdata, BUF_MAX, "200 KO\n%s\nhttp://zither.ms-n.com\n", CL_VAR);
   ret = socket_send(gd.ms.sk[pd->rec.fdno], putdata,
       //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
           pd->life.life_int);
   }
else{
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n",
      //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
           pd->life.life_int);
   } 

free(putdata);
return(ret);
}



/*--------------- GET_LOGIC (User) -------------------*/
int get_logi(private_data_t * pd)
{
static int ret;

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));

char * putdata = (char *)calloc(IP_LEN, sizeof(char));

ret = 0; 
if(ustat == 0 && astat == 0){ 
   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "get is no members.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif
   putdata = safe_sprintf(putdata, BUF_MAX, "200 KO \n  %s\n  http://zither.ms-n.com\n  GET is no members\n", CL_VAR);
   ret = socket_send(gd.ms.sk[pd->rec.fdno], putdata,
       //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
           pd->life.life_int);
   }
else{
   ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n",
      //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
           pd->life.life_int);
   } 

free(putdata);
return(ret);
}




/*--------------- PUT_LOGIC -------------------*/
int put_logi(private_data_t * pd)
{
static int ret;
int stat = 0;

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

ret = 0; 
if(ustat == 0 && astat != 0 && cgstat != 0){ 
  #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
  log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, pd->rec.data, gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
  #endif

  stat = file_set(pd);

  if(stat == 1){
     ret = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK file set.\n",
         //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
             pd->life.life_int);
     }
  else{
     ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG Not file set.\n",
         //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
             pd->life.life_int);
     }
  }
else{
  ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG No permit.\n",
       // (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);
  } 

return(ret);
}




/*--------------- QUIT_LOGIC ------------------- */
int quit_logi(private_data_t * pd)
{
static int ret;

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

ret = 0; 
if(ustat == 0 || astat == 0 || cgstat == 0){ 

   if(gd.md.in_mailonoff == 1){
      mail_grsend(pd->mail.server,
               pd->mail.from,
               pd->mail.rcptto,
               pd->mail.cc,
               pd->rec.def_user,
               pd->rec.info,
               CLIENT_BODY_7,
               CLIENT_BODY_8);
      }

   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "It ends by the QUIT command.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif
   socket_send(gd.ms.sk[pd->rec.fdno], "200 OK wait close connection.\n",
  // (pd->life.life_int + pd->life.life_los + INT_PLUS));
     pd->life.life_int);

   ret = -1;
   }
else{
   socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n",
 //  (pd->life.life_int + pd->life.life_los + INT_PLUS));
     pd->life.life_int);
   ret = -1;
   } 

return(ret);
}






/*--------------- ERR_LOGIC ------------------ */
int err_logi(private_data_t * pd)
{
static int ret;
ret = 0; 

int ustat = memcmp(pd->rec.user, pd->rec.def_user, strlen(pd->rec.def_user)); 
int astat = memcmp(pd->rec.user, "administrator", strlen(pd->rec.user));
int cgstat = memcmp(pd->rec.user, "cgiuser", strlen(pd->rec.user));

if(ustat == 0 && astat != 0 && cgstat != 0){ 

  #ifdef LOG_OUT
  pthread_mutex_lock(&con_mutex);
  log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "Error transmission", gd.ms.inip_addr[pd->rec.fdno]);
  pthread_mutex_unlock(&con_mutex);
  #endif
  ret = socket_send(gd.ms.sk[pd->rec.fdno], "200 OK get err data\n",
     //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);

  if(2 <= strlen(pd->rec.data)){
    /* mail to cc default set */
     pd->rec.user_org = safe_memcpy(pd->rec.user_org, pd->rec.user, BUF_LEN);
     pd->mail.rcptto_org = safe_memcpy(pd->mail.rcptto_org, pd->mail.rcptto, BUF_LEN);
     pd->mail.cc_org = safe_memcpy(pd->mail.cc_org, pd->mail.cc, BUF_LEN);
     pd->mail.in_mailonoff = gd.md.in_mailonoff;

     errdata_tok(pd, gd.ms.inip_addr[pd->rec.fdno]);
    }

  }
else{
  ret = socket_send(gd.ms.sk[pd->rec.fdno], "500 NG\n", 
     //   (pd->life.life_int + pd->life.life_los + INT_PLUS));
          pd->life.life_int);
  } 

return(ret);
}




/* char * errdata_tok(private_data_t * pd, unsigned char * ip) */
int errdata_tok(private_data_t * pd, unsigned char * ip)
{
int maxlen, maxdel, ret, middleno;
char * swap = (char *)calloc(IP_LEN, sizeof(char));
char * swapdata = (char *)calloc(IP_LEN, sizeof(char));
char * tmp;

middleno = 0;

swap = safe_memcpy(swap, pd->rec.data, BUF_MAX);
maxlen = strlen(swap);
maxdel = char_count(swap, ';');
ret = maxdel;

if(0 < maxdel && 13 <= maxlen){
   maxdel--;
   swapdata = safe_memcpy(swapdata, strtok_r(swap, ";", &tmp), BUF_MAX);
   if(20 == char_count(swapdata,',') && 20 <= strlen(swapdata)){ 
      swapdata = check_strtol(swapdata);
      #ifdef ERR_OUT
      pthread_mutex_lock(&err_mutex);
      put_log(gd.fp.errlog, swapdata, pd->rec.user, ip);
      pthread_mutex_unlock(&err_mutex);
      #endif
      swapdata = mail_form(swapdata, pd, ip, &middleno);

      if(middleno == 1){
         pd->rec.data = safe_memcpy(pd->rec.data, MAIL_BODY_1, BUF_MAX);
         #ifdef MAIL_DEBUG
         printf("MAIL CHECK2 <%s>\n", pd->rec.data);
         #endif
         middleno = 0;
         }
      else if(middleno == 2){
         pd->rec.data = safe_memcpy(pd->rec.data, MAIL_BODY_2, BUF_MAX);
         #ifdef MAIL_DEBUG
         printf("MAIL CHECK2 <%s>\n", pd->rec.data);
         #endif
         middleno = 0;
         }
      else{
         pd->rec.data = safe_memcpy(pd->rec.data, swapdata, BUF_MAX);
         }

      }
   else{
      pd->rec.data = safe_sprintf(pd->rec.data, BUF_MAX, "Broken data. %s\n\n", swapdata);
      }

   for(;0 < maxdel; maxdel--){
      swapdata = safe_memcpy(swapdata, strtok_r(NULL, ";", &tmp), BUF_MAX);
      if(20 == char_count(swapdata,',') && 20 <= strlen(swapdata)){ 
         swapdata = check_strtol(swapdata);
         #ifdef ERR_OUT
         pthread_mutex_lock(&err_mutex);
         put_log(gd.fp.errlog, swapdata, pd->rec.user, ip);
         pthread_mutex_unlock(&err_mutex);
         #endif
         swapdata = mail_form(swapdata, pd, ip, &middleno);
         pd->rec.data = safe_strncat(pd->rec.data, swapdata, BUF_MAX);
         }
      else{
         pd->rec.data = safe_sprintf(pd->rec.data, BUF_MAX, "Broken data. %s\n\n", swapdata);
         }
      }
   }
else{
   pd->rec.data = safe_sprintf(pd->rec.data, BUF_MAX, "Broken data. %s\n\n", swap);
   }

pd->rec.minfo = safe_sprintf(pd->rec.minfo, BUF_MAX, 
   "%s %s %s", CLIENT_HEAD_3, pd->rec.info, CLIENT_HEAD_4);

if(2 <= strlen(pd->rec.data)){

   swap_mem(pd->rec.data, '\n', (char)0x01, strlen(pd->rec.data));
   if(pd->mail.in_mailonoff == 1){
      mail_grsend(pd->mail.server,
               pd->mail.from,
               pd->mail.rcptto_org,
               pd->mail.cc_org,
               pd->rec.user_org,
               pd->rec.minfo,
               pd->rec.data,
               CLIENT_BODY_9);
     }
  }


// pd->mail.rcptto_org = safe_memcpy(pd->mail.rcptto_org, pd->mail.rcptto, BUF_LEN);
// pd->mail.cc_org = safe_memcpy(pd->mail.cc_org, pd->mail.cc, BUF_LEN);

free(swap);
free(swapdata);

/* return pd->rec.data; */
return ret;
}






char * mail_form(char * swap, private_data_t * pd, unsigned char * chIpadd, int * middleno)
{
int pri, ret;

pri = 0;
ret = 0;

char * tool = (char *)calloc(2, sizeof(char));
char * utime = (char *)calloc(2, sizeof(char));
char * year = (char *)calloc(2, sizeof(char));
char * month = (char *)calloc(2, sizeof(char));
char * day = (char *)calloc(2, sizeof(char));
char * hour = (char *)calloc(2, sizeof(char));
char * minute = (char *)calloc(2, sizeof(char));
char * seconds = (char *)calloc(2, sizeof(char));
char * stat = (char *)calloc(2, sizeof(char));
char * prot = (char *)calloc(2, sizeof(char));
char * com = (char *)calloc(2, sizeof(char));
char * host = (char *)calloc(2, sizeof(char));
char * port = (char *)calloc(2, sizeof(char));
char * timeout = (char *)calloc(2, sizeof(char));
char * data = (char *)calloc(2, sizeof(char));
char * info = (char *)calloc(2, sizeof(char));
char * plai = (char *)calloc(2, sizeof(char));
char * free1 = (char *)calloc(2, sizeof(char));
char * free2 = (char *)calloc(2, sizeof(char));
char * free3 = (char *)calloc(2, sizeof(char));
char * free4 = (char *)calloc(2, sizeof(char));

swap_mem(swap, '\'', ' ', (int)strlen(swap));

tool = delim_get(swap, tool, ',', &ret, 0);
utime = delim_get(swap, utime, ',', &ret, 1);
year = delim_get(swap, year, ',', &ret, 2);
month = delim_get(swap, month, ',', &ret, 3);
day = delim_get(swap, day, ',', &ret, 4);
hour = delim_get(swap, hour, ',', &ret, 5);
minute = delim_get(swap, minute, ',', &ret, 6);
seconds = delim_get(swap, seconds, ',', &ret, 7);
stat = delim_get(swap, stat, ',', &ret, 8);
prot = delim_get(swap, prot, ',', &ret, 9);
com = delim_get(swap, com, ',', &ret, 10);
host = delim_get(swap, host, ',', &ret, 11);
port = delim_get(swap, port, ',', &ret, 12);
timeout = delim_get(swap, timeout, ',', &ret, 13);
data = delim_get(swap, data, ',', &ret, 14);
info = delim_get(swap, info, ',', &ret, 15);
plai = delim_get(swap, plai, ',', &ret, 16);
free1 = delim_get(swap, free1, ',', &ret, 17);
free2 = delim_get(swap, free2, ',', &ret, 18);
free3 = delim_get(swap, free3, ',', &ret, 19);
free4 = delim_get(swap, free4, ',', &ret, 20);

#ifdef MAIL_DEBUG
printf("TOOL=%s STAT=%s\n", tool, stat);
#endif

if(0 == memcmp(tool, "SET", 3)){
   #ifdef DEBUG
   printf(" Geting SET free1=%s free2=%s free3=%s free4=%s\n", free1, free2, free3, free4);
   #endif

   if(0 == self_memcmp(info, "MID2")){
      * middleno = 1;
      }
   if(0 == self_memcmp(info, "MIX2")){
      * middleno = 2;
      }

   /* set mail on off */
   if(0 != memcmp(free1, "NOT", 3) && 2 <= strlen(free1)){
      if(0 == memcmp(free1, "ON", 2)){
         /* user side mail on off set */
         pd->mail.in_mailonoff = gd.md.in_mailonoff;
         }
      else if(0 == memcmp(free1, "OFF", 3)){
         /* user side mail on off set */
         pd->mail.in_mailonoff = 0;
         }
      else{
         /* user side mail on off set */
         pd->mail.in_mailonoff = gd.md.in_mailonoff;
         }
      }
   else{
      pd->mail.in_mailonoff = gd.md.in_mailonoff;
      }

   #ifdef DEBUG
   printf("user side mail on off = %d\n", pd->mail.in_mailonoff);
   #endif

   /*  set User name */ 
   if(0 != memcmp(free4, "NOT", 3) && 4 <= strlen(free4)){
      /* user side user name set */
      pd->rec.user_org = safe_memcpy(pd->rec.user_org, free4, BUF_LEN);
      }
   else{
      pd->rec.user_org = safe_memcpy(pd->rec.user_org, pd->rec.user, BUF_LEN);
      }

   /*  set To: */ 
   if(0 != memcmp(free2, "NOT", 3) && 4 <= strlen(free2) && 2 <= char_point(free2, '@', 1)){
      /* user side mail.rcptto set */
      pd->mail.rcptto_org = safe_memcpy(pd->mail.rcptto_org, free2, BUF_LEN);
      pd->mail.cc_org = safe_memcpy(pd->mail.cc_org, " ", BUF_LEN);
      swap_mem( pd->mail.rcptto_org, '|', ',', (int)strlen(pd->mail.rcptto_org));

      /*  set Cc: */ 
      if(0 != memcmp(free3, "NOT", 3) && 4 <= strlen(free3) && 2 <= char_point(free3, '@', 1)){
         /* user side mail.rcptto set */
         pd->mail.cc_org = safe_memcpy(pd->mail.cc_org, free3, BUF_LEN);
         swap_mem( pd->mail.cc_org, '|', ',', (int)strlen(pd->mail.cc_org));
         }

      }
   else{
      pd->mail.rcptto_org = safe_memcpy(pd->mail.rcptto_org, pd->mail.rcptto, BUF_LEN);
      pd->mail.cc_org = safe_memcpy(pd->mail.cc_org, pd->mail.cc, BUF_LEN);
      printf("2 default rcptto %s\n", pd->mail.rcptto_org);
      printf("2 default cc %s\n", pd->mail.cc_org);
      }

   clean_mem(swap, (char)0x00, (int)strlen(swap));
   goto mail_form_end;
   }


#ifdef POSTGRES_IN
swap = safe_sprintf(swap, BUF_MAX, "%s('%d.%d.%d.%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s');",
     "INSERT INTO errlog VALUES ",
     chIpadd[0],
     chIpadd[1],
     chIpadd[2],
     chIpadd[3],
     pd->rec.user,
     tool,
     utime,
     year,
     month,
     day,
     hour,
     minute,
     seconds,
     stat,
     prot,
     com,
     host,
     port,
     timeout,
     data,
     info,
     plai,
     free1,
     free2,
     free3,
     free4);

#ifdef POSTGRES_DEBUG
printf("PG_INDATA > %s\n", swap);
#endif

swap_mem(swap, (char)0x01, '\n', (int)strlen(swap));


/* data insert */
pthread_mutex_lock(&pg_mutex);
pqexec_datain(swap);
pthread_mutex_unlock(&pg_mutex);
#endif

if(1 == strlen(plai)){
   pri = strtol(plai, (char **)NULL, 10);
   }
else{
   pri = 3;
   fprintf(stderr,"mail_form(): plai size err %s\n", plai);
   }

if(pri < 3){
   /* --- mail format --- */
   if(0 == memcmp(tool, "INFO", 4)){
      swap = safe_sprintf(swap, BUF_MAX, "%s\n\n",
        MAIL_DATA_1);
      }
   if(0 == memcmp(tool, "SNMP", 4)){
      swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
        MAIL_SNMP_11,
        MAIL_SNMP_12,
        plai,
        MAIL_SNMP_13,
        prot,
        MAIL_SNMP_14,
        host,
        MAIL_SNMP_15,
        com,
        MAIL_SNMP_16,
        free1,
        MAIL_SNMP_17,
        data,
        MAIL_SNMP_18,
        info);
      }

   if(0 == memcmp(stat, "0", 1) && 0 == memcmp(tool, "PORT", 4)){
      if(0 == memcmp(prot, "DHW", 3)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_DHW_11,
           MAIL_DHW_12,
           plai,
           MAIL_DHW_13,
           prot,
           MAIL_DHW_14,
           host,
           MAIL_DHW_15,
           com,
           MAIL_DHW_16,
           timeout,
           MAIL_DHW_17,
           free1,
           MAIL_DHW_18,
           data,
           MAIL_DHW_19,
           info);
         }
      else if(0 == memcmp(prot, "URL", 3)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_URL_11,
           MAIL_URL_12,
           plai,
           MAIL_URL_13,
           prot,
           MAIL_URL_14,
           host,
           MAIL_URL_15,
           port,
           MAIL_URL_16,
           timeout,
           MAIL_URL_17,
           free1,
           MAIL_URL_18,
           data,
           MAIL_URL_19,
           info);
         }
      else if(0 == memcmp(prot, "SMTP", 4)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_SMTP_11,
           MAIL_SMTP_12,
           plai,
           MAIL_SMTP_13,
           prot,
           MAIL_SMTP_14,
           host,
           MAIL_SMTP_15,
           port,
           MAIL_SMTP_16,
           timeout,
           MAIL_SMTP_17,
           free1,
           MAIL_SMTP_18,
           data,
           MAIL_SMTP_19,
           info);
         }
      else if(0 == memcmp(prot, "SNTP", 4)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_NTP_11,
           MAIL_NTP_12,
           plai,
           MAIL_NTP_13,
           prot,
           MAIL_NTP_14,
           host,
           MAIL_NTP_15,
           port,
           MAIL_NTP_16,
           timeout,
           MAIL_NTP_17,
           free1,
           MAIL_NTP_18,
           data,
           MAIL_NTP_19,
           info);
         }
      else{
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_PORT_11,
           MAIL_PORT_12,
           plai,
           MAIL_PORT_13,
           prot,
           MAIL_PORT_14,
           host,
           MAIL_PORT_15,
           port,
           MAIL_PORT_16,
           timeout,
           MAIL_PORT_17,
           free1,
           MAIL_PORT_18,
           data,
           MAIL_PORT_19,
           info);
         }
      }

   if(0 == memcmp(stat, "1", 1) && 0 == memcmp(tool, "PORT", 4)){
      if(0 == memcmp(prot, "DHW", 3)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_DHW_21,
           MAIL_DHW_22,
           plai,
           MAIL_DHW_23,
           prot,
           MAIL_DHW_24,
           host,
           MAIL_DHW_25,
           com,
           MAIL_DHW_26,
           timeout,
           MAIL_DHW_27,
           free1,
           MAIL_DHW_28,
           data,
           MAIL_DHW_29,
           info);
         }
      else if(0 == memcmp(prot, "URL", 3)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_URL_21,
           MAIL_URL_22,
           plai,
           MAIL_URL_23,
           prot,
           MAIL_URL_24,
           host,
           MAIL_URL_25,
           port,
           MAIL_URL_26,
           timeout,
           MAIL_URL_27,
           free1,
           MAIL_URL_28,
           data,
           MAIL_URL_29,
           info);
         }
      else if(0 == memcmp(prot, "SMTP", 4)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_SMTP_21,
           MAIL_SMTP_22,
           plai,
           MAIL_SMTP_23,
           prot,
           MAIL_SMTP_24,
           host,
           MAIL_SMTP_25,
           port,
           MAIL_SMTP_26,
           timeout,
           MAIL_SMTP_27,
           free1,
           MAIL_SMTP_28,
           data,
           MAIL_SMTP_29,
           info);
         }
      else if(0 == memcmp(prot, "SNTP", 4)){
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_NTP_21,
           MAIL_NTP_22,
           plai,
           MAIL_NTP_23,
           prot,
           MAIL_NTP_24,
           host,
           MAIL_NTP_25,
           port,
           MAIL_NTP_26,
           timeout,
           MAIL_NTP_27,
           free1,
           MAIL_NTP_28,
           data,
           MAIL_NTP_29,
           info);
         }
      else{
         swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
           MAIL_PORT_21,
           MAIL_PORT_22,
           plai,
           MAIL_PORT_23,
           prot,
           MAIL_PORT_24,
           host,
           MAIL_PORT_25,
           port,
           MAIL_PORT_26,
           timeout,
           MAIL_PORT_27,
           free1,
           MAIL_PORT_28,
           data,
           MAIL_PORT_29,
           info);
         }
      }

   if(0 == memcmp(stat, "0", 1) && 0 == memcmp(tool, "COMAND", 6)){
      swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
        MAIL_COMMAND_11,
        MAIL_COMMAND_12,
        plai,
        MAIL_COMMAND_13,
        com,
        MAIL_COMMAND_14,
        timeout,
        MAIL_COMMAND_15,
        free1,
        MAIL_COMMAND_16,
        data,
        MAIL_COMMAND_17,
        info);
      }

   if(0 == memcmp(stat, "1", 1) && 0 == memcmp(tool, "COMAND", 6)){
      swap = safe_sprintf(swap, BUF_MAX, "%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n\n",
        MAIL_COMMAND_21,
        MAIL_COMMAND_22,
        plai,
        MAIL_COMMAND_23,
        com,
        MAIL_COMMAND_24,
        timeout,
        MAIL_COMMAND_25,
        free1,
        MAIL_COMMAND_26,
        data,
        MAIL_COMMAND_27,
        info);
      }
   /* -----        ------ */
   }
else{
   clean_mem(swap, (char)0x00, (int)strlen(swap));
   }


mail_form_end :;

free(tool);
free(utime);
free(year);
free(month);
free(day);
free(hour);
free(minute);
free(seconds);
free(stat);
free(prot);
free(com);
free(host);
free(port);
free(timeout);
free(data);
free(info);
free(plai);
free(free1);
free(free2);
free(free3);
free(free4);

return swap;
}






char * check_strtol(char * data)
{
int count, count0;
int cmax = (int)strlen(data);

char * swap = (char *)calloc((cmax + 60), sizeof(char));

count0 = 0;
for(count = 0; count < cmax; count++){
   switch(data[count]){
      case ',' :
                 if(data[count - 1] == ','){
                    swap[count0] = 'N';
                    count0++;
                    swap[count0] = 'O';
                    count0++;
                    swap[count0] = 'T';
                    count0++;
                    swap[count0] = ',';
                    }
                 else{
                    swap[count0] = data[count];
                    }
                 break;
      default  :
                 swap[count0] = data[count];
                 break;
      }
   count0++;
   }

swap[count0] = (char)0x00;
data = safe_memcpy(data, swap, BUF_MAX);

free(swap);

return data;
}







/* --------------- COM CHECK ------------------ */
int com_check(char * chCOM)
{
static int buck;
char ch[15][IP_LEN];
int count=0;

char * non="NON";
char * get="GET";
char * put="PUT";
char * life="LIFE";
char * quit="QUIT";
char * ver="VER";
char * neg="NEG";
char * bat="BAT";
char * err="ERR";
char * set="SET";
char * stat="STAT";
char * setg="SETG";
char * statg="STATG";
char * dif="DIF";

memcpy(ch[0], non, strlen(get)+1);
memcpy(ch[1], get, strlen(get)+1);
memcpy(ch[2], put, strlen(put)+1);
memcpy(ch[3], life, strlen(life)+1);
memcpy(ch[4], quit, strlen(quit)+1);
memcpy(ch[5], ver, strlen(ver)+1);
memcpy(ch[6], neg, strlen(neg)+1);
memcpy(ch[7], bat, strlen(bat)+1);
memcpy(ch[8], err, strlen(err)+1);
memcpy(ch[9], set, strlen(set)+1);
memcpy(ch[10], stat, strlen(stat)+1);
memcpy(ch[11], setg, strlen(setg)+1);
memcpy(ch[12], statg, strlen(statg)+1);
memcpy(ch[13], dif, strlen(dif)+1);

buck = 0;
if(IP_LEN > (int)strlen(chCOM)){
   for(count=0; count < 14; count++){
      if(0 == memcmp(chCOM, ch[count], (int)strlen(ch[count])+1)){
         buck=count;
         }
      }
   }
else{
   fprintf(stderr,"big size mess err. %s\n", chCOM);
   return 0;
   }
return(buck);
}




