// difference_onset.c
// $Id: difference_onset.c,v 1.1 2007/07/13 06:52:59 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * difference_onset(char * diff_data, char * old_filename, int * ret, int len)
{
int diff_count, diff_stat, old_count, old_stat;
FILE * fp_old;
char * swap_data;
char * old_data;


// バッファーのセット
* ret = 0;

diff_count = 0, diff_stat = 0, old_count = 0, old_stat = 0;

if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((old_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}


// 編集前ファイルを一次元バッファーに入れる (OLD)
if((fp_old = fopen(old_filename, "r"))!=NULL){
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_onset(1): open old filename <%s>:\n", old_filename);
   #endif
   for(old_count = 0; old_count < len && old_stat > -1; old_count++){
      swap_data = safe_fpcat(fp_old, swap_data, &old_stat, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, swap_data, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, "\n", MAX_BUFF_COUNT);
      }
   fclose(fp_old);
   old_count = old_count - 1;
   }
else{
   #ifdef ON_DEBUG_1
   fprintf(stderr,"difference_onset(2): old filename not open. <%s>:\n", old_filename);
   #endif
   free(swap_data);
   free(old_data);
   diff_data = safe_memcpy(diff_data, "\n", MAX_BUFF_COUNT);
   * ret = -1;
   return (diff_data);
   }


// 圧縮された差分を展開
diff_data = diff_uncomp(diff_data);

// printf("----DIFF_DATA:\n%s\n", diff_data);
// printf("----OLD_DATA:\n%s\n", old_data);

// 差分と旧ファイルを結合し戻りバッファに書き込む
swap_data = diff_onset(swap_data, diff_data, old_data, ret, len);
diff_data = safe_memcpy(diff_data, swap_data, BUF_MAX);


// バッファーの開放
free(swap_data);
free(old_data);

return(diff_data);
}




