#include<stdio.h>
#include<stdlib.h>
#include<string.h>

// #include"zither_lint.h"
#include<almemsys/almemsys.h>
#include<libpq-fe.h>

extern PGconn * conn;
extern PGresult * res;


int pqconnect(char * postgres_data)
{
int ret;
ret = 0;

conn = PQconnectdb(postgres_data);
switch(PQstatus(conn)){
   case CONNECTION_STARTED:
        fprintf(stderr, "接続確立待ち postgres.\n");
        break;
   case CONNECTION_MADE:
        fprintf(stderr, "接続OK送信待ち postgres.\n");
        break;
   case CONNECTION_AWAITING_RESPONSE:
        fprintf(stderr, "サーバからの接続待ち postgres.\n");
        break;
   case CONNECTION_BAD:
        fprintf(stderr, "接続出来ない postgres.\n");
        fprintf(stderr, "%s", PQerrorMessage(conn));
        PQfinish(conn);
        ret = -1;
        break;
   default:
        #ifdef POSTGRES_DEBUG
        fprintf(stderr, "正常に接続できました postgres.\n");
        #endif
        ret = 1;
   }

return ret;
}



int pqexec_datain(char * swap)
{
int ret;
ret = 0;

res = PQexec(conn, swap);
if(!res || PQresultStatus(res) != PGRES_COMMAND_OK){
   fprintf(stderr, "インサート出来てないかも \n");
   PQclear(res);
   ret = -1;
   }
else {
   #ifdef POSTGRES_DEBUG
   fprintf(stderr, "インサート成功 \n");
   #endif
   ret = 1;
   PQclear(res);
   }

return ret;
}



char * pqexec_select(char * swap, int * ret)
{
* ret = -1;

res = PQexec(conn, swap);
if(PQresultStatus(res) != PGRES_TUPLES_OK){
   fprintf(stderr, "セレクトできてないかも\n");
   PQclear(res);
   * ret = -1;
   }
else {
   #ifdef POSTGRES_DEBUG
   fprintf(stderr, "セレクトできたかも\n");
   #endif
   * ret = PQntuples(res);
   swap = safe_memcpy(swap, PQgetvalue(res, 0, 0), BUF_MAX);
   swap_mem(swap, ' ', (char)0x00, strlen(swap));
   PQclear(res);
   }

return(swap);
}




