
#include<stdio.h>
#include<time.h>
#include<string.h>
#include<stdlib.h>
#include<sys/stat.h>

#include<almemsys/almemsys.h>

/* char * stat_check(char *, char *, int, int *); */




/* ------------ time_get ---------------  */
char * stat_check(char * buf, char * filename, int *ret)
{
int count2;
char * data = (char *)calloc(BUF_LEN, sizeof(char));
struct tm tmbuf;
struct stat stat_buf;

// filename のステータスを確認
if(0 == stat(filename, &stat_buf)){
   // ステータスからローカル時間をえる
   localtime_r(&stat_buf.st_mtime, &tmbuf);
   // その時間をフォーマットしてdataにいれる
   data = safe_sprintf(data, BUF_LEN,"%04d:%02d:%02d:%02d:%02d:%02d",
      tmbuf.tm_year + 1900,
      tmbuf.tm_mon + 1,
      tmbuf.tm_mday,
      tmbuf.tm_hour,
      tmbuf.tm_min,
      tmbuf.tm_sec);

   // dataの長さをえる
   count2 = (int)strlen(data);
   // もし以前の時間データと今回が異なる場合新しいデータを入れー1を返す
   if(0 != memcmp(buf, data, count2)){
      buf = safe_memcpy(buf, data, BUF_LEN); 

      fprintf(stderr,"stat_check(): data=%s, buf=%s, count=%d\n", data, buf, count2);

      * ret = -1;
      }
   // 違いがない場合は0を返す。
   else {
      * ret = 0;
      }
   }
// filename のステータスが確認出来ない場合
else {
   fprintf(stderr,"stat_check(): not get file stat %s\n", filename);
   buf = safe_memcpy(buf, "0", BUF_LEN); 
   * ret = -1;
   }

#ifdef FILE_DEBUG
fprintf(stdout,"FILE: stat_check(): STAT DATA data=%s , buf=%s , ret=%d\n", data, buf, * ret);
#endif
#ifdef FREE_BUG
printf("FREE: stat_check(): data %s\n", data);
#endif
free(data);
return buf;
} 





