/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.ptrbnd;

import cycinf.cvars.Decision;
import cycinf.cvars.ptrbnd.PointerKind;
import cycinf.cvars.ptrbnd.PointerKindCvar;
import cycinf.cvars.usedtype.UsedTypeLayer;
import cycinf.infstats.DirInfstats;
import cycinf.infstats.DirTracker;
import cycinf.util.SourceLocation;
import cycinf.util.SourceSearch;
import general.util.Validator;
import org.eclipse.core.runtime.CoreException;

public final class PointerInferenceDecision
extends Decision {
    private final PointerKindCvar cvar;
    private final PointerKind origKind;
    private final PointerKind infKind;
    private SourceSearch ss;

    public final PointerKindCvar getCvar() {
        return this.cvar;
    }

    public final PointerKind getOrigKind() {
        return this.origKind;
    }

    public final PointerKind getInfKind() {
        return this.infKind;
    }

    public final PointerKind getCvalue() {
        return this.getInfKind();
    }

    public PointerInferenceDecision(DirInfstats owningInfstats, SourceLocation loc, PointerKindCvar cvar, PointerKind origKind, PointerKind infKind) {
        super(owningInfstats, loc);
        this.cvar = (PointerKindCvar)Validator.nonnull((Object)cvar, (String)"cvar");
        this.origKind = (PointerKind)Validator.nonnull((Object)origKind, (String)"origKind");
        this.infKind = (PointerKind)Validator.nonnull((Object)infKind, (String)"infKind");
        this.ss = SourceSearch.findUsedTypeLayer((DirTracker)owningInfstats.getDir(), (SourceLocation)this.getLocation(), (UsedTypeLayer)this.getCvar().getPointer());
    }

    public String decisionName() {
        return this.getInfKind() == PointerKind.THIN ? "Thin" : "Fat";
    }

    public String description() {
        String pointerDesc = this.getCvar().getPointer().prettyString();
        String decisionDesc = this.getInfKind() == PointerKind.THIN ? "Thin" : "Fat";
        String caveat = this.ss.isConfident() ? "" : " (approximate location)";
        return String.valueOf(decisionDesc) + ": " + pointerDesc + caveat;
    }

    public void mark() throws CoreException {
        if (this.getMarker() == null) {
            super.mark();
            if (this.ss.isConfident()) {
                this.getMarker().setAttribute("charStart", this.ss.getStartPos());
                this.getMarker().setAttribute("charEnd", this.ss.getEndPos());
            }
        }
    }
}

