/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.CvarPiece;
import cycinf.cvars.usedtype.UsedType;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.util.Arrays;

public class UsedTypeLayer
extends CvarPiece {
    private final UsedType type;
    private final int depth;

    public final UsedType getType() {
        return this.type;
    }

    public final int getDepth() {
        return this.depth;
    }

    public UsedTypeLayer(UsedType type, int depth) {
        this.type = (UsedType)Validator.nonnull((Object)type, (String)"type");
        this.depth = Validator.nonnegative((int)depth, (String)"depth");
    }

    public final String toString() {
        return String.valueOf(this.getType().toString()) + "_" + Integer.toString(this.getDepth());
    }

    public final String prettyString() {
        if (this.depth == 0) {
            return this.type.prettyString();
        }
        char[] stars = new char[this.depth];
        Arrays.fill(stars, '*');
        return String.valueOf(String.valueOf(stars)) + "(" + this.type.prettyString() + ")";
    }

    public static UsedTypeLayer parse(String x) throws ParseException {
        String x1 = ParsingUtils.chopNumberSuffix((String)x);
        if (x1 == null) {
            throw new ParseException("UsedTypeLayer expecting a number: " + x);
        }
        int depth = ParsingUtils.nval;
        String typeStr = ParsingUtils.chopSuffix((String)x1, (String)"_");
        if (typeStr == null) {
            throw new ParseException("UsedTypeLayer expecting an underscore: " + x);
        }
        UsedType type = UsedType.parse((String)typeStr);
        return new UsedTypeLayer(type, depth);
    }
}

