/*
 * Decompiled with CFR 0.152.
 */
package cycinf.infstats;

import cycinf.cvars.Decision;
import cycinf.infstats.DirInfstats;
import cycinf.reasoning.RLocationNode;
import java.util.Observable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DirTracker
extends Observable {
    final IContainer dir;
    final IFile cvarsFile;
    DirInfstats curInfstats = null;
    boolean watched = false;
    boolean loadInProgress = false;
    IResourceChangeListener watcher = new /* Unavailable Anonymous Inner Class!! */;

    public IContainer getDir() {
        return this.dir;
    }

    public synchronized DirInfstats getCurInfstats() {
        return this.curInfstats;
    }

    public synchronized boolean isWatched() {
        return this.watched;
    }

    public synchronized boolean isLoadInProgress() {
        return this.loadInProgress;
    }

    DirTracker(IContainer dir) {
        this.dir = dir;
        this.cvarsFile = dir.getFile(Path.fromPortableString((String)".cych/cvars"));
        this.curInfstats = null;
    }

    public String getPath() {
        return this.dir.getFullPath().toPortableString();
    }

    public boolean infstatsPresent() {
        return this.cvarsFile.exists();
    }

    public long infstatsStamp() {
        return this.cvarsFile.getModificationStamp();
    }

    public synchronized void asyncLoadInfstatsNow(boolean automatic) {
        if (this.loadInProgress) {
            return;
        }
        this.loadInProgress = true;
        DirInfstats is = new DirInfstats(this);
        is.scheduleLoading(automatic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLoadInfstatsNow(boolean automatic) {
        DirInfstats is;
        DirTracker dirTracker = this;
        synchronized (dirTracker) {
            if (this.loadInProgress) {
                return;
            }
            this.loadInProgress = true;
            is = new DirInfstats(this);
            is.scheduleLoading(automatic);
        }
        is.waitUntilLoaded();
    }

    public synchronized boolean infstatsUpToDate() {
        long stamp = this.infstatsStamp();
        return this.getCurInfstats() == null ? stamp == -1L : stamp == this.getCurInfstats().getStamp();
    }

    public synchronized void asyncUpdateInfstats(boolean automatic) {
        if (!this.infstatsUpToDate()) {
            this.asyncLoadInfstatsNow(automatic);
        }
    }

    public synchronized DirInfstats syncUpdateInfstats(boolean automatic) {
        while (!this.infstatsUpToDate()) {
            this.syncLoadInfstatsNow(automatic);
        }
        return this.getCurInfstats();
    }

    synchronized void apply(DirInfstats is, IProgressMonitor pm) throws CoreException {
        CoreException ce = null;
        pm.beginTask("Applying the new inference data to the workspace", is.getDecisions().size() + is.getConstraintLocations().size() + 1);
        DirInfstats oldIS = this.getCurInfstats();
        if (oldIS != null) {
            pm.subTask("Unmarking old decision locations");
            for (Decision d : oldIS.getDecisions()) {
                d.unmark();
            }
            pm.subTask("Unmarking old constraint locations");
            for (RLocationNode n : oldIS.getConstraintLocations()) {
                n.unmark();
            }
        }
        pm.subTask("Registering the new inference data");
        this.curInfstats = is;
        this.setChanged();
        pm.worked(1);
        pm.subTask("Marking new decision locations");
        for (Decision d : is.getDecisions()) {
            try {
                d.mark();
            }
            catch (CoreException ce1) {
                ce = ce1;
            }
            pm.worked(1);
        }
        pm.subTask("Marking new constraint locations");
        for (RLocationNode n : is.getConstraintLocations()) {
            try {
                n.mark();
            }
            catch (CoreException ce1) {
                ce = ce1;
            }
            pm.worked(1);
        }
        pm.done();
        this.notifyObservers((Object)is);
        if (ce != null) {
            throw ce;
        }
    }

    public synchronized void setWatched(boolean watched) {
        if (watched != this.watched) {
            this.watched = watched;
            if (watched) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.watcher);
                this.asyncUpdateInfstats(false);
            } else {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.watcher);
            }
        }
    }
}

