/*
 * Decompiled with CFR 0.152.
 */
package general.util;

import general.util.HashKeyedSet;
import general.util.KeyedSet;
import general.util.Keyer;
import general.util.Validator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HashKeyedSet<K, V>
implements KeyedSet<K, V> {
    private final Keyer<K, V> keyer;
    private final Map<K, V> theMap = new HashMap();
    final Collection<V> theValues = this.theMap.values();

    public HashKeyedSet(Keyer<K, V> keyer) {
        this.keyer = (Keyer)Validator.nonnull(keyer, (String)"keyer");
    }

    public int size() {
        return this.theValues.size();
    }

    public boolean isEmpty() {
        return this.theValues.isEmpty();
    }

    public boolean contains(Object o) {
        return this.theValues.contains(o);
    }

    public Iterator<V> iterator() {
        return new KeyedSetIterator(this);
    }

    public Object[] toArray() {
        return this.theValues.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.theValues.toArray(a);
    }

    private boolean checkAdd(int behavior, V old) {
        switch (behavior) {
            case 1: {
                this.remove(old);
                return true;
            }
            case -1: {
                return false;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean eq(Object x, Object y) {
        return x == y ? true : (x == null ? false : x.equals(y));
    }

    public V add(V o, int conflictBehavior, int equalBehavior) {
        Object key = this.keyer.getKeyFor(o);
        Object old = this.theMap.get(key);
        if (old == null || (HashKeyedSet.eq(o, old) ? this.checkAdd(equalBehavior, old) : this.checkAdd(conflictBehavior, old))) {
            this.theMap.put(key, o);
        }
        return old;
    }

    public boolean add(V o) {
        return this.add(o, 0, -1) == null;
    }

    public boolean remove(Object o) {
        return this.theValues.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.theValues.containsAll(c);
    }

    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V o : c) {
            changed |= this.add(o);
        }
        return changed;
    }

    public boolean retainAll(Collection<?> c) {
        return this.theValues.retainAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.theValues.removeAll(c);
    }

    public void clear() {
        this.theValues.clear();
    }

    public Keyer<K, V> getKeyer() {
        return this.keyer;
    }

    public V replace(V v) {
        return this.theMap.put(this.keyer.getKeyFor(v), v);
    }

    public V lookup(K k) {
        return this.theMap.get(k);
    }

    public boolean equals(Object o) {
        return this.theValues.equals(o);
    }

    public int hashCode() {
        return this.theValues.hashCode();
    }

    public String toString() {
        return this.theValues.toString();
    }
}

