/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zvtm.engine.ViewEventHandler;

public class RadarEvtHdlr
implements ViewEventHandler {
    GraphicsManager grMngr;
    private boolean draggingRegionRect = false;

    RadarEvtHdlr(GraphicsManager gm) {
        this.grMngr = gm;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.grMngr.vsm.stickToMouse(this.grMngr.observedRegion);
        this.grMngr.vsm.activeView.mouse.setSensitivity(false);
        this.draggingRegionRect = true;
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            this.grMngr.vsm.activeView.mouse.setSensitivity(true);
            this.grMngr.vsm.unstickFromMouse();
            this.draggingRegionRect = false;
        }
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        LongPoint lp = v.getVCursor().getLocation();
        Camera c = this.grMngr.vsm.getVirtualSpace("graphSpace").getCamera(0);
        this.grMngr.vsm.animator.createCameraAnimation(ConfigManager.ANIM_MOVE_LENGTH, (short)2, new LongPoint(lp.x - c.posx, lp.y - c.posy), c.getID());
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.grMngr.vsm.getGlobalView(this.grMngr.vsm.getVirtualSpace("graphSpace").getCamera(1), 500);
        this.grMngr.cameraMoved();
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.grMngr.vsm.stickToMouse(this.grMngr.observedRegion);
        this.grMngr.vsm.activeView.mouse.setSensitivity(false);
        this.draggingRegionRect = true;
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            this.grMngr.vsm.activeView.mouse.setSensitivity(true);
            this.grMngr.vsm.unstickFromMouse();
            this.draggingRegionRect = false;
        }
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
    }

    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        if (this.draggingRegionRect) {
            this.grMngr.updateMainViewFromRadar();
        }
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
        Camera c = this.grMngr.mSpace.getCamera(0);
        float a = (c.focal + Math.abs(c.altitude)) / c.focal;
        if (wheelDirection == 1) {
            c.altitudeOffset(a * 10.0f);
            this.grMngr.cameraMoved();
        } else {
            c.altitudeOffset(-a * 10.0f);
            this.grMngr.cameraMoved();
        }
    }

    public void enterGlyph(Glyph g) {
    }

    public void exitGlyph(Glyph g) {
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (code == 33) {
            this.grMngr.getHigherView();
        } else if (code == 34) {
            this.grMngr.getLowerView();
        } else if (code == 36) {
            this.grMngr.getGlobalView();
        } else if (code == 38) {
            this.grMngr.translateView((short)0);
        } else if (code == 40) {
            this.grMngr.translateView((short)1);
        } else if (code == 37) {
            this.grMngr.translateView((short)2);
        } else if (code == 39) {
            this.grMngr.translateView((short)3);
        }
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
        this.grMngr.rView.destroyView();
        this.grMngr.rView = null;
    }
}

