/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.Headers;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public class ChunkedInputStream
extends FilterInputStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    int size;
    int count;
    boolean meta;
    boolean eof;
    Headers headers;

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf, 0, 1);
        if (len == -1) {
            return -1;
        }
        int ret = buf[0];
        if (ret < 0) {
            ret += 256;
        }
        return ret;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.meta) {
            int c;
            int last = 0;
            boolean seenSemi = false;
            StringBuilder buf = new StringBuilder();
            do {
                if ((c = this.in.read()) == 59) {
                    seenSemi = true;
                } else {
                    if (c == 10 && last == 13) {
                        this.size = Integer.parseInt(buf.toString(), 16);
                        break;
                    }
                    if (!seenSemi && c >= 48) {
                        buf.append((char)c);
                    }
                }
                last = c;
            } while (c != -1);
            this.count = 0;
            this.meta = false;
        }
        if (this.size == 0) {
            this.headers.parse(this.in);
            this.eof = true;
            return -1;
        }
        int diff = length - offset;
        int max = this.size - this.count;
        max = diff < max ? diff : max;
        int n = 0;
        if (max > 0) {
            n = this.in.read(buffer, offset, max);
        }
        int len = n;
        this.count += len;
        if (this.count == this.size) {
            int c1 = this.in.read();
            int c2 = this.in.read();
            if (c1 == -1 && c2 == -1) {
                this.eof = true;
                return -1;
            }
            if (c1 != 13 || c2 != 10) {
                throw new ProtocolException("expecting CRLF: " + c1 + ',' + c2);
            }
            this.meta = true;
        }
        return len;
    }

    public ChunkedInputStream(InputStream in, Headers headers) {
        super(in);
        this.headers = headers;
        this.size = -1;
        this.count = 0;
        this.meta = true;
    }
}

