/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Buffer;
import gnu.javax.swing.text.html.parser.support.low.Location;
import gnu.javax.swing.text.html.parser.support.low.Token;
import gnu.javax.swing.text.html.parser.support.low.node;
import gnu.javax.swing.text.html.parser.support.low.pattern;
import java.util.BitSet;

public class Constants {
    public static final int BEGIN = 60;
    public static final int END = 62;
    public static final int EXCLAMATION = 33;
    public static final int SLASH = 47;
    public static final int EQ = 61;
    public static final int AP = 39;
    public static final int QUOT = 34;
    public static final int DOUBLE_DASH = 1000;
    public static final int STYLE = 1001;
    public static final int SCRIPT = 1002;
    public static final int WS = 1003;
    public static final int ENTITY = 1004;
    public static final int NUMTOKEN = 1005;
    public static final pattern COMMENT_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(33), new node(1003, true), new node(1000)});
    public static final pattern COMMENT_END = new pattern(new node[]{new node(1000), new node(1003, true), new node(62)});
    public static final pattern COMMENT_TRIPLEDASH_END = new pattern(new node[]{new node(1000), new node(1005), new node(62)});
    public static final pattern STYLE_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(1001)});
    public static final pattern SCRIPT_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(1002)});
    public static final pattern SGML = new pattern(new node[]{new node(60), new node(1003, true), new node(33)});
    public static final pattern SCRIPT_CLOSE = new pattern(new node[]{new node(60), new node(1003, true), new node(47), new node(1003, true), new node(1002), new node(1003, true), new node(62)});
    public static final pattern STYLE_CLOSE = new pattern(new node[]{new node(60), new node(1003, true), new node(47), new node(1003, true), new node(1001), new node(1003, true), new node(62)});
    public static final pattern TAG = new pattern(new node[]{new node(60), new node(1003, true), new node(47, true), new node(1003, true), new node(1005)});
    public static final int OTHER = 1999;
    static final char ETX = '\u0003';
    public static final int EOF = 3;
    public static final BitSet bSINGLE_CHAR_TOKEN = new BitSet();
    public static final BitSet bSPECIAL = new BitSet();
    public static final BitSet bLETTER = new BitSet();
    public static final BitSet bDIGIT = new BitSet();
    public static final BitSet bLINEBREAK = new BitSet();
    public static final BitSet bWHITESPACE = new BitSet();
    public static final BitSet bQUOTING = new BitSet();
    public static final BitSet bNAME = new BitSet();
    public static final int ENTITY_NAMED = 1;
    public static final int ENTITY_NUMERIC = 2;

    public Token endMatches(Buffer b) {
        if (b.length() < 2) {
            return null;
        }
        int p = b.length() - 2;
        if (b.length() > 2 && b.charAt(p) == '-' && b.charAt(p - 1) == '-') {
            return new Token(1000, "--", b.getLocation(p - 1, p + 1));
        }
        char last = b.charAt(p);
        if (bSINGLE_CHAR_TOKEN.get(last)) {
            return new Token((int)last, last, b.getLocation(p, p + 1));
        }
        char future = b.charAt(p + 1);
        if (bNAME.get(last) && !bNAME.get(future)) {
            int u = p - 1;
            while (u >= 0 && bNAME.get(b.charAt(u))) {
                --u;
            }
            char[] token = new char[p - ++u + 1];
            b.getChars(u, p + 1, token, 0);
            String e = new String(token);
            if (u > 0 && b.charAt(u - 1) == '&') {
                return new Token(1004, 1, "&" + e, b.getLocation(u - 1, p + 1));
            }
            if (u > 1 && b.charAt(u - 1) == '#' && b.charAt(u - 2) == '&') {
                return new Token(1004, 2, "&#" + e, b.getLocation(u - 2, p + 2));
            }
            Location le = b.getLocation(u, p + 1);
            if (e.equalsIgnoreCase("SCRIPT")) {
                return new Token(1002, e, le);
            }
            if (e.equalsIgnoreCase("STYLE")) {
                return new Token(1001, e, le);
            }
            return new Token(1005, e, le);
        }
        if (bWHITESPACE.get(last) && !bWHITESPACE.get(future)) {
            int u = p - 1;
            while (u >= 0 && bWHITESPACE.get(b.charAt(u))) {
                --u;
            }
            char[] token = new char[p - ++u + 1];
            b.getChars(u, p + 1, token, 0);
            return new Token(1003, new String(token), b.getLocation(u, p + 1));
        }
        return null;
    }

    static {
        bQUOTING.set(39);
        bQUOTING.set(34);
        bSINGLE_CHAR_TOKEN.set(60);
        bSINGLE_CHAR_TOKEN.set(62);
        bSINGLE_CHAR_TOKEN.set(33);
        bSINGLE_CHAR_TOKEN.set(47);
        bSINGLE_CHAR_TOKEN.set(61);
        bSINGLE_CHAR_TOKEN.set(3);
        bSINGLE_CHAR_TOKEN.or(bQUOTING);
        bLINEBREAK.set(13);
        bLINEBREAK.set(10);
        bWHITESPACE.set(32);
        bWHITESPACE.set(9);
        bWHITESPACE.set(12);
        bWHITESPACE.or(bLINEBREAK);
        int i = 48;
        while (i <= 57) {
            bDIGIT.set(i);
            i = (char)(i + 1);
        }
        i = 97;
        while (i <= 122) {
            bLETTER.set(i);
            i = (char)(i + 1);
        }
        i = 65;
        while (i <= 90) {
            bLETTER.set(i);
            i = (char)(i + 1);
        }
        bSPECIAL.set(45);
        bSPECIAL.set(95);
        bSPECIAL.set(58);
        bSPECIAL.set(46);
        bNAME.or(bLETTER);
        bNAME.or(bDIGIT);
        bNAME.or(bSPECIAL);
    }
}

