/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AttributedStringIterator
implements AttributedCharacterIterator {
    private CharacterIterator ci;
    private AttributedString.AttributeRange[] attribs;
    private AttributedCharacterIterator.Attribute[] restricts;

    public Object clone() {
        return this.ci.clone();
    }

    public char current() {
        return this.ci.current();
    }

    public char next() {
        return this.ci.next();
    }

    public char previous() {
        return this.ci.previous();
    }

    public char first() {
        return this.ci.first();
    }

    public char last() {
        return this.ci.last();
    }

    public int getIndex() {
        return this.ci.getIndex();
    }

    public char setIndex(int index) {
        return this.ci.setIndex(index);
    }

    public int getBeginIndex() {
        return this.ci.getBeginIndex();
    }

    public int getEndIndex() {
        return this.ci.getEndIndex();
    }

    public Set getAllAttributeKeys() {
        HashSet s = new HashSet();
        if (this.attribs == null) {
            return s;
        }
        int i = 0;
        while (i < this.attribs.length) {
            if (this.attribs[i].begin_index <= this.getEndIndex() && this.attribs[i].end_index > this.getBeginIndex()) {
                Set key_set = this.attribs[i].attribs.keySet();
                Iterator iter = key_set.iterator();
                while (iter.hasNext()) {
                    s.add(iter.next());
                }
            }
            ++i;
        }
        return s;
    }

    public int getRunLimit() {
        return this.getRunLimit(this.getAttributes().keySet());
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attrib) {
        HashSet s = new HashSet();
        s.add(attrib);
        return this.getRunLimit(s);
    }

    public synchronized int getRunLimit(Set attributeSet) {
        if (attributeSet == null) {
            return this.ci.getEndIndex();
        }
        int current = this.ci.getIndex();
        int end = this.ci.getEndIndex();
        int limit = current;
        if (current == end) {
            return end;
        }
        Map runValues = this.getAttributes();
        while (limit < end) {
            Iterator iterator = attributeSet.iterator();
            while (iterator.hasNext()) {
                AttributedCharacterIterator.Attribute attributeKey = (AttributedCharacterIterator.Attribute)iterator.next();
                Object v1 = runValues.get(attributeKey);
                Object v2 = this.getAttribute(attributeKey, limit + 1);
                boolean changed = false;
                if (v1 != null) {
                    changed = v1.equals(v2) ^ true;
                } else {
                    boolean bl = false;
                    if (v2 != null) {
                        bl = changed = true;
                    }
                }
                if (!changed) continue;
                return limit + 1;
            }
            ++limit;
        }
        return end;
    }

    public int getRunStart() {
        return this.getRunStart(this.getAttributes().keySet());
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attrib) {
        if (attrib == null) {
            return this.ci.getBeginIndex();
        }
        HashSet s = new HashSet();
        s.add(attrib);
        return this.getRunStart(s);
    }

    public int getRunStart(Set attributeSet) {
        int begin;
        if (attributeSet == null) {
            return this.ci.getBeginIndex();
        }
        int current = this.ci.getIndex();
        int start = current;
        if (start == (begin = this.ci.getBeginIndex())) {
            return begin;
        }
        Map runValues = this.getAttributes();
        int prev = start - 1;
        while (start > begin) {
            Iterator iterator = attributeSet.iterator();
            while (iterator.hasNext()) {
                AttributedCharacterIterator.Attribute attributeKey = (AttributedCharacterIterator.Attribute)iterator.next();
                Object v1 = runValues.get(attributeKey);
                Object v2 = this.getAttribute(attributeKey, prev);
                boolean changed = false;
                if (v1 != null) {
                    changed = v1.equals(v2) ^ true;
                } else {
                    boolean bl = false;
                    if (v2 != null) {
                        bl = changed = true;
                    }
                }
                if (!changed) continue;
                return start;
            }
            --start;
            --prev;
        }
        return start;
    }

    private final Object getAttribute(AttributedCharacterIterator.Attribute key, int pos) {
        if (this.attribs == null) {
            return null;
        }
        int i = this.attribs.length - 1;
        while (i >= 0) {
            Set keys;
            if (pos >= this.attribs[i].begin_index && pos < this.attribs[i].end_index && (keys = this.attribs[i].attribs.keySet()).contains(key)) {
                return this.attribs[i].attribs.get(key);
            }
            --i;
        }
        return null;
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute key) {
        return this.getAttribute(key, this.ci.getIndex());
    }

    public Map getAttributes() {
        HashMap m = new HashMap();
        if (this.attribs == null) {
            return m;
        }
        int i = 0;
        while (i < this.attribs.length) {
            if (this.ci.getIndex() >= this.attribs[i].begin_index && this.ci.getIndex() < this.attribs[i].end_index) {
                m.putAll(this.attribs[i].attribs);
            }
            ++i;
        }
        return m;
    }

    AttributedStringIterator(StringCharacterIterator sci, AttributedString.AttributeRange[] attribs, int begin_index, int end_index, AttributedCharacterIterator.Attribute[] restricts) {
        this.ci = new StringCharacterIterator(sci, begin_index, end_index);
        this.attribs = attribs;
        this.restricts = restricts;
    }
}

