/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.RProjectedCoordsP;

public class VImage
extends ClosedShape
implements RectangularShape {
    public static final short DRAW_BORDER_NEVER = 0;
    public static final short DRAW_BORDER_MOUSE_INSIDE = 1;
    public static final short DRAW_BORDER_ALWAYS = 2;
    public long vw;
    public long vh;
    public float ar;
    public AffineTransform at;
    public RProjectedCoordsP[] pc;
    public Image image;
    public short drawBorder = 0;
    public boolean zoomSensitive = true;
    public float scaleFactor = 1.0f;
    public float trueCoef = 1.0f;
    public Object interpolationMethod = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;

    public VImage(Image img) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.image = img;
        this.vw = this.image.getWidth(null) / 2;
        this.vh = this.image.getHeight(null) / 2;
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.computeSize();
        this.orient = 0.0f;
        this.setBorderColor(Color.black);
    }

    public VImage(long x, long y, int z, Image img) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.image = img;
        this.vw = Math.round((double)this.image.getWidth(null) / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) / 2.0);
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.computeSize();
        this.orient = 0.0f;
        this.setBorderColor(Color.black);
    }

    public VImage(long x, long y, int z, Image img, double scale) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.image = img;
        this.vw = Math.round((double)this.image.getWidth(null) * scale / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) * scale / 2.0);
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.computeSize();
        this.orient = 0.0f;
        this.setBorderColor(Color.black);
        this.scaleFactor = (float)scale;
    }

    public void initCams(int nbCam) {
        this.pc = new RProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoordsP();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoordsP[] ta = this.pc;
                this.pc = new RProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoordsP();
            } else {
                System.err.println("VImage:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoordsP[1];
            this.pc[0] = new RProjectedCoordsP();
        } else {
            System.err.println("VImage:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    public void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
    }

    public void setWidth(long w) {
        this.vw = w;
        this.vh = Math.round((float)this.vw / this.ar);
        this.computeSize();
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long h) {
        this.vh = h;
        this.vw = Math.round((float)this.vh * this.ar);
        this.computeSize();
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - this.vw, this.vy + this.vh, this.vx + this.vw, this.vy - this.vh};
        return res;
    }

    public void setImage(Image i) {
        this.image = i;
        this.vw = Math.round((double)this.image.getWidth(null) / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) / 2.0);
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setZoomSensitive(boolean b) {
        if (this.zoomSensitive != b) {
            this.zoomSensitive = b;
            if (this.vsm != null) {
                this.vsm.repaintNow();
            }
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    public void setDrawBorderPolicy(short p) {
        if (this.drawBorder != p) {
            this.drawBorder = p;
            if (this.vsm != null) {
                this.vsm.repaintNow();
            }
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return dvs.intersects(this.vx - this.vw, this.vy - this.vh, 2L * this.vw, 2L * this.vh);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].cw = Math.round((float)this.vw * this.coef);
            this.pc[i].ch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[i].cw = (int)this.vw;
            this.pc[i].ch = (int)this.vh;
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].lcw = Math.round((float)this.vw * this.coef);
            this.pc[i].lch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[i].lcw = (int)this.vw;
            this.pc[i].lch = (int)this.vh;
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                g.setTransform(this.at);
                if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                    g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                }
                g.setTransform(stdT);
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                }
            } else {
                g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                g.setTransform(AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch));
                if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                    g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                }
                g.setTransform(stdT);
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                }
            } else {
                g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public void setInterpolationMethod(Object im) {
        this.interpolationMethod = im;
    }

    public Object getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public Object clone() {
        VImage res = new VImage(this.vx, this.vy, 0, this.image);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        res.setDrawBorderPolicy(this.drawBorder);
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }
}

