module Capistrano
  module Harrow
    class Banner

      def initialize(env = ENV)
        @env = env
      end

      def to_s
	text_banner
      end


      def variants
        [
          %q{
     ___   _   ___ ___ ___ _____ ___    _   _  _  ___
    / __| /_\ | _ \_ _/ __|_   _| _ \  /_\ | \| |/ _ \
   | (__ / _ \|  _/| |\__ \ | | |   / / _ \| .` | (_) |
    \___/_/ \_\_| |___|___/ |_| |_|_\/_/ \_\_|\_|\___/

    Learn about our web-based collaboration and
    automation platform for Capistrano: hrw.io/auto-cap

}
        ]
      end

      private

      def text_banner
        variants.sample
      end

			#
      # Not used yet.
			#
      def iterm2_banner
				%Q{\033]1337;File=:iVBORw0KGgoAAAANSUhEUgAAAfQAAABVCAYAAAC/4RZ1AAAABGdBTUEAALGPC/xhBQAAQABJREFUeAHtnQegVMX1/3dfgUcRCyLYESGaoEiTIkbBgsADlCiaZhRNotHk588YY/4xUfxFTWJJolET0USiMUaxgTwQjQYNinREsYGKJTZQAemv7P/zXe997tuduXu3LzoD8+7dOWfOOXOmnOk3GimhGz1wdI9oQ7RnU7Rpl2hTdGOsMvZWQ1PD67MWzXo3W7FGdh/ZurpD9d710fpuldHKLqITi8XealXZatkD8x/4MFu6Lp7TgNOA04DTgNNAOWsgWgrhRvYdOQhjezG8h0Wj0Xb4SIx/TU1NkUg08lE0En2Z3/MiTZH/VLeqXtz7md5vToxMBJjqhvca3g5j3T1WFRsYjUUPx3j3A6srNNtWRCviEZpiRI1F/gvtfzQ2Nl49c8nM1amUXIjTgNOA04DTgNPA9quBohv02n61P8LY/gZj27axqTFFczLu8X8y8jGMfKxpPUgrMPDLeb6J34jhrgBpZ/C6E96TsK6VFZXVPIUfj6f3RCe6dCLUaXgBvqfNWDJjYSLcvTsNOA04DTgNOA1szxooqkEf1W/ULzCqv9JoXMY6jPONuwyyydkMuAlXYRUVjNqbIh/UR+pPfHjRw3NseC7cacBpwGnAacBpYHvSgNlKFiAFo/qOOp9R9O9kyPWvlE5T8cjwXqQxMmL6kunPllIWx9tpwGnAacBpwGkgHxooikEf3Xf0uGhF9G6MeXWpjbmvNI3UY02xFxmpH53LJjyfnns6DTgNOA04DTgNlFIDn+4aK6AEY/qN6RupiNyKIS8bY67kagMeRv3L1ZHqyeMHj29TQBU40k4DTgNOA04DTgMF10BBDfrIgSP3ikVj/2D9e5ewa+YFT3ECA23Kw6gP31S/6Q8Jwe7VacBpwGnAacBpYLvTQGWhJGZkvisL1fexCa5P/DhaoRjlSFcdDYx6v+67d69a8e6Kf+dIzkV3GnAacBpwGnAaKIkGCmLQMeb7MMV+N5vgDjcdTStJSgOYyqjT8Tiix+492ux5wJ6zV61aZTzzHkDCgZwGnAacBpwGnAZKqoF8G/Qou9lPZgPc3/GHlPPIPFnr2qzHSP3w1tta9zuwy4HPv/zuy+8n47jfTgNOA04DTgNOA+Wqgbzsch86dGhN+/XtR3LZyw/xR+nsePx2tnJNdYBczCpow9wG1v7vrIhVTHpo0UOLA9AdyGnAacBpwGnAaaAsNJCTQR/bd2x3DN9JjG6/wca3XtjxT69vLYukZS+EOiSM1pWWrbw+3hRpuqNVQ6uZDy59cG32VF1MpwGnAacBpwGngcJpICuDPrbf2GF8UOUsxBrJJS0dtAa9vY7I06lWhl2ONL6Oob+Lj8jcNm3xtJXp4jm404DTgNOA04DTQDE1kJFBr+1b2w8DPpEReS2GLqo1cq09fxGcrp7VDXOk+WPSPCmyLfLbuufqPv4ipN2l0WnAacBpwGmg/DUQ2qBzD/vZGLSr8DsUcud6fA3b8oGVclBngmF/tr6p/rRZS2a5q2PLIWOcDE4DTgNOA19wDYQy6LV9as+oqKz4i0bjml4vhJMhp6OwDRYPs259CL/3zfTDK4WQy0bT63i82RhrPGrmopmv2vBcuNOA04DTgNOA00AxNJD2prgxvcbsF6mMXF0oY65pbI16Md4zopXRoXWL646PVcQGYSivRAEfyXCWo4vfMhet2KciUnEt32pPq8dyTIOTyWnAacBpwGng86OBtCP02v61V1RFq37e0NSQ11T7U9cY7oUcD7uC42EPJjMY3Xt0DzoTP2XE/m1mBmqS4eXwm3Q04gc/tOChBeUgj5PBacBpILQGKvr06bN3VVVVD/bGdKce781zV57t8BpJNNDurMevrqysfKOxsXElzxULFix4LzQHh/iF0sDAgQM7U066U456UIb2we/GeweUUM27bMVGytOH/H6L95UNDQ0revTo8daUKVMa86GoQIM+vuf4VhtrNi7gFrVe+dzF7k1Xv870+lUbdtgwefbs2VuCEkOn4kxGwrfmU4YgfpnAlBZG67+qW1R3SSbx8onLPQBVn3zyyXlsVOxI4UkhTcHZRsH5w9KlSwty7K5///4j4XEEvFPWY7R5kgI+dfHixc+kCJbHgH79+g2D13CTDGIDLIIcf0WOgp5QQI7x8OprkyNsktEn9T6mXvRm/DreP4KuLjt6l/f3Fi1atC4srbB45ONJ8O23PcoeNo3kTzX6G4QuRxNnGO8HkOYO+LQk0Itw1oD7PM9/QWP6/Pnzs9pDg65HQeerAbreVF9f//tly5ZtTCtYhgjwPgveXZN5kx7V1dnUkVkZkkyL3rt37x50hibYEOFdgTyTKdcv2XBs4QMGDOiI3OcBr0rGgaw2Mr/frVu3G/JlNJN5oM+DKEej0ekxPHsB7yS+6Ry4QvmE5yvgz+Y5fe3atXNXrly5NV1cGzxFAYmIG2o27I0h7ZFPQ8rRr63Qu44MuGbmkpmrE/lZ3xsiL8YqU2yFFb2YgPhSRCQ2sJg8k3m9/fbblTvuuOP5FKg9TQVJFRfYbcQriEGnIB5HZVWFSnGSh7yWISqYQVcjDf1r4NU3RQAvQHIgZ0d+6rhlwRw8ToLXyflgQJ61IANt/VbndzVpXgmf+eTt4/yelw8DD60Tq6urvy4mubpiy55OXvS1IzjfRK4zePaXfJ4+40//PR0d4u0KzlCeQynXv6Qx/w+//0z8aeRBfbr4CfC20PiZyqXJST78ImAzTfBsw9DD7sh6LXzbJfPWb8rA4dB+BJ/XBhfa32Um5KfQTxFdaUWXW4H9KQUYImDr1q0dof3L5PQoqmjjXn3ttddu4pmXUbAIjh8/vvL1119Xp/Bs/FB41yhcTmXJlM5PoSl/d0DGfoTKX7DTTjstIY9ua9Wq1Z1z5879KAU7TYC5NHmRGJnvDbM2aWiEBmu9HAO4ss3CNj8PbcxFvYKJ9zJ1yjw6PfuO7D6ydYlF3KRCZPLItZECl9cKmphWysg2E18/DNxMGrpE0qHeyYOjkaEPsxDG9EsOwcAbf+ihh+4dimj2SGqYrHLkAlNZw9eQ1r3Jz2GIeBHvs/CLMSy/1Sgoe7HjjV9RZEfeZNmvylV2W7rV8Pbt23cCPJ9BZ2rU+wtX+SB9Zuq8PIjHJ25r6B7D816e/4bPcWHptW7dehZGbJXomcqExycvHcNEmZDzSPTQDt4pfFVHcH2oI/slxsn1ffDgwW3gO9bEMyEfpi1ZsuSNbHgxmFAvYbNJjwoTLBu6tjjk81EY88eAP0i6RpBXNT5v5Vumzi8DXtw+5M/1zM7MIx++j3HXYCW0CzTorF13RuDQxEIibtjUb9PXxvQf8+fhhw4vdOMaUqSc0Xau2rFqh5ypOAJZaYAKcA7lNG1BBW9nKt7pWTEpo0h+A6BGxGsEupH8n9KwzaMBuKR79+6l7lxatSV5ffkTZL/Ql30o10hbI2cIQBcH0vA+BO2/EvXABH1lSMmO7tNE/0MoXzPgOQmvUXyge+qppz4hTp2t2Hq6GaHp5EBCGQKhOyYoCmmQsT86CCdT2LZt2waRzgO8NKVEVzjwe1IAZRZw8MEH70zH+QZ0pE70kZJb+Z9Pl0CzO3Rvhs9MytPBYXkEGvSmRjaIYNXz7LTRpB2V7KxWTa2eqe1X+6Pxg8fnbRYgz7KmJ0eHjCaqHXMIzqCn11beMejF9qY8ae08LW1VFtwENq5ok8rnxvmNAJV/Zxqby1h+uT+MUSkHBSTLvmHDhrzITsOr/QCz8SN9o1vI9Ho8UH/F9+D5OPwHpOMH3hTiGYd00gu0ujBqzptxlUFCpqFePQgST1PJ+XTjSavRkCgYed6pqanRiLdsndoZZlX+hbznIm9VmPYml8Qoj8QDfpp91OzPt8LQCzTofDFtpzBEMsRpQsBY/HKaaGSPqsqq6zfXb746Qxplg44xlyytUX67shHqCyQIo4mzafhCjUhVScDdj+msEz+PKvIbAdI4ivTdzWi3/faSTl922oaRyHzPkCFDsu4g05n5CTTuwncO2/DCN77eiu7iGygTn4KFdR4/jag0sjohKN7q1avnke4Xg+gjxylBNDKBYZAGw2sP6drmBANnCAasiw0nk3B0oL0LtTaeXtpnzpkz5+NM6BYTF11oWv0RZNVm19CslbbEcuS/K9xLd1paHr+OxL0dXf4iXYRAg46tUo8uv86zgCKqTPZ81yAm4ISvUUGECgerYiLjczXqK5yq8keZiqY9HidnUslU3nA/oHJktDaVL6ltldyv7LZnpo0AdI5av379r/Mlt+gUUfZhmzdvzkp2RsaXIufV5HOVl9dWFfjp0RPcD/DPUJbuwf8Zfz3+FvwDhC+GyFof30rQA3h8dwH/LuSxbjJctWrVFnCmiq7JwVtyDTvkkEP2NMEzDYOWdmIHRpPslB3tGj8iEDEkEH5H4vfxdJISS+H4KSmAMglgZDwO+e5FnE7Kj3RO9dfTsU6mLCHOg3iVI5UnbZ68Gxpzeb4vvAR8K2lwpSNQK35Fu/UbKyKAwF3uwNOuBQURN8EkWvI0PsIGaqqyqlJneDLed6kjZYqXz136pjRpsx+Zlf/Oj4mZC2vWADo/nUKudfHmsHQvKg/E6U+co8DN+/GcIP6qwPCfjV8VhOfB1PJWEUfLUTsSpxNPjZp2Q/54uVZabE46Ae8sOj13cW76aRte2PBSyI4xvGvhwoVPhZWRxvenyDkxXXlQWuTBew8damPT/czaPMsRsQ8svCrQ457gDsRrdmc0um0fxEd5A13tB/grcm3kKNhDJtrg3Ye/EJixLYbPzuzg1qzFrab4YcMwBG3ho2NVoaLAdwyIOa9rw+9kaMXLazJj5QHwV1lWmJMMK4fflL9jkeN2fLt0elMaKQ+bwJtBuu6lQ/QMe1neth2V4/6DTuRrL/BPwI8jvsqXUU++LlTewLuI8rSZ8nSZH574NBYiHwHyu+P9n3l5ktiU1pfqFciEhAZ3K5Mk8wpQY0Njw4OMnHtUVVTFz9FLYYVwXsHcvRC0HU2zBrQOTkMwIZs8Jb+ilJFzoVx0gw7r32FgjY27OaWfhg7lroF169apcdclKEdB5xTScFCQUQGnmoblAijkxaBD5/cY2GlBcppgybKDo0b+4DSya51Ssocy6DRyonllEE3JBo4azXXgXYe/mZ3V7yg8jWsiz94CR/5eGuOv8NQx0dN5WmcCVDbBaQPPyXQIjobGUvBbuA4dOjzLTMpScPoHlGXtds/JoBO/L7LsH8CjWS7h4IfSCdgxl+OQvXr12g2iw208kUdG8KFCnLVvTkyWL14e30H09jb5RVppAE4ymoR7LfXjOYXLUbY+fTH8BbaaYO0beIyycQXxvwut8ykHu/BuiPFpkGDgXErerCJv/paMaJ1y945h7RuUmGRihfqNDKEMupTrjcqf5jvtI2YsnnESE29fZYR+EbK9J1jy7EC+ZGaU/qV80XJ00mtA6+AU7P1s5VNlweZUKYg3nIrU24ZTqHD4tsqGNpcvNagRwCg8TUW+XDuHSccvSWejjZ7SCXz4oEGDutpwMgzPi+zk3WBP9vg5KZMMkh13LLu89zPBE8No3A6kLNxEWGViePI7OMr3J/FfRYeXhjTmyWTUUL9A/O9BR2vDug8gBccPAK48UCN9mwykH+4/la/A78P7QS2enh6GcPSrewtA5j9GIadd0AR6nsx78RycEJzxK53P4bDsJHomR9qagGs6u6wcHRGd0f8redLZJrsEljqBr8IfT3k4Hd9szDNJEHVaF0VdjjoOh5YuLEoXXYXlOjodhyQjWmNW71TdFeO3LwyS4+T2m06ZCLQwrHRyciEqWjLWuLfYbHdO49rGo+oW1P1LATPnzVw/feH0qzhTPwCFXU/Qhha8hZSj0ywGJ4/T7mrNkY2L7mmAhlHr3z+wlU01jsA0+l5uayipNNrIeNb2qlSNatQIkM4rgxoAYO0x/kPLKZ2ZyM4sTKDsKgvk8R/xHW3lQWmXjoD/BV2MyrbhTdYhdB7BaA2jHM0OygPg4t8bGS9NpqHfyDUVv8UEUxhx2yL3WBs8XbhXX7SxKx1qM9yrNzntdkduzSwYnUd/OXslFhgRShhInv4/ZB+ofLM54Mq3p+mcHsX093QbXibh0Hmxffv2Y6B7o+jbnPIR+I74G5OPqFpjMaodgZHM25lQm3AK1wRPEDwIFh+RR2NbUP71FY0Vg7iC9U8zV87cmhxn6oKpb01fNP080vUN7L91VJMcL8xvZXw0Fu0/tu/YXHvRYdh94XEo0EdRmK1TlMB1kuISFKVznEZ9qVLgTmHqfi8jwnYSuGXLlqsof6/a0qlkoKucRlqFUgWyX43sK4NkBxYoO/n4bXCOUR20OdKvxveG0aNHfz/f07vz5s17m2WNcfB/VHxsTvIhwzlcoHNoMg4N+UvAdPFNMij+G5hG+SfxI3AGwhiZQOTrSXxdT2pDSQn3eB6rS2FSgCECGD3uC40jbfmCPKLywPLly7eFIFc0FJZueiHb+Ta5JYhXnjTTczzl6fV8Cqdr0Jm2/yG0r7aVB/GTfMCHcET1zET+xhKk6XaMbFbrk4nEje+U6+RwFGivjcnICb8Zaccw0I8w3X2EjPW0JdPSrodVx6pfQ1kpMiSQzeqVjkW7xkjj6VlFdpEy1cC5lBmjpfYq2zNUigW865zvahOqigDwnRkBbtd5RoO4gbRMM6VRSlU60cEBmSq4GPiSHT6BspMu61KW9lEA/3lQdfbKw92MfM6fOHFiVu1MOl1430j4JnIsFj+bA9aa+zcuAZ5cdtUeWXd6K334fhjJg2y0g8LheRx60qxWaOfptDv1o0/oSAmIpLUWbz35Q5msB/5AQpSyeEVPFyNXW5swwJUXy/FfZ4ZmjQ0v13Dar5+ho78hi5WUl0cX0enaxUcyYld2qPwOhA7BWPp4+XsaptejTWk2xTXFGrWTPHGq3HvfyOU338/kS2esrQduBMw2odIV5/bPGtVn1L7Z0nDx0mtA695UqnQXyWg9Naa1KZ53qRKanFchzpBhMMG3o7B5QbKS/s7JU3NB+MWEkQeBsgPvYpMdY6ONcN29fEwRW/lOo7ic++nP0Vp1CkIeA9S4I8fp8PvYVt6AaaQ9ginwlOU5YHX49TaRSGcr/Nds8IBwtfG1AXArCH4VjO5HWRHsAFW48Tawp59FXbt2zWrN2UY313BvTfp45ZPJeXJ/glq0Xv6uCSePYU1ctvMjZFlsK08q98iyD8sxp/p8Uwz6cf2O253vkV9iqyR+xHw+MbKBI+aqtlVLWBu/Bov+ibdWHmfPuvU2LlLvwNfY7uDGuWH5lClTWnHlRit2RZ7/yzSuww+vAQr4WRTi1qYYKvjAV/Cxhqk+HNxJ5I3xLmevQuiimWwaSp9FOTzfsTVCnnBtO3bsaNRZqYUnf/6bTnamFVOW/oay6x/Zv5tG/nry+H+y+chFGrpGMI28DNRltgZYkYBpV3yLaVKFs9HuDR5Pog/9THEqq7hxPXv2zGhjIlPI3YinL+il0EwXIJ7IO9LTdTr0Zjg8DySeNm02hyW+ePq5z3akKxG3mO/ofgLeWk8kNzr5NV/YW1gMuXQ9MDr8IbxSlpB9/soj/AS/XKSUnqpI1a/YQKYdjn6cvD41TZ4pwWlPTfuEtfELEf0wRsL/hIZ2R2rE3sjata6S1W7KR8f0GzN51IBR1im6TPlmiq/b79Ddt0b3H51NrzZTdl84fK13U6lOtpVNVTj8Ld5Ublw/jNKXUylmqLyYnEfrHG/jkAml7MPYxKMOS1C90uiuIDNTuSqHvNFmsCDZq5kyTpGdzwVrrdNqqJTf5O0U1qcfz1XGTOLvsMMON5OmpSqLJqfyBqz28MMPT7m3gvB7THEU5pXTnm3atElZg7fFUTg0j0EXxilkr05cD9q/TfJ6PA9C118O4pEMg9bx+JROmI+HfjZRZps73X54KZ8HHHCAbiYc66U5RRTpB7lfYt/HH1OABQygo6dLaO7w8iqFk+RFtoP9ctGilavtW3scU9unx69lTYmanwBG1VkTqltY9zw71r/RFG0agWF/GkKtGisam2jGt5CwShJ9Gib+sVGHjtIFHEbXgP03AvIXWIks157Q+4RCXJubPym3Q0pM/51G4d1FhTjZeRVuNbC/G2A3UhmNBU+0KDf9iVPSGZ5kmTP5zQyD1kfNFuRTQk3ckZ6qtEyYFA43rezshE7JO/JtBHmeYuh9MclufQHw9/7vYj21qQnZrld5NDmVN2B7YBhSNvsR9ggy63vrpqgqp2qvtTkuEzfahowsjZDUDNb9ATxbAR9ho5EcPpSZE/BPxCeD4r+VBGBPs5lwpRGhRIF0xPqhg8BjsMh9Q+JgoViiItd18DbOMkoGr1yMjL/7Qo0dMnYHmoRr+J3VTkqfTjGeMxbOeFRH00jod9nZvoWRe7wGeB2RjoyS2xRDDhMPraWzLHBgQ2WDzr47lycNaJ2bQn0m3kjRa5DuMq1tdevW7UkizfVwUuITzqJP7NwUwHYSgPi72tLmJWEz31e2TtuVOJnpZN9ikp30HmmTW7rAz2V0s8iGU8hwOli67vMdW54oHHiK/M8///z7yPWoLZ7KPn4s06vtw8jPrNPu0NKZ/xR08YDWinbt2r2MQZgNjnG3uXjitAZv7mUkUebyo97Q0weTkiAtfmoDYCBCC+wi/EDeI2x6Vzj6WcNejHuLIEoKCzbIPU/gE+oMmZx0LfmBsdPMcw1bGs7FEB0kg1Rsx7R5u0x56mgao/V721W0W0v1bU4HdLTzPVThy5RnWHxVIFT8I9b2Dwobx+EFa0Dr3BRoaw8anW8GPslExVuru8lWYZVfwI4zXdRgolduYch+kC1tnqwf0tGx9vBLmZ50stNQpcjubWL8shoyk/N0oSldM4IpUh7DnnvuuY+R7bGgPKGs9rOwvMeWLoVDsxsfWTncErdFMLhD8bu0CPR+eLI9qs2CnAB4ieDnvbAW6B7P/mxG3a8FwPKDdJ0InaCZk7UYxhmW6CULRmbN0hmd9IIenmBWQR2ukjjaqAfTMD6ADlzHuCEc12vcbhhFndFOEyd3MHxaVLL4qLoiMgzj97uRA0dmfCa4vrFexjtOEyMaF5DEl9SgSw4dY6Nn8dPcNZYfCqxZFWyERmEv6A5irW9TqawXydCISEl1Wi+3aYsOwVSm7FeocpocNFrjzzbBtoOw4TYZvcboNeAt6p0NvwThgbIjz6vJspOX+liJ9RYv6r8asqfwJXPo/UkbcxlJ/H6Ua9Pa9r+BvW0rpwqnnJ5so50YDp3Rib8T34FJhjqFeScAZtl4wi/UN9KZbte6+fGibXLQUfBsnd03wUsVpg1lyGw9LSG5gvKzSHLPpVjXm3hJ38jXEb93vCe1rXrbiRigLoVcOzcJ4ochUA38z482RE8Z3W/0tdvqt938yLJHNvrwDJ9RzpqbW+0MCeWCrjYFBR+vY2wzlsx4IxdaucZFjkoawWNpQD7IlZYlfmBlsMTJJHgYaTjU1lAQrgb8piCCulCE3be3QOcqEx2FATuZ0d8V5dbgBKWLPD0cuQ/71IaZMYEvMENKG8rHL4YgwZA0si9MlpJNcnuQX2qEk0HKQxkqHSFTJ6aU7jnSJQFT2iJP7l0xcB2Bb0oUkpmUdZRTbeL8vil9CsOP0NnjoN37Qd8+93SkTsMzCbxnIK+WCeNWNyE8/oo8+ljLLcnhib/ZpzEImgea5PbxgFs3/vk4xX5yimInTsZ0svFVepB7mQ1ejHD4y4boC222DeuV5N9e/tTI8RpVltKpM4Gwe7Ap79pW1a2+Vdun9rK6JXXTSilTLrylTzopHZj10AgksCLkwidMXAqkPhBxRxjcbHBU4IMqcTY0E+NA+1zk1zp3YnD8nTIj3nO1Tk5jmAJPDMAQ3EGhv5A4KfdLizY8dtHGO+JckRivXN/VqHMG9Q/I18omI+nS7MlsG7xU4Z7BSSd7I/KnyE5YJy/fbeK/zyantTZgkcLfRUZd+qPd0yanr5/pbve3koGEa9r9e4QbOwPQ3R0DdAxwq3HUt8+Bq+OTTN7v9DyhzkMCUJ+IfQ3aKZ1z6ozQDmPavYt3t0NCtM9e4TU+TT19H5xHP4tRHm+bNm3akbbB+kU1ZN7CnQfvlFJa8mo9HWCdfTfOYqs+oPtOFcN7Ddf69QGmjC9mApiKjxsFz7D3jVZGp47pP+Y+dqz3zlCOKAUwpSJkSCNv6Jyx75M3YjkQUv4WyucgVtqoWtemsB7nNSop+CrIuJvCnGkNc9EMOtouLprRBTtaRqAS97PVXekG2GKMW0lHF8mZpjxlo5tuiLNe3yvZyXNdqpEiO+E2I+mzWudNI/u/i/7EQGxE95uUDovTbnDj3iHyVEeVrMtDHs3AaXfiW799DkxGfXqiXBgMffrTuu4PfuA30r19DfpYTSLZ5nfJDGwWfNY0B5bJC/rWJmprpxjYZpYsPymxuKgvttbLe6MowDtXNdY01lQ3Vmvto5SOcylN2/jM6Y4y6P5aPor+WkVTxXGsr0+K1kevnf7s9P8ahbTWmVRsFKLBs7nUpaLnHIJBL7Vuc05DKQlQBuIXyZgMugo34a9w3Cf0TA70dExHo5+UkxCEq5fbDUP5NeCTC5FuZDbuJk7Hy/sC1B5sKOpLmnWb1VhotTPpxacl/eBuzKNxy0l2dNsXmY5HprCy34QBqPfT4z+h4c8s+kHNT6WZfMxKzmYieXhhpkczIymyJ5K2pUPGlaUUdXh+ojKZ7JTnwI6iY7QHO/lTRo7e2vyxpriiRfhHPJ5Ipsvv6cDOMoTHR/Xkn6bdjbMC1Jkjge8bwFN8p5holzrMywejFQEmudPmZZHSEFiukXWnqr3b7r1x9frVnzBAtp7dLqSwTEtHGmINKrw/p6D+P56n4/Ut5Eh8tB6JtuMY2vlNVU0ns77+uw1bNkyavXz2hhYy0eFMnZxqgVGyH1xrmzitVTI5tkfG9Pr3YqrrFJvRopzIoN+aydlQbZzTGiUjqBNNdNUgQfcHNIp3moxJLnoUbfyF0P56CDpqYKrxbfG74HfD747X8onSLVr8NDvhYFTm8r1tYwNsjmUPTZD9FDtWM8QoO3pt4+VZWtlJ3zPI/s9migkvyKIG1ug8nQSNtozx8h1I+apC/8o/q0uTjvuAn09k4zFi8ndndDkS+F+SGRBPZ6q7ebpoAfbKzjOUbU3ftnBM0z/NEs57xO2SHNf7PZSPy+zk3V3fIi5xTsEb89ULf4PLT0ydiBZ0SvGDtDUgo7EyeelWHgTmZZHkDizXyLq2avLsyVtG9x29jLXrHo2xvH6ELHQaOba2gUtjtInle9yydieCXYo8Q0VAo3VvGn5Pra+3r2l/GvJeOX3xdDVUsfgud33m3Hd6s17e5yMV78kIvSw3JBVPA9lzotd/Gg2jviWdQkSNBOH68MrfU4BpAoiji2bGgZayAUgVGLg24A0D/kgaUhmBPdpfleyZOMWT09Oki2Raog/eWnSnO8y3JMOz+e3Jrg14GUVPlF3v/m8bEV92nlbZMUrppj93ZMd1VR5nJmziWsMx5ppO1zq5DUedkhYb4hIRSf8i4j7H03qmG7im3VMMOnHi3z4PKCstptt9vtpkR2fzSeKn3MaodBC+F7ofBP7Dfhw9mSnQhrLhtrQST2jTdZWpXsrNMeu1mYGDZlOMnSfC25Kf7Usst5S4o03Hkg09vx9v0Li7/d5SCpt4lI2z5bM3tN9wLPJ8h+r/kkbwKhBKiGfYe/ERlH8yWp825tAxPeuj9ZqGSGmYS5ke8ZbMyLuatZfHSi3L9shfa3Lo8AxbAZZ+ccaLZNKlN8xFM9A4Jx2dbOBKjxraTLzi2PSQLIOnl408T2c2YmkyPJffRZJdRm4Cl2kssclK2rSL3QZWeGdtdApCKDQMGbvAI8gIbMI4WjfuebND93v5mSKuZ6yHMNvUPRGIQdZI0vrtc+Jtxjj9KzFO4jv8jMZeOJIFmUcn4nvhuno7ZaOpjwdPfc64LKfbPRnX89xg0zXhNRj9Pfz0lOJJe6h9I5qhMzqvbq6OG8LK1pV1GJ9XGAEbkfMZSNOU0sVPDlPP+qGFD90R28rd7U1Nv4T/Ghl2OY3Y5VWwgM2pblX9IMEd01TweNxi/vF0+bdp86aV7DKCxPSin6381mitEN46BZooQybv9JjHkcfGaUPRIT2byf+bM6Hp44a5aAbcEQMGDDjEj7M9PNGXxHwLvZyEQZy6Pcjsy+jJrm+Ln4QxU522OsrGO+S/cT1R7QANsNqDblYCxQEcRJpS2jqx9gzHh+xU11q21YH3AHlpTKciQb8dXuvazY5Zma/wo6f0kOw8vouZMn81Geb/Bmc2PI3LhKKJN30jXTMFRufxfJkb6eYZEcog8MMPP1THao1NFKWBdB9sgxcjnDK/L3ysdy8Aa0TO/8ZbAH38BIF/7Sm/oPJVZDCYrnuu7mO+c355pCGij7LciJHc7Bt2b7S+E2E6vvHZ+gbluGlLaXe5S4/I9z7n6v9QUGWGJ64drJoSO7gQHjEmew1yeIkCMDVdCjjwIhnS8QAbgl4IIJMOpG+lL7eVedLTGuNi3CCUjnAx4ZJfuuepjxT9nYp/BB8kaTElWkx5MuGVKDt5cSfpOII8nZmOBnj/BecDW94RrjO5h6WjU0g4eXGkjb4n9+u6G8GGo3A6ZSrf823phIfQxuObp4opsyPQz2ftoTA8JzrEkX5T17A8HGZ13uJ1vspUsvP4tfhGOjMC+0B3KPpORo//9mR/MF9LP0YmOQauXLlSg51XbXoWedJ+RI5scooO/0HkiXEN3cvXj8iDt9Rwxt370ffv7NzU+VR2mh8lY1kop9E4whl7rjaeLAl0oSOwlpvXTiH2BBIwTrvgNFL3CpktaknCNTpHuZdbd+UXXyrVtpU09Ck7YvMhCkeoPswHHZ8GF1QMI48H2PLWC/8KjUngSM6nZ3mqNdQ0ltGpgUKGU5jqurKML5ppQhfv4R+lsk+iMX7amJjyDIzLjmia/p3EqPypsGKCu468f5H8sV2yIVLaTX9dWJr5xNPGMegdbSu/4oXsi0LwlI7uI28PN9Hywvox7d6Tur0MerLC1qNj4GsmLUxnrw68Y/EpDln8b6T7Za2WoA42gy6ewO5PIVRmAeTHQkSqNYnl6XkoJ012oxP2gQmn0GHId0IaHi/TGV7TbNC1ZsOZ7wswmv/BWLbH8KaJn0cws2RB1DDouzAyv7gh0vAymNei4HuQ8X8JG5ipUcfY6q73IHY5wSjcETYXPtl2a9tJORHKc2Tkas7rPJNWp6qCApc3stCzXiQjJqpg8OstnwtT0ZG3OejropnvAL/ShpNpuPQkH8bZGkk/LnS07ncChrwoGy/zLLtGp+MYhc7305Ph80nwjUbH09thXMTRJ2gtPkN+odHZNzMGXe1pyz+v3D0RhiBT6NOgczm42mSX4qjXraCnY5bLMOzdeBrvJVDegfcS0/zPpRBJCgBPX33TqDVle7Fkh5a+kT6RUbdGfpohMDrxxC3lJralRoQyCiS9T6rtNjmlGVgn1tGl5z+bcAoZRr5+GfqBsyDI+B9wYi0a+RkLZiwd1XfUNVWVVRMLNko3GG81cUEKAR7z5DmA90n4f9MUX0Mm6GtCP8Mbb0QKolkIGHKp0mxiQuvHU5ZPsa59FYL354UmhbcXaRlB3gYmSZVMvpDO43Emo/QbGKVr40xOTg0cNKfgX0xHCNwO4GhjXqsAXI2Mfj5+/PiTwlysE0AnLciT/V5kT7vMEUZ2cHaQ7BiGk7RnJq0ASQjEfRgaEwlunm5ORKEB1pLJ+YSpQ1Y0171799bo6H9tDD09vsfdCXNtOInh9NVeo2PyH+IZ6wS8VKbGEecy0nw0eG1Ndcfj+whHPNO2S4z2X2EG5FnipMySiR/uYL6R3p2ZuW38HmTiJyTxBHZfNvmr+MV0HKlbQJ68gcz7emlswV5hwH7IKP2OdEslLSLm58d55K0xX0Ue2TSTE1+qamHQBdy0dZOOhn2NkWyvgoxkWe7jspiWBtzcMZI4LZyUKo9swwAM5f0mQr7GdPzjGNO2vLfAL/YPlK4CfH3d4row02nFFm+74EelsV4kU+wExMsaG/O0QQ/ef8uVP2lTT//2+fPnW3cSJ/KgUd0A/i9sDaYn3wmvvfaaDNc1iXHz/S7Z8bdjYB4KQxvZP0H2X9pkVzjw49evXy/Zrw5DMxFHoz7iLoaGjhgmguLvHv2vc6TqVqYiNZoviuPs/HeRSZf/GPlJj8hbh2EN3BCXGJmOyRRG/SMSw/x3L+0HsYGzHzyH++HJT/DkNJUexmmD1Ux8ikFXZNJXDa+joKeZuTY8jTQJ17fhpxqBZRaoI3WUWd2H8iNTehRGunuSD+pkZ1xes00unbkBxD0tTXlaTl2Iz3SlmNL4pS2xyC8gYi6R2Urmx0MvTKG3MOjsW/ehtmenxEl5r6PB6bWKk+iff4wh32yLaAovhOGnIEQamhpW1beqL1pmm9K2PYdxN/meyP91U4UqVbo8WX7ASDKl85uNTFTMlGlMGx2ubL0C/k/SkNhQ4h1cyt5lNOiDrUh5AiBLaNnZOXwlhiit7KRtIiO9jDewadRH3L+o3gW4anD+SENdlCNsdB6+Ar/LgsovsEZw/hogswn0MPGsHQB0UEGn82fgGEfL0hGwNzUKNRE3hYE/E2/cTEW4onyTsvwd7z2FBGkUz2cY7b+UAizTAPR0GzJbZzCUVtJ1sZZyipEE3Q4Jnz/irbeNeuV/srexz7zlvP/i/nVaS8dgFkRu+voN/m51MbDtfB970NjOXDRzKfi/QZ4UWTDM9ZWNlRLSMJGfgh4P2Bax5pc5QshQ6QrlXjdr7ixrxQtJ6guLxvreaVSYXVRxysVJFvJ1gDbqFVsmjNYWGs2zkeFDr+KmiODpStNxt+hjLSkIJQpYtWrVFmQ+K4zs4EzKRnaM2N2kWx8UMaZSuqE89QJ+A8sSxql5Y8QsAiU/6923wct6hFZGDnkfYZbjmUxYMMOgY3qPK77JKZ3wPRHYHia49IN/PJOLXehMPgtd433y4ocbAk3j7IgvA3j38l4+ldkXzPLUfgvyZ3oaPetyl9sOO+yw3Sxk8hUcZc3+D+jYOEsiJspXZHmb19t9psYSMjEysampoild79enEfqpkTFCfBmlVXDD2w28fyLDzu8WNOhRV3Mb3PcaWzc+g6GcCHDXNKPqkhYaqouOqX3UOtb67hYJcT9Ca2DIkCE7UB6sF8mIkCpaIb1NWOTSyYxzbfBChjPCeZH6cWEQD2RTvepJh6isZofYaPsSsv8kpOwZLxl4V5AGHrdV24Juvs2yxFXIYbb8QQKGgKnscmXqHfAZkNyWJUYnnzSa+D98ywYvEcn+fo8dFAzxykeoZR6fkjqTvD9KmvygjJ7oQUehM+KZEYMCIdO+XI7c1hlf5S84h5Df//C+GFgQSZgFuBw+3w0qT8obZL2aerbGF8I+jdgYebKxovETEK1He3wiYZ9eweqCoH/i/a9c+XpaQ7ThGwimwhN3tf1qh8WNeEXkCPXt0m3O46a4WGUsofNN+auoqSiqgWfuP8IMwjP3L7r/XT8d7pmZBjBGukhm/4ACvIUp3LsoK6ps2bUydpFUXnbHjzOhSCb4HqcNexjYZSacQobB8zZ4D2MEeKpNPwpHf2fQGdZnZP9WSHkyoY3sk5FpGLJ9J43sE8DTJz0zkp2NTLfX1NR8C/pD09D/MfTbMPL8sWesMkmGFZflgi6U3dvhf6yNvyID1936k9BHRqNznzHpfIx06pOsu6sdzcSBvwYDNCeTOMIlXh3+R5nGU1rRxRPMLLyRadxS42uUTjm5njRcZMtPhQM/mrvvHyD/T2XG5a18yd2zZ89WLI38Fnr/a+MvXp6O5/HVwlsSeVsN+vsV77/TJdLlDYzrQfncHOcVxhpG5udAdyy/r8dwTx8zYMx+GMVfItypNNfxj7MkCmp6Z9Qea8Um4EYuyWmGq6zrwIXF1TTUxOorAj+CZIlpD9YIHbfQjuEgQRoYyvo0u2a12cToVHhpDOtoDM8wIuQhULuT2Wilu7N7eGW0BVXCa/BnEViSkToyXUAFH4gMXzLJ5wsL/FqM/3x09aIfVgbPC5BZsgd+plmysw69AEOQdie9nybt2qZR/SG60U7wnW268RrhH7B08iX086N86EcdFfjdCF/NOvoipTy9xvf5tm3bXpICDBmgTXSM2rRRLXAWK5mcx3tONuenSdM8+L2NDzrvn8wy/ps4Gc0osAekI0soXRWZuG8kjjrjBIv4h47TFXSgjkF32mho5OyVpyPJ/8cpB+ci7yNGxAwCKZfd4Xkd6R9l4ytywNXZ0gzIudy/32I2wTjlrkgIKKv3Zt7HQiKO80beeyHcVfB4qKmxaT6dhwkIGcqYiwaG9LOu6mdvAlndlqotnxl/K1bmANLxauaxXAxpYOPGjUPRn3WtiMKtWnVTIbWlTSXIcCveyIZyqYp0yiGHHKKNe0V3GLnVMNV6urW76snYETm1Jt2m6EJaGHqNcyjZadAylp0R0nLSrpGkufX15FIxQjdHw2MOxvHibNdBuTimB/FvgOzD+EBjrvKEbGvhPWHOnDkfe6Jk9YCWjjxmEzfs7vYWtL0ljSeUhrBOuKR1DbNJoQwcI9L26PK3pEvH5BZ4fhlhv/Mu6AnLOm943l4D2aI1QWn/tFmKdAenDqM+CX9gNkIQb1fSeyF0nsYHGnOfPrL9mE5pymkqq0GPR4xF3vNGnz6dvD5VOL1Ktj8J2TXd9LqBOSTiO+aD02GImM8gpYPZhffzSfOLRIsycC75b2w1FIzXpzSfLLROyMc71BiZRFEeE96RYyvfKbQcNvoYxn8jw28wSDaUeH0CfjhTrJdakUoAYCpzNjr8dQjZhzCFPTFTEWnc7iTOJUH0RdNrhHdBj5ejo0U0pn9ghH9kuk154O0O3hga3r9hrHQdq2ZqdKmLyBodOArfCs8z6ZDlPIPHB2fmwM+6CdAkBLw3IO9jJliYMNKQ0Tq4l+ZHubchbXuoTiej4bvIs5+SLnWUpTD53Qk7H7nvR+9FOaGQrAvq2nOEnYbf5KUpGSX+W/mPr0Le74E3D3nvZKQ9Ll3HX50V8L4KvvaOLCTuVfhOXvk08lKgV76vQL5bTUjWKXchI2rzYrspcr7CpJQsHXaUe9sTTAEya+RuJacp+hDH5KzxTQBkoFsRW2uCubBgDVCgD6YgGy/NUExgevxJx5T0UkhHJXkXebRObz2LCv8z2QR1QyY7hvMpc6dOnX79wQcfHEHFHmar/AonDRdgfJ7EkM7IJ/9caHFW9jcsaxyZTnbgWu/WXoCMRpak9QrS3Jb4P7fpRvJ7jbB0pM+BngfueRj3d4i7EvAbwHVSpZ5nDfBOPPflt5ZiNPsRjx9EH1y/3GoT3PfpbNyvsFwd0+4b0MtDyHAesqQl58m6kHsPVqVFtiDA5wnS+jF6sC5nJEb15Ao13Y7Of4DRHs1yWiKJuH4VBmwY0/A/BXhxC4Qi/VDdwehOIO2T0aX1vL3E8cpDB3C/iQ6+yVOfolV5WsVvfXdA+8Sq8dLjvvzen3eVv1DlCVx/H8bvKU+/1G+Ts3f1wWYKvKyNlIx3Q2WD0tCcDox5DCWlL+0mbWQZhhwN2HRtIHQuQw1QsM/CG89ZEq6KspKRyYMZks0anbJzMxWueZNmIiHCVan21wa+xPBivs+cOVNLA/pwjXEmIUGWKnBuYhRUkiWCBDmaX7WsQSN9Nnmq79g3hxteqoDfxA19exlggUE0whdjDC4mvj7ZGYir/PQaYhngPUA+guep5LFu5voJsv6Q36fgB+Hjx9F8/CDC4Aq8DvrfRp7bg3CzgN2LDIFLCz5NyYFXhy7r9lCdXGjM9dLkkzY+hUOa9cW82UaEhEDtm+GnzrInhLZ8FQyaX8cwtm0JKd4vjKc6J1/HfxRGB5JZ5QqvWaABlKOTVY5Unrxy9R2eRwKLl20fPyhF4isP7q+Q58fgWvOz2RBaCOa05mOhmbdgGe/Kpvg59OCam8AxPqJP+J3rKzLoHwvz0Y250vqixde0FAXfepGMCjHuVo1MiqUbrcdScWZQ6Ywsvcp6jtcgGXEKHYiReBkeFwTxkZykYV9GQTcW+gx2kBzJMEaLryCbGiWrk+zk/T719fVZyU6jdyU0ToXBGls+JjMXT3k1sMnehyXHMf32+L0ErBZjOMWEk0vYunXrFhD/Ba9uBJIiHfXIE2otO5BQJBJq2l0y4Wd4a++BJNeuXdseBHWirE56x3XC72pFKgKA+qYb5EYgz3Nhy5PEymN50h6MMyhPl6RLrrnV8mNFI2s0Ci5nx1S3enot0rE1aJv7p4kJ3QFIm/ZPKW1srIkf8UuL7hA+04DWo6kg8ZHPZ6GfvqlxoBCvwd+RDCvC7xupjMahgyopsg3QRr4iyGFloZEfupkc1MAAl1E/njPY51kJlQCAwf07st2WTnZGNmOR3XovepDoNH7/IK90Pelj4qPyVEgn+l6Z1Rr7UPLnqULw824EeyBdejz484yWX8hVDurpv8ivTenooOsY/EJ1YtDRNmQ0zoT5fLw0bKNjF4jn4xfySUdfHamj0MMtPJuCym4+5FDaxQOVPim+1JnbwtBtYQiTI3Ac7F01CuXsoo1RHUKvTOh4cMGwfcqdAtdZ+PlKE9VYpNas2bbGTblnoFRdxgH6mRRYYywVaGD/ZDPRO0aEAgZqAx7lXkd2jFwIjwI/1wgsYiAN7U+Q4yWbnBJF+gX+f6wFDiqiaGlZIfuFyP5iCNkv4yjb4LQEDQgY9edI/0j82YBfLYRhF02vcV9AesbC8/QwG8IM4oYOgt/9pKk+KIKn11nIE4gXRMOHkZ5XeV8SlFcebAWyPe3HC3oilzoI1m+9K65oks4lHLkryl6uIHkFQ+Y1+O8jkz5Rqx3pft6nixoankDzDcrT/zCTMZzO4ZKwBAINOmbvDQit84xWWJpFw0OppD8+1a173eOT32JOoTJZiWjtobXf5nvvf1WkfAkpUnQmVuaj4uRLJgOdvKXXQDurIP8iGfLQGJ/wLeTjzUZggQO1AY8RxE22YkJFkwQjMZK9CixKIHmmrz9EFhkrXbNqxJV+gbXDTyrkzVZG5gGBmchOOchadtVLGsSboTEQXZyP1/GoeENs01mA2HFQQvwG6GnT2Lfat29/BKOoh9LFzQe8a9eu6qgsDpIfuJzWz/Ph4l/zCuInGPymoe+0I3lfIAZX+mKmcRe5R0+dkV/jw4wqzRXAZ5bHJ/n88ObNm3UHwcnI/ziktbQR74Bkw0ZpTYivJb8L0c2h6PKP/h3tYekGGvT2+7R/F2Me2IsOyyjfeChTSuiMFR/AhrSzMKovxe+Hl26SRuij+o0aOKb/mBl8FeYO8PdR3Hw6dDQnn/SypBXPSxWOZA+9ghZ29AnLVL5+WDJ/7xOT8RGuj5P4VOGmUNfRED+fpS5yjtauXbsHqVQacZj0qR24+lDJOQZG8W/DJ6Yn8R38vOYFMxhPoP8rEnkkv6NLyXswN1tdMzT4IzNENeej0ql8NqQ36yBk10zI5TaeCvdkPwjZr00je6Ac6kBQnv7ATXHa4HYMdK8jwlL8RvFRPqfzwsNpo/DTxP8V+IOhOYyG9x/5vH1OTIKc96nceyWPzZNXr7FDfHEQnUxg8Il/rCWAn7aq35sJTR3lQ84JxPkoWfeErUPHOiEgg5nWqWyaZFNEYIF2Li1xA4IuNCLfp+CPhq86ixPxc3iPb55LTo/pt+TFbSLeMvwN+OPwA6B5DbpZbWCbNijw2JoKDsZwSlW0alBZLqXHIm1QymSG5w9i0C9iO0tv5DzTT/WoPqP2xchfxDr7BPBqsjjn7pMyPqlOanA2cfdsUXrmRiEIpBdXzxnZb/DahkqcgkZj3sjUTdpzoSkRQwZoNEtBfAgDmBJDhRaYjm80ux49ekQ4enUBshorGtOxaqhWNEcowQsN9AaOMY2BdWdTulRBkVOjEdXK5h4i4b8ivZNMcTxdvFCA5Ohijn/D07qUJHkpq7HVq1cbdS6ZkE+byf5ikl15gsu77Cxv/Jbb22bnKruEC+M8w/sYuI+xe1rHiPbBfwndfImndh5rE1Y7vHSpo2sb0MsHvGsKdAVXbb7MFPTb/C61uwUB5gfk1Uf5/G43HaFlHDs8nLreKrmNUdlAjm3777//QoxRRnrBYN9DPXsW3Z6GnnsTOYrOn6W83gFseRhidPb+y+bPY5AhpWx75XYjcqU2jGGIh8ChU6cpcfnLtNEXnipLXyId+/LcDa/lRZU1NZBqM3TK423gK5D5FfYIvKEOAuE5u3gXIYjK0QOO7ljTWKNb3LqxQzwItWSw+AdeYk1bUNB19LN1zODNpmjTtzG4FyF3l3wbcj+hVZVVkYbGhpvqFtWVfD3Vl8k9nQacBpwGnAa+mBpIa9ClFtaej2G6+gFe25erUZecMuyNscZXGC9to4d3EAZeo0OB8u5YixevubGaWG3dnLqP887AEXQacBpwGnAacBrIQAPWKbpEGiveWfFaj849FjC1PQRDWTbfXE6UUe8y3kxldGRUvluhOh7QjqAHTV8+WFFVcer0udPLYgdmsi7cb6cBpwGnAaeBL5YGQo3QfZWMOnRUl8pI5U8wnBMwbLvIgBbKcPo8y+WpNUg50qwPQVzNNPsd/CzPNYi4pO6P04DTgNOA08AXSQMZGXRfMSf0PqFrfVX9N1mjlu/JqDi+G5UJbh/lc/FUujQiZzS+jbQ9wfr85K31W6c+suwRdyvc5yKHXSKcBpwGnAY+PxrIyqD7yR/Tb0zbWEXsaOz4aYxaR7CG3Q7jx8/t27DHp9U/7aS8wR7mu7lg558zF87ULkbnnAacBpwGnAacBspSAzkZ9MQUjRw48iuVDZXfxwCewch2Bxn27dF5O+ZfpoNyfavKVnc/MP+BD7fHdDiZnQacBpwGnAa+WBrIm0H31cY6e292xP+eUe7QQh0X83nl86np9WiMGz0jTb+LbItcWfec27meT/06Wk4DTgNOA04DhdVA3g26xI1PxUdjf8aon7o9GPW4MY9E67lx7tzpi6frwgbnnAacBpwGnAacBrYrDYQ6tpZpil5595X6Q3Y+pG5bxbYe3CwUPw+eKY1i4mPQG1n3P5ud67cWk6/j5TTgNOA04DTgNJAvDRTEoEu4F1a/0LjnLnvO4ja1waxL78eadL5kzisdHUdjmv1nMxbOuCGvhB0xpwGnAacBpwGngSJqoCBT7onyj+w1cq/KVpWPsUL9pXI7sx6/Wa6x8ea6xXX6YpVzTgNOA04DTgNOA9utBlIus893SmYum/l2U2PTt5jSjn+FJt/0s6UXN+axxkfbtm57frY0XDynAacBpwGnAaeBctFAwabcExO44r0V7/TYo8dLjNLHsV4d+IW3xHiFeveM+VK+wnbS1HlT9TlE55wGnAacBpwGnAa2aw0UxaBLQ9wH/3L3zt3f5B70kex+rwp7+Qy4n36nWHeo60uV+s8RMxllwfSeiVM8pv6XVmyr+Frdkrpy+AxiJuI7XKcBpwGnAacBpwGjBjKzhkYSmQWO7DNyJDvfb6iMVnbja2UtvoYm4xz/5xlpjrxthfprhC3hc6hLK5oqVkYqIh8zsuZTZ5Eu4B9Ax6AvkXpxOd1eMtZy8bV69uD5nQafpugDm1Yfqz971qJZ78aR3R+nAacBpwGnAaeBz4EGim7QpbP4R15ilT/E4J6I74rlbU2wPv6+HuP8Js/FGN85GOL5DR83rJy5cqYMu9XVHly7c2Xryq+wW/0wdtMPhkZPLonZA9pteZdd3wCtZVxTO6ntgrZ3TYlMES/nnAacBpwGnAacBj43GiiJQThEVWIAAABKSURBVPe1N37w+DYbGzfuXRmr3JHR+BbuTF/ToVuHD6ZMyc3giu6Wxi1d6CLsTMcghl8zdcHUt3y+7uk04DTgNOA04DTwedPA/wcr/1e0V8Jc3gAAAABJRU5ErkJggg==}
      end

    end
  end
end
