;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Principal Components and Multivariate Regression Macro Example

;;Domonstrates defining a macro to perform principal components and
;;multivariate regression, followed by using the macro. 

;;Define the "macro" - a function that does principal components regression


(when *guidemap* (send *guidemap* :close))  

(defun pca-mmr (pca-data mmr-data)
  (show-workmap)
  (load-data (strcat  *examples-data-dir-name* pca-data))
  (normalize-data)
  (principal-components)
  (load-data (strcat  *examples-data-dir-name* mmr-data))
  (normalize-data)
  (setf resp-data current-data)
  (send current-model :create-data :scores t :coefs nil)
  (setcd resp-data)
  (merge-variables "both-data")
  (multiple-regression
   :responses (send resp-data :variables)
   :predictors '("PC0" "PC1" "PC2" "PC3" "PC4"))
  (visualize-model)
  (report-model)
  )

;;execute the "macro"

(pca-mmr "carprf14.lsp" "carrats.lsp")
(vista-message "Macro Example Finished")