package ONVIF::PTZ::Types::Appearance;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Transformation_of :ATTR(:get<Transformation>);
my %Shape_of :ATTR(:get<Shape>);
my %Color_of :ATTR(:get<Color>);
my %Class_of :ATTR(:get<Class>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Transformation
        Shape
        Color
        Class
        Extension

    ) ],
    {
        'Transformation' => \%Transformation_of,
        'Shape' => \%Shape_of,
        'Color' => \%Color_of,
        'Class' => \%Class_of,
        'Extension' => \%Extension_of,
    },
    {
        'Transformation' => 'ONVIF::PTZ::Types::Transformation',
        'Shape' => 'ONVIF::PTZ::Types::ShapeDescriptor',
        'Color' => 'ONVIF::PTZ::Types::ColorDescriptor',
        'Class' => 'ONVIF::PTZ::Types::ClassDescriptor',
        'Extension' => 'ONVIF::PTZ::Types::AppearanceExtension',
    },
    {

        'Transformation' => 'Transformation',
        'Shape' => 'Shape',
        'Color' => 'Color',
        'Class' => 'Class',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::Appearance

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Appearance from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Transformation


=item * Shape


=item * Color


=item * Class


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::Appearance
   Transformation =>  { # ONVIF::PTZ::Types::Transformation
     Translate => ,
     Scale => ,
     Extension =>  { # ONVIF::PTZ::Types::TransformationExtension
     },
   },
   Shape =>  { # ONVIF::PTZ::Types::ShapeDescriptor
     BoundingBox => ,
     CenterOfGravity => ,
     Polygon =>  { # ONVIF::PTZ::Types::Polygon
       Point => ,
     },
     Extension =>  { # ONVIF::PTZ::Types::ShapeDescriptorExtension
     },
   },
   Color =>  { # ONVIF::PTZ::Types::ColorDescriptor
     ColorCluster =>  {
       Color => ,
       Weight =>  $some_value, # float
       Covariance => ,
     },
     Extension =>  { # ONVIF::PTZ::Types::ColorDescriptorExtension
     },
   },
   Class =>  { # ONVIF::PTZ::Types::ClassDescriptor
     ClassCandidate =>  {
       Type => $some_value, # ClassType
       Likelihood =>  $some_value, # float
     },
     Extension =>  { # ONVIF::PTZ::Types::ClassDescriptorExtension
       OtherTypes =>  { # ONVIF::PTZ::Types::OtherType
         Type =>  $some_value, # string
         Likelihood =>  $some_value, # float
       },
       Extension =>  { # ONVIF::PTZ::Types::ClassDescriptorExtension2
       },
     },
   },
   Extension =>  { # ONVIF::PTZ::Types::AppearanceExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

