<?php

namespace Concrete\Core\Announcement\Action;

use Concrete\Core\Announcement\Component\AbstractComponent;

class LearnMoreAction extends AbstractComponent implements ActionInterface
{

    /**
     * @var string
     */
    protected $url;

    public function __construct(string $url)
    {
        $this->url = $url;
    }

    public function getComponent(): string
    {
        return 'concrete-announcement-external-link-action';
    }

    public function getComponentProps(): array
    {
        return [
            'url' => $this->url,
        ];
    }

}
