package TDS::Summary;
# $Id: Summary.pm,v 1.20 2000/12/20 14:59:38 tom Exp $
################################################################

=head1 NAME

TDS::Summary - ɽ

=head1 SYNOPSIS

 use TDS::Summary;

 $s = new TDS::Summary;
 $s->Read;
 print $s->AsHTML;

=cut

################################################################

use strict qw(vars);

use Template;

use vars qw(@ISA
	    $YearTemplate $YearEndTemplate
	    $MonthTemplate $MonthNolinkTemplate $MonthEndTemplate
	    $PartTemplate $PartTemplateNone $PartEndTemplate
	    $MonthlyHrefTemplateDynamic $MonthlyHrefTemplateStatic
	    $PartlyHrefTemplateDynamic $PartlyHrefTemplateStatic
	    $EachPart $Reverse
	    $SkeltonFilename);

use GlobalInitializer;

use TDS::System;
use TDS::Collection;
use TDS::Skelton;
use TDS::IdentInfo;
use TDS::Mode;
use TDS::DirInfo;

@ISA = qw(TDS::Skelton);

attributes qw();


=head2 STATIC VARIABLES

 $SkeltonFilename   ե̾
 $Reverse       Ťɽ뤫

ƥץ졼ȡ

 $YearTemplate         ǯ
 $YearEndTemplate      ǯλ
 $MonthTemplate        
 $MonthNolinkTemplate  ʥ󥯤̵
 $MonthEndTemplate     λ
 $PartTemplate         
 $PartTemplateNone     ܡ¸ߤʤ
 $PartEndTemplate      ܽλ
 $EachPart             ƽ

 $MonthlyHrefTemplateDynamic    ؤ hrefưŪ
 $MonthlyHrefTemplateStatic     ؤ hrefŪ
 $PartlyHrefTemplateDynamic     ܤؤ hrefưŪ
 $PartlyHrefTemplatestatic      ܤؤ hrefŪ


=cut


{
    $SkeltonFilename = "summary_skelton.html";

    ################
    # ƥץ졼
    $YearTemplate = "<h2>%year</h2>\n<ul>\n" unless defined $YearTemplate;
    $YearEndTemplate = "</ul>\n" unless defined $YearEndTemplate;
    $MonthTemplate = qq(<li><a href="%href">%month</a>: ) unless defined $MonthTemplate;
    $MonthNolinkTemplate = qq(<li>%month</a>) unless defined $MonthNolinkTemplate;
    $MonthEndTemplate = "</li>\n" unless defined $MonthEndTemplate;
    $PartTemplate = qq([<a href="%href">%part_str</a>]) unless defined $PartTemplate;
    $PartTemplateNone = qq((%part_str)) unless defined $PartTemplateNone;
    $PartEndTemplate = undef unless defined $PartEndTemplate;
    $EachPart = ",," unless defined $EachPart;

    $MonthlyHrefTemplateDynamic = "./?%0y%0m" unless defined $MonthlyHrefTemplateDynamic;
    $MonthlyHrefTemplateStatic  = "d%0y%0m.%suffix" unless defined $MonthlyHrefTemplateStatic;
    $PartlyHrefTemplateDynamic = "./?%0y%0m%part" unless defined $PartlyHrefTemplateDynamic;
    $PartlyHrefTemplateStatic  = "d%0y%0m%part.%suffix" unless defined $PartlyHrefTemplateStatic;

    # ս
    $Reverse = 0;
}

################################################################

=head1 MEMBER FUNCTIONS

=cut

=head2 $s->AsHTML;

HTML֤

=cut

sub AsHTML($)
{
    my $self = shift;

    # 
    for ('Year', 'Month', 'Part'){
	my $cmd = $_;
	my $lc_cmd = lc($cmd);
	my $evaled = sprintf(qq(\$%sTemplate =
				\$self->config->{'%s_template'}
				if \$self->config->{'%s_template'};),
			     $cmd, $lc_cmd, $lc_cmd);
	$evaled .= sprintf(qq(\$%sEndTemplate =
			      \$self->config->{'%s_end_template'}
			      if \$self->config->{'%s_end_template'};),
			   $cmd, $lc_cmd, $lc_cmd);
#	print $evaled;
	eval($evaled);
    }

    $MonthNolinkTemplate = $self->config->{'month_nolink_template'}
      if $self->config->{'month_nolink_template'};
    
    $EachPart = $self->config->{'each_part'} if $self->config->{'each_part'};
    my @part_str_table = split(",", $EachPart);

    $Reverse = $self->config->{'reverse'} if defined $self->config->{'reverse'};
    
    # ޥ
    $self->SetMacro("SUMMARY_CONTENT", sub {
	my ($self, $cmd, $var) = @_;
	my $html;
	my $params;
	my $status = $TDS::Status;
	
	my $year = $status->start_time->year;
	my @years = ($status->start_year..$year);
	if ($Reverse){
	    @years = reverse @years;
	}
	# ǯ
	for (@years){
	    my $year = $_;
	    next unless -d GetDiaryDir() . "/$year";
#	    print "$year,";

	    my $suffix = "";
	    if (TDS::Mode::IsStatic()){
		require TDS::Static;
		$suffix = $TDS::Static::HtmlSuffix;
	    }
	    $params = {year=>$_, 'y'=>$_, '0y'=>$_,
		       'diary_url'=>TDS::IdentInfo->Get('url'),
		       suffix=>$suffix
		   };
	    $html .= Expand($YearTemplate, $params);
	    my $month;
	    my @months = (1..12);
	    if ($self->config->{'reverse'}){
		@months = reverse @months;
	    }
	    # 
	    for (@months){
		$month = sprintf("%02d", $_);

		# ꤷܤ뤫
#		print "$year/$month\n";		
		my $month_dir = GetDiaryDir() . "/$year/$month";
		next unless -d $month_dir;	# ǥ쥯ȥ꼫Τ̵
		
		# ꤷܤ뤫
		my @start_day = (1, 10, 20);
		my @end_day = (9, 19, DateTime::Date::DaysMonth($year, $month));
		my @is_exist;
		for (0..2){
		    my $part = $_;
		    for ($start_day[$part]..$end_day[$part]){
			if (-f sprintf("$month_dir/%02d.tdf", $_)){
			    $is_exist[$part] = 1;
			    last;
			}
		    }
		}
		# template Ÿ
		# 
		$params->{'m'} = $_;
		$params->{'0m'} = sprintf("%02d", $_);
		$params->{month} = $month;
		my $href_template = (TDS::Mode::IsStatic())?
		    $MonthlyHrefTemplateStatic : $MonthlyHrefTemplateDynamic;
		$params->{href} = Expand($href_template, $params);

		$html .= ($TDS::Collection::AllowAllMonthly) ?
		    Expand($MonthTemplate, $params) :
			Expand($MonthNolinkTemplate, $params);

		# ܤ
		my @part_char = qw(a b c);
		for (0..2){
		    my $template = 
			($is_exist[$_]) ? 
			    $PartTemplate : $PartTemplateNone;
		    $params->{part} = $params->{part_char} = $part_char[$_];
		    my $href_template = (TDS::Mode::IsStatic())?
			$PartlyHrefTemplateStatic : $PartlyHrefTemplateDynamic;
		    $params->{href} = Expand($href_template, $params);
		    $params->{part} = $params->{part_str} = $part_str_table[$_];
		    $html .= Expand($template, $params);
		}
		$html .= $MonthEndTemplate;
	    }
	    $html .= $YearEndTemplate;
	}
#	print "\n";
	return $html;
    });
    return $self->SUPER::AsHTML;
}    
1;
