package ONVIF::PTZ::Types::Mpeg4Options;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ResolutionsAvailable_of :ATTR(:get<ResolutionsAvailable>);
my %GovLengthRange_of :ATTR(:get<GovLengthRange>);
my %FrameRateRange_of :ATTR(:get<FrameRateRange>);
my %EncodingIntervalRange_of :ATTR(:get<EncodingIntervalRange>);
my %Mpeg4ProfilesSupported_of :ATTR(:get<Mpeg4ProfilesSupported>);

__PACKAGE__->_factory(
    [ qw(        ResolutionsAvailable
        GovLengthRange
        FrameRateRange
        EncodingIntervalRange
        Mpeg4ProfilesSupported

    ) ],
    {
        'ResolutionsAvailable' => \%ResolutionsAvailable_of,
        'GovLengthRange' => \%GovLengthRange_of,
        'FrameRateRange' => \%FrameRateRange_of,
        'EncodingIntervalRange' => \%EncodingIntervalRange_of,
        'Mpeg4ProfilesSupported' => \%Mpeg4ProfilesSupported_of,
    },
    {
        'ResolutionsAvailable' => 'ONVIF::PTZ::Types::VideoResolution',
        'GovLengthRange' => 'ONVIF::PTZ::Types::IntRange',
        'FrameRateRange' => 'ONVIF::PTZ::Types::IntRange',
        'EncodingIntervalRange' => 'ONVIF::PTZ::Types::IntRange',
        'Mpeg4ProfilesSupported' => 'ONVIF::PTZ::Types::Mpeg4Profile',
    },
    {

        'ResolutionsAvailable' => 'ResolutionsAvailable',
        'GovLengthRange' => 'GovLengthRange',
        'FrameRateRange' => 'FrameRateRange',
        'EncodingIntervalRange' => 'EncodingIntervalRange',
        'Mpeg4ProfilesSupported' => 'Mpeg4ProfilesSupported',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::Mpeg4Options

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Mpeg4Options from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ResolutionsAvailable


=item * GovLengthRange


=item * FrameRateRange


=item * EncodingIntervalRange


=item * Mpeg4ProfilesSupported




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::Mpeg4Options
   ResolutionsAvailable =>  { # ONVIF::PTZ::Types::VideoResolution
     Width =>  $some_value, # int
     Height =>  $some_value, # int
   },
   GovLengthRange =>  { # ONVIF::PTZ::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   FrameRateRange =>  { # ONVIF::PTZ::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   EncodingIntervalRange =>  { # ONVIF::PTZ::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   Mpeg4ProfilesSupported => $some_value, # Mpeg4Profile
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

