require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET_IF_H_)) {
    eval 'sub _NET_IF_H_ () {1;}' unless defined(&_NET_IF_H_);
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'stdbool.ph';
    }
    require 'sys/featuretest.ph';
    eval 'sub IF_NAMESIZE () {16;}' unless defined(&IF_NAMESIZE);
    eval 'sub IFDESCRSIZE () {64;}' unless defined(&IFDESCRSIZE);
    if(defined(&_NETBSD_SOURCE)) {
	require 'sys/socket.ph';
	require 'sys/queue.ph';
	require 'sys/mutex.ph';
	require 'sys/hook.ph';
	require 'net/dlt.ph';
	require 'net/pfil.ph';
	if(defined(&_KERNEL)) {
	    require 'net/pktqueue.ph';
	    require 'sys/pslist.ph';
	    require 'sys/pserialize.ph';
	    require 'sys/psref.ph';
	    require 'sys/module_hook.ph';
	}
	require 'altq/if_altq.ph';
	require 'sys/time.ph';
	if(defined(&_KERNEL_OPT)) {
	    require './net/opt_compat_netbsd.ph';
	    require './net/opt_gateway.ph';
	}
	eval 'sub IFNAMSIZ () { &IF_NAMESIZE;}' unless defined(&IFNAMSIZ);
	eval 'sub IF_CLONE_INITIALIZER {
	    my($name, $create, $destroy) = @_;
    	    eval q({ {  &NULL,  &NULL }, $name, $sizeof{$name} - 1, $create, $destroy });
	}' unless defined(&IF_CLONE_INITIALIZER);
	eval 'sub LINK_STATE_UNKNOWN () {0;}' unless defined(&LINK_STATE_UNKNOWN);
	eval 'sub LINK_STATE_DOWN () {1;}' unless defined(&LINK_STATE_DOWN);
	eval 'sub LINK_STATE_UP () {2;}' unless defined(&LINK_STATE_UP);
	eval 'sub LINK_STATE_DESC_MATCH {
	    my($_ifs, $_t, $_s) = @_;
    	    eval q(((($_ifs)-> &ifs_type == ($_t) || ($_ifs)-> &ifs_type == 0)  && ($_ifs)-> &ifs_state == ($_s)));
	}' unless defined(&LINK_STATE_DESC_MATCH);
	eval 'sub LINK_STATE_DESCRIPTIONS () {{ {  &IFT_ETHER,  &LINK_STATE_DOWN, "no carrier" }, {  &IFT_IEEE80211,  &LINK_STATE_DOWN, "no network" }, {  &IFT_PPP,  &LINK_STATE_DOWN, "no carrier" }, {  &IFT_CARP,  &LINK_STATE_DOWN, "backup" }, {  &IFT_CARP,  &LINK_STATE_UP, "master" }, { 0,  &LINK_STATE_UP, "active" }, { 0,  &LINK_STATE_UNKNOWN, "unknown" }, { 0,  &LINK_STATE_DOWN, "down" }, { 0, 0,  &NULL } };}' unless defined(&LINK_STATE_DESCRIPTIONS);
	if(defined(&_KERNEL)) {
	    require 'sys/percpu.ph';
	    require 'sys/callout.ph';
	    require 'sys/rwlock.ph';
	    require 'sys/workqueue.ph';
	}
	if(defined(&_KERNEL)) {
	} else {
	}
	eval 'sub if_watchdog () { &if_slowtimo;}' unless defined(&if_watchdog);
	eval 'sub if_carp () { ($if_carp_ptr->{carp_s});}' unless defined(&if_carp);
	eval 'sub if_carpdev () { ($if_carp_ptr->{carp_d});}' unless defined(&if_carpdev);
	if(defined(&_KERNEL)) {
	}
	require 'net/if_stats.ph';
	eval 'sub if_name {
	    my($ifp) = @_;
    	    eval q((($ifp)-> &if_xname));
	}' unless defined(&if_name);
	eval 'sub IFF_UP () {0x1;}' unless defined(&IFF_UP);
	eval 'sub IFF_BROADCAST () {0x2;}' unless defined(&IFF_BROADCAST);
	eval 'sub IFF_DEBUG () {0x4;}' unless defined(&IFF_DEBUG);
	eval 'sub IFF_LOOPBACK () {0x8;}' unless defined(&IFF_LOOPBACK);
	eval 'sub IFF_POINTOPOINT () {0x10;}' unless defined(&IFF_POINTOPOINT);
	if(0) {
	} else {
	    eval 'sub IFF_UNNUMBERED () {0x20;}' unless defined(&IFF_UNNUMBERED);
	}
	eval 'sub IFF_RUNNING () {0x40;}' unless defined(&IFF_RUNNING);
	eval 'sub IFF_NOARP () {0x80;}' unless defined(&IFF_NOARP);
	eval 'sub IFF_PROMISC () {0x100;}' unless defined(&IFF_PROMISC);
	eval 'sub IFF_ALLMULTI () {0x200;}' unless defined(&IFF_ALLMULTI);
	eval 'sub IFF_OACTIVE () {0x400;}' unless defined(&IFF_OACTIVE);
	eval 'sub IFF_SIMPLEX () {0x800;}' unless defined(&IFF_SIMPLEX);
	eval 'sub IFF_LINK0 () {0x1000;}' unless defined(&IFF_LINK0);
	eval 'sub IFF_LINK1 () {0x2000;}' unless defined(&IFF_LINK1);
	eval 'sub IFF_LINK2 () {0x4000;}' unless defined(&IFF_LINK2);
	eval 'sub IFF_MULTICAST () {0x8000;}' unless defined(&IFF_MULTICAST);
	eval 'sub IFEF_MPSAFE () { &__BIT(0);}' unless defined(&IFEF_MPSAFE);
	if(defined(&_KERNEL)) {
	    eval 'sub if_is_mpsafe {
	        my($ifp) = @_;
    		eval q({ (( ($ifp->{if_extflags}) &  &IFEF_MPSAFE) != 0); });
	    }' unless defined(&if_is_mpsafe);
	    eval 'sub if_output_lock {
	        my($cifp,$ifp,$m,$dst,$rt) = @_;
    		eval q({  &if ( &if_is_mpsafe($cifp)) { (* ($c$ifp->{if_output}))($ifp, $m, $dst, $rt); }  &else { \'int\'  &ret;  &KERNEL_LOCK(1,  &NULL);  &ret = (* ($c$ifp->{if_output}))($ifp, $m, $dst, $rt);  &KERNEL_UNLOCK_ONE( &NULL);  &ret; } });
	    }' unless defined(&if_output_lock);
	    eval 'sub if_start_lock {
	        my($ifp) = @_;
    		eval q({  &if ( &if_is_mpsafe($ifp)) { (* ($ifp->{if_start}))($ifp); }  &else {  &KERNEL_LOCK(1,  &NULL); (* ($ifp->{if_start}))($ifp);  &KERNEL_UNLOCK_ONE( &NULL); } });
	    }' unless defined(&if_start_lock);
	    eval 'sub KERNEL_LOCK_IF_IFP_MPSAFE {
	        my($ifp) = @_;
    		eval q( &do {  &if ( &if_is_mpsafe($ifp)) {  &KERNEL_LOCK(1,  &NULL); } }  &while (0));
	    }' unless defined(&KERNEL_LOCK_IF_IFP_MPSAFE);
	    eval 'sub KERNEL_UNLOCK_IF_IFP_MPSAFE {
	        my($ifp) = @_;
    		eval q( &do {  &if ( &if_is_mpsafe($ifp)) {  &KERNEL_UNLOCK_ONE( &NULL); } }  &while (0));
	    }' unless defined(&KERNEL_UNLOCK_IF_IFP_MPSAFE);
	    eval 'sub KERNEL_LOCK_UNLESS_IFP_MPSAFE {
	        my($ifp) = @_;
    		eval q( &do {  &if (! &if_is_mpsafe($ifp)) {  &KERNEL_LOCK(1,  &NULL); } }  &while (0));
	    }' unless defined(&KERNEL_LOCK_UNLESS_IFP_MPSAFE);
	    eval 'sub KERNEL_UNLOCK_UNLESS_IFP_MPSAFE {
	        my($ifp) = @_;
    		eval q( &do {  &if (! &if_is_mpsafe($ifp)) {  &KERNEL_UNLOCK_ONE( &NULL); } }  &while (0));
	    }' unless defined(&KERNEL_UNLOCK_UNLESS_IFP_MPSAFE);
	    if(defined(&_KERNEL_OPT)) {
		require './net/opt_net_mpsafe.ph';
	    }
	    if(defined(&NET_MPSAFE)) {
		eval 'sub KERNEL_LOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&KERNEL_LOCK_UNLESS_NET_MPSAFE);
		eval 'sub KERNEL_UNLOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&KERNEL_UNLOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_LOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&SOFTNET_LOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_UNLOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&SOFTNET_UNLOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_LOCK_IF_NET_MPSAFE () {
		    eval q( &do {  &mutex_enter( &softnet_lock); }  &while (0));
		}' unless defined(&SOFTNET_LOCK_IF_NET_MPSAFE);
		eval 'sub SOFTNET_UNLOCK_IF_NET_MPSAFE () {
		    eval q( &do {  &mutex_exit( &softnet_lock); }  &while (0));
		}' unless defined(&SOFTNET_UNLOCK_IF_NET_MPSAFE);
	    } else {
		eval 'sub KERNEL_LOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do {  &KERNEL_LOCK(1,  &NULL); }  &while (0));
		}' unless defined(&KERNEL_LOCK_UNLESS_NET_MPSAFE);
		eval 'sub KERNEL_UNLOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do {  &KERNEL_UNLOCK_ONE( &NULL); }  &while (0));
		}' unless defined(&KERNEL_UNLOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_LOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do {  &mutex_enter( &softnet_lock); }  &while (0));
		}' unless defined(&SOFTNET_LOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_UNLOCK_UNLESS_NET_MPSAFE () {
		    eval q( &do {  &mutex_exit( &softnet_lock); }  &while (0));
		}' unless defined(&SOFTNET_UNLOCK_UNLESS_NET_MPSAFE);
		eval 'sub SOFTNET_LOCK_IF_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&SOFTNET_LOCK_IF_NET_MPSAFE);
		eval 'sub SOFTNET_UNLOCK_IF_NET_MPSAFE () {
		    eval q( &do { }  &while (0));
		}' unless defined(&SOFTNET_UNLOCK_IF_NET_MPSAFE);
	    }
	    eval 'sub SOFTNET_KERNEL_LOCK_UNLESS_NET_MPSAFE () {
	        eval q( &do {  &SOFTNET_LOCK_UNLESS_NET_MPSAFE();  &KERNEL_LOCK_UNLESS_NET_MPSAFE(); }  &while (0));
	    }' unless defined(&SOFTNET_KERNEL_LOCK_UNLESS_NET_MPSAFE);
	    eval 'sub SOFTNET_KERNEL_UNLOCK_UNLESS_NET_MPSAFE () {
	        eval q( &do {  &KERNEL_UNLOCK_UNLESS_NET_MPSAFE();  &SOFTNET_UNLOCK_UNLESS_NET_MPSAFE(); }  &while (0));
	    }' unless defined(&SOFTNET_KERNEL_UNLOCK_UNLESS_NET_MPSAFE);
	}
	eval 'sub IFFBITS () {"\\020\\1UP\\2BROADCAST\\3DEBUG\\4LOOPBACK\\5POINTOPOINT\\6UNNUMBERED" "\\7RUNNING\\10NOARP\\11PROMISC\\12ALLMULTI\\13OACTIVE\\14SIMPLEX" "\\15LINK0\\16LINK1\\17LINK2\\20MULTICAST";}' unless defined(&IFFBITS);
	eval 'sub IFF_CANTCHANGE () {( &IFF_BROADCAST| &IFF_POINTOPOINT| &IFF_RUNNING| &IFF_OACTIVE|  &IFF_SIMPLEX| &IFF_MULTICAST| &IFF_ALLMULTI| &IFF_PROMISC);}' unless defined(&IFF_CANTCHANGE);
	eval 'sub IF_Kbps {
	    my($x) = @_;
    	    eval q((($x) * 1000));
	}' unless defined(&IF_Kbps);
	eval 'sub IF_Mbps {
	    my($x) = @_;
    	    eval q(( &IF_Kbps(($x) * 1000)));
	}' unless defined(&IF_Mbps);
	eval 'sub IF_Gbps {
	    my($x) = @_;
    	    eval q(( &IF_Mbps(($x) * 1000)));
	}' unless defined(&IF_Gbps);
	eval 'sub IFCAP_TSOv4 () {0x80;}' unless defined(&IFCAP_TSOv4);
	eval 'sub IFCAP_CSUM_IPv4_Rx () {0x100;}' unless defined(&IFCAP_CSUM_IPv4_Rx);
	eval 'sub IFCAP_CSUM_IPv4_Tx () {0x200;}' unless defined(&IFCAP_CSUM_IPv4_Tx);
	eval 'sub IFCAP_CSUM_TCPv4_Rx () {0x400;}' unless defined(&IFCAP_CSUM_TCPv4_Rx);
	eval 'sub IFCAP_CSUM_TCPv4_Tx () {0x800;}' unless defined(&IFCAP_CSUM_TCPv4_Tx);
	eval 'sub IFCAP_CSUM_UDPv4_Rx () {0x1000;}' unless defined(&IFCAP_CSUM_UDPv4_Rx);
	eval 'sub IFCAP_CSUM_UDPv4_Tx () {0x2000;}' unless defined(&IFCAP_CSUM_UDPv4_Tx);
	eval 'sub IFCAP_CSUM_TCPv6_Rx () {0x4000;}' unless defined(&IFCAP_CSUM_TCPv6_Rx);
	eval 'sub IFCAP_CSUM_TCPv6_Tx () {0x8000;}' unless defined(&IFCAP_CSUM_TCPv6_Tx);
	eval 'sub IFCAP_CSUM_UDPv6_Rx () {0x10000;}' unless defined(&IFCAP_CSUM_UDPv6_Rx);
	eval 'sub IFCAP_CSUM_UDPv6_Tx () {0x20000;}' unless defined(&IFCAP_CSUM_UDPv6_Tx);
	eval 'sub IFCAP_TSOv6 () {0x40000;}' unless defined(&IFCAP_TSOv6);
	eval 'sub IFCAP_LRO () {0x80000;}' unless defined(&IFCAP_LRO);
	eval 'sub IFCAP_MASK () {0xfff80;}' unless defined(&IFCAP_MASK);
	eval 'sub IFCAPBITS () {"\\020" "\\10TSO4" "\\11IP4CSUM_Rx" "\\12IP4CSUM_Tx" "\\13TCP4CSUM_Rx" "\\14TCP4CSUM_Tx" "\\15UDP4CSUM_Rx" "\\16UDP4CSUM_Tx" "\\17TCP6CSUM_Rx" "\\20TCP6CSUM_Tx" "\\21UDP6CSUM_Rx" "\\22UDP6CSUM_Tx" "\\23TSO6" "\\24LRO";}' unless defined(&IFCAPBITS);
	eval 'sub IF_AFDATA_LOCK_INIT {
	    my($ifp) = @_;
    	    eval q( &do {($ifp)-> &if_afdata_lock =  &rw_obj_alloc();}  &while (0));
	}' unless defined(&IF_AFDATA_LOCK_INIT);
	eval 'sub IF_AFDATA_LOCK_DESTROY {
	    my($ifp) = @_;
    	    eval q( &rw_obj_free(($ifp)-> &if_afdata_lock));
	}' unless defined(&IF_AFDATA_LOCK_DESTROY);
	eval 'sub IF_AFDATA_WLOCK {
	    my($ifp) = @_;
    	    eval q( &rw_enter(($ifp)-> &if_afdata_lock,  &RW_WRITER));
	}' unless defined(&IF_AFDATA_WLOCK);
	eval 'sub IF_AFDATA_RLOCK {
	    my($ifp) = @_;
    	    eval q( &rw_enter(($ifp)-> &if_afdata_lock,  &RW_READER));
	}' unless defined(&IF_AFDATA_RLOCK);
	eval 'sub IF_AFDATA_WUNLOCK {
	    my($ifp) = @_;
    	    eval q( &rw_exit(($ifp)-> &if_afdata_lock));
	}' unless defined(&IF_AFDATA_WUNLOCK);
	eval 'sub IF_AFDATA_RUNLOCK {
	    my($ifp) = @_;
    	    eval q( &rw_exit(($ifp)-> &if_afdata_lock));
	}' unless defined(&IF_AFDATA_RUNLOCK);
	eval 'sub IF_AFDATA_LOCK {
	    my($ifp) = @_;
    	    eval q( &IF_AFDATA_WLOCK($ifp));
	}' unless defined(&IF_AFDATA_LOCK);
	eval 'sub IF_AFDATA_UNLOCK {
	    my($ifp) = @_;
    	    eval q( &IF_AFDATA_WUNLOCK($ifp));
	}' unless defined(&IF_AFDATA_UNLOCK);
	eval 'sub IF_AFDATA_TRYLOCK {
	    my($ifp) = @_;
    	    eval q( &rw_tryenter(($ifp)-> &if_afdata_lock,  &RW_WRITER));
	}' unless defined(&IF_AFDATA_TRYLOCK);
	eval 'sub IF_AFDATA_LOCK_ASSERT {
	    my($ifp) = @_;
    	    eval q( &KASSERT( &rw_lock_held(($ifp)-> &if_afdata_lock)));
	}' unless defined(&IF_AFDATA_LOCK_ASSERT);
	eval 'sub IF_AFDATA_RLOCK_ASSERT {
	    my($ifp) = @_;
    	    eval q( &KASSERT( &rw_read_held(($ifp)-> &if_afdata_lock)));
	}' unless defined(&IF_AFDATA_RLOCK_ASSERT);
	eval 'sub IF_AFDATA_WLOCK_ASSERT {
	    my($ifp) = @_;
    	    eval q( &KASSERT( &rw_write_held(($ifp)-> &if_afdata_lock)));
	}' unless defined(&IF_AFDATA_WLOCK_ASSERT);
	eval 'sub IF_QFULL {
	    my($ifq) = @_;
    	    eval q((($ifq)-> &ifq_len >= ($ifq)-> &ifq_maxlen));
	}' unless defined(&IF_QFULL);
	eval 'sub IF_DROP {
	    my($ifq) = @_;
    	    eval q((($ifq)-> &ifq_drops++));
	}' unless defined(&IF_DROP);
	eval 'sub IF_ENQUEUE {
	    my($ifq, $m) = @_;
    	    eval q( &do { ($m)-> &m_nextpkt = 0;  &if (($ifq)-> &ifq_tail == 0) ($ifq)-> &ifq_head = $m;  &else ($ifq)-> ($ifq_tail->{m_nextpkt}) = $m; ($ifq)-> &ifq_tail = $m; ($ifq)-> &ifq_len++; }  &while ( 0));
	}' unless defined(&IF_ENQUEUE);
	eval 'sub IF_PREPEND {
	    my($ifq, $m) = @_;
    	    eval q( &do { ($m)-> &m_nextpkt = ($ifq)-> &ifq_head;  &if (($ifq)-> &ifq_tail == 0) ($ifq)-> &ifq_tail = ($m); ($ifq)-> &ifq_head = ($m); ($ifq)-> &ifq_len++; }  &while ( 0));
	}' unless defined(&IF_PREPEND);
	eval 'sub IF_DEQUEUE {
	    my($ifq, $m) = @_;
    	    eval q( &do { ($m) = ($ifq)-> &ifq_head;  &if ($m) {  &if ((($ifq)-> &ifq_head = ($m)-> &m_nextpkt) == 0) ($ifq)-> &ifq_tail = 0; ($m)-> &m_nextpkt = 0; ($ifq)-> &ifq_len--; } }  &while ( 0));
	}' unless defined(&IF_DEQUEUE);
	eval 'sub IF_POLL {
	    my($ifq, $m) = @_;
    	    eval q((($m) = ($ifq)-> &ifq_head));
	}' unless defined(&IF_POLL);
	eval 'sub IF_PURGE {
	    my($ifq) = @_;
    	    eval q( &do { \'struct mbuf\' * &__m0;  &for (;;) {  &IF_DEQUEUE(($ifq),  &__m0);  &if ( &__m0 ==  &NULL)  &break;  &else  &m_freem( &__m0); } }  &while ( 0));
	}' unless defined(&IF_PURGE);
	eval 'sub IF_IS_EMPTY {
	    my($ifq) = @_;
    	    eval q((($ifq)-> &ifq_len == 0));
	}' unless defined(&IF_IS_EMPTY);
	unless(defined(&IFQ_MAXLEN)) {
	    eval 'sub IFQ_MAXLEN () {256;}' unless defined(&IFQ_MAXLEN);
	}
	eval 'sub IFNET_SLOWHZ () {1;}' unless defined(&IFNET_SLOWHZ);
	eval 'sub ifa_broadaddr () { &ifa_dstaddr;}' unless defined(&ifa_broadaddr);
	if(defined(&_KERNEL)) {
	}
	eval 'sub IFA_ROUTE () { &RTF_UP;}' unless defined(&IFA_ROUTE);
	eval 'sub IFA_DESTROYING () {0x2;}' unless defined(&IFA_DESTROYING);
	if(!defined(&_KERNEL) || !defined(&COMPAT_RTSOCK)) {
	    eval 'sub __align64 () { &__aligned($sizeof{ &uint64_t});}' unless defined(&__align64);
	} else {
	    eval 'sub __align64 () {1;}' unless defined(&__align64);
	}
	eval 'sub IFAN_ARRIVAL () {0;}' unless defined(&IFAN_ARRIVAL);
	eval 'sub IFAN_DEPARTURE () {1;}' unless defined(&IFAN_DEPARTURE);
	undef(&__align64) if defined(&__align64);
	eval 'sub ifr_addr () { ($ifr_ifru->{ifru_addr});}' unless defined(&ifr_addr);
	eval 'sub ifr_dstaddr () { ($ifr_ifru->{ifru_dstaddr});}' unless defined(&ifr_dstaddr);
	eval 'sub ifr_broadaddr () { ($ifr_ifru->{ifru_broadaddr});}' unless defined(&ifr_broadaddr);
	eval 'sub ifr_space () { ($ifr_ifru->{ifru_space});}' unless defined(&ifr_space);
	eval 'sub ifr_flags () { ($ifr_ifru->{ifru_flags});}' unless defined(&ifr_flags);
	eval 'sub ifr_addrflags () { ($ifr_ifru->{ifru_addrflags});}' unless defined(&ifr_addrflags);
	eval 'sub ifr_metric () { ($ifr_ifru->{ifru_metric});}' unless defined(&ifr_metric);
	eval 'sub ifr_mtu () { ($ifr_ifru->{ifru_mtu});}' unless defined(&ifr_mtu);
	eval 'sub ifr_dlt () { ($ifr_ifru->{ifru_dlt});}' unless defined(&ifr_dlt);
	eval 'sub ifr_value () { ($ifr_ifru->{ifru_value});}' unless defined(&ifr_value);
	eval 'sub ifr_media () { ($ifr_ifru->{ifru_metric});}' unless defined(&ifr_media);
	eval 'sub ifr_data () { ($ifr_ifru->{ifru_data});}' unless defined(&ifr_data);
	eval 'sub ifr_buf () { ($ifr_ifru->{ifru_b}->{b_buf});}' unless defined(&ifr_buf);
	eval 'sub ifr_buflen () { ($ifr_ifru->{ifru_b}->{b_buflen});}' unless defined(&ifr_buflen);
	eval 'sub ifr_index () { ($ifr_ifru->{ifru_value});}' unless defined(&ifr_index);
	eval 'sub ifr_ifindex () { &ifr_index;}' unless defined(&ifr_ifindex);
	if(defined(&_KERNEL)) {
	    eval 'sub ifreq_setdstaddr () { &ifreq_setaddr;}' unless defined(&ifreq_setdstaddr);
	    eval 'sub ifreq_setbroadaddr () { &ifreq_setaddr;}' unless defined(&ifreq_setbroadaddr);
	    eval 'sub ifreq_getdstaddr () { &ifreq_getaddr;}' unless defined(&ifreq_getdstaddr);
	    eval 'sub ifreq_getbroadaddr () { &ifreq_getaddr;}' unless defined(&ifreq_getbroadaddr);
	    eval 'sub ifreq_getaddr {
	        my($cmd,$ifr) = @_;
    		eval q({  ($ifr->{ifr_addr}); });
	    }' unless defined(&ifreq_getaddr);
	}
	eval 'sub ifra_broadaddr () { &ifra_dstaddr;}' unless defined(&ifra_broadaddr);
	eval 'sub IFLINKSTR_QUERYLEN () {0x1;}' unless defined(&IFLINKSTR_QUERYLEN);
	eval 'sub IFLINKSTR_UNSET () {0x2;}' unless defined(&IFLINKSTR_UNSET);
	eval 'sub ifc_buf () { ($ifc_ifcu->{ifcu_buf});}' unless defined(&ifc_buf);
	eval 'sub ifc_req () { ($ifc_ifcu->{ifcu_req});}' unless defined(&ifc_req);
	eval 'sub IFLR_PREFIX () {0x8000;}' unless defined(&IFLR_PREFIX);
	eval 'sub IFLR_ACTIVE () {0x4000;}' unless defined(&IFLR_ACTIVE);
	eval 'sub IFLR_FACTORY () {0x2000;}' unless defined(&IFLR_FACTORY);
	require 'net/if_arp.ph';
    }
    if(defined(&_KERNEL)) {
	if(defined(&ALTQ)) {
	    eval 'sub IFQ_ENQUEUE {
	        my($ifq, $m, $err) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &ALTQ_IS_ENABLED($ifq))  &ALTQ_ENQUEUE(($ifq), ($m), ($err));  &else {  &if ( &IF_QFULL($ifq)) {  &m_freem($m); ($err) =  &ENOBUFS; }  &else {  &IF_ENQUEUE(($ifq), ($m)); ($err) = 0; } }  &if (($err)) ($ifq)-> &ifq_drops++;  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_ENQUEUE);
	    eval 'sub IFQ_DEQUEUE {
	        my($ifq, $m) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &TBR_IS_ENABLED($ifq)) ($m) =  &tbr_dequeue(($ifq),  &ALTDQ_REMOVE);  &else  &if ( &ALTQ_IS_ENABLED($ifq))  &ALTQ_DEQUEUE(($ifq), ($m));  &else  &IF_DEQUEUE(($ifq), ($m));  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_DEQUEUE);
	    eval 'sub IFQ_POLL {
	        my($ifq, $m) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &TBR_IS_ENABLED($ifq)) ($m) =  &tbr_dequeue(($ifq),  &ALTDQ_POLL);  &else  &if ( &ALTQ_IS_ENABLED($ifq))  &ALTQ_POLL(($ifq), ($m));  &else  &IF_POLL(($ifq), ($m));  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_POLL);
	    eval 'sub IFQ_PURGE {
	        my($ifq) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &ALTQ_IS_ENABLED($ifq))  &ALTQ_PURGE($ifq);  &else  &IF_PURGE($ifq);  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_PURGE);
	    eval 'sub IFQ_SET_READY {
	        my($ifq) = @_;
    		eval q( &do { ($ifq)-> &altq_flags |=  &ALTQF_READY; }  &while ( 0));
	    }' unless defined(&IFQ_SET_READY);
	    eval 'sub IFQ_CLASSIFY {
	        my($ifq, $m, $af) = @_;
    		eval q( &do {  &KASSERT((($m)-> &m_flags &  &M_PKTHDR) != 0);  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &ALTQ_IS_ENABLED($ifq)) {  &if ( &ALTQ_NEEDS_CLASSIFY($ifq)) ($m)-> ($m_pkthdr->{pattr_class}) = (*($ifq)-> &altq_classify) (($ifq)-> &altq_clfier, ($m), ($af)); ($m)-> ($m_pkthdr->{pattr_af}) = ($af); ($m)-> ($m_pkthdr->{pattr_hdr}) =  &mtod(($m),  &void *); }  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_CLASSIFY);
	} else {
	    eval 'sub IFQ_ENQUEUE {
	        my($ifq, $m, $err) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &if ( &IF_QFULL($ifq)) {  &m_freem($m); ($err) =  &ENOBUFS; }  &else {  &IF_ENQUEUE(($ifq), ($m)); ($err) = 0; }  &if ($err) ($ifq)-> &ifq_drops++;  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_ENQUEUE);
	    eval 'sub IFQ_DEQUEUE {
	        my($ifq, $m) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &IF_DEQUEUE(($ifq), ($m));  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_DEQUEUE);
	    eval 'sub IFQ_POLL {
	        my($ifq, $m) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &IF_POLL(($ifq), ($m));  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_POLL);
	    eval 'sub IFQ_PURGE {
	        my($ifq) = @_;
    		eval q( &do {  &mutex_enter(($ifq)-> &ifq_lock);  &IF_PURGE($ifq);  &mutex_exit(($ifq)-> &ifq_lock); }  &while ( 0));
	    }' unless defined(&IFQ_PURGE);
	    eval 'sub IFQ_SET_READY {
	        my($ifq) = @_;
    		eval q();
	    }' unless defined(&IFQ_SET_READY);
	    eval 'sub IFQ_CLASSIFY {
	        my($ifq, $m, $af) = @_;
    		eval q();
	    }' unless defined(&IFQ_CLASSIFY);
	}
	eval 'sub IFQ_LOCK_INIT {
	    my($ifq) = @_;
    	    eval q(($ifq)-> &ifq_lock =  &mutex_obj_alloc( &MUTEX_DEFAULT,  &IPL_NET));
	}' unless defined(&IFQ_LOCK_INIT);
	eval 'sub IFQ_LOCK_DESTROY {
	    my($ifq) = @_;
    	    eval q( &mutex_obj_free(($ifq)-> &ifq_lock));
	}' unless defined(&IFQ_LOCK_DESTROY);
	eval 'sub IFQ_LOCK {
	    my($ifq) = @_;
    	    eval q( &mutex_enter(($ifq)-> &ifq_lock));
	}' unless defined(&IFQ_LOCK);
	eval 'sub IFQ_UNLOCK {
	    my($ifq) = @_;
    	    eval q( &mutex_exit(($ifq)-> &ifq_lock));
	}' unless defined(&IFQ_UNLOCK);
	eval 'sub IFQ_IS_EMPTY {
	    my($ifq) = @_;
    	    eval q( &IF_IS_EMPTY($ifq));
	}' unless defined(&IFQ_IS_EMPTY);
	eval 'sub IFQ_INC_LEN {
	    my($ifq) = @_;
    	    eval q((($ifq)-> &ifq_len++));
	}' unless defined(&IFQ_INC_LEN);
	eval 'sub IFQ_DEC_LEN {
	    my($ifq) = @_;
    	    eval q((--($ifq)-> &ifq_len));
	}' unless defined(&IFQ_DEC_LEN);
	eval 'sub IFQ_INC_DROPS {
	    my($ifq) = @_;
    	    eval q((($ifq)-> &ifq_drops++));
	}' unless defined(&IFQ_INC_DROPS);
	eval 'sub IFQ_SET_MAXLEN {
	    my($ifq, $len) = @_;
    	    eval q((($ifq)-> &ifq_maxlen = ($len)));
	}' unless defined(&IFQ_SET_MAXLEN);
	require 'sys/mallocvar.ph';
	eval 'sub if_release () { &if_put;}' unless defined(&if_release);
	eval 'sub if_tunnel_get_ro {
	    my($ro_percpu,$ro,$lock) = @_;
    	    eval q({ \'struct tunnel_ro\' * &tro;  &tro =  &percpu_getref($ro_percpu); *$ro =  ($t$ro->{tr_ro}); *$lock =  ($t$ro->{tr_lock});  &mutex_enter(*$lock); });
	}' unless defined(&if_tunnel_get_ro);
	eval 'sub if_tunnel_put_ro {
	    my($ro_percpu,$lock) = @_;
    	    eval q({  &mutex_exit($lock);  &percpu_putref($ro_percpu); });
	}' unless defined(&if_tunnel_put_ro);
	eval 'sub if_get_index {
	    my($ifp) = @_;
    	    eval q({ $ifp !=  &NULL ?  ($ifp->{if_index}) : 0; });
	}' unless defined(&if_get_index);
	eval 'sub if_nullwatchdog () { &if_nullslowtimo;}' unless defined(&if_nullwatchdog);
    } else {
	require 'sys/cdefs.ph';
    }
    if(defined(&_KERNEL)) {
	eval 'sub IFADDR_FIRST {
	    my($__ifp) = @_;
    	    eval q( &TAILQ_FIRST(($__ifp)-> &if_addrlist));
	}' unless defined(&IFADDR_FIRST);
	eval 'sub IFADDR_NEXT {
	    my($__ifa) = @_;
    	    eval q( &TAILQ_NEXT(($__ifa),  &ifa_list));
	}' unless defined(&IFADDR_NEXT);
	eval 'sub IFADDR_FOREACH {
	    my($__ifa, $__ifp) = @_;
    	    eval q( &TAILQ_FOREACH($__ifa, ($__ifp)-> &if_addrlist,  &ifa_list));
	}' unless defined(&IFADDR_FOREACH);
	eval 'sub IFADDR_FOREACH_SAFE {
	    my($__ifa, $__ifp, $__nifa) = @_;
    	    eval q( &TAILQ_FOREACH_SAFE($__ifa, ($__ifp)-> &if_addrlist,  &ifa_list, $__nifa));
	}' unless defined(&IFADDR_FOREACH_SAFE);
	eval 'sub IFADDR_EMPTY {
	    my($__ifp) = @_;
    	    eval q( &TAILQ_EMPTY(($__ifp)-> &if_addrlist));
	}' unless defined(&IFADDR_EMPTY);
	eval 'sub IFADDR_ENTRY_INIT {
	    my($__ifa) = @_;
    	    eval q( &PSLIST_ENTRY_INIT(($__ifa),  &ifa_pslist_entry));
	}' unless defined(&IFADDR_ENTRY_INIT);
	eval 'sub IFADDR_ENTRY_DESTROY {
	    my($__ifa) = @_;
    	    eval q( &PSLIST_ENTRY_DESTROY(($__ifa),  &ifa_pslist_entry));
	}' unless defined(&IFADDR_ENTRY_DESTROY);
	eval 'sub IFADDR_READER_EMPTY {
	    my($__ifp) = @_;
    	    eval q(( &PSLIST_READER_FIRST(($__ifp)-> &if_addr_pslist, \'struct ifaddr\',  &ifa_pslist_entry) ==  &NULL));
	}' unless defined(&IFADDR_READER_EMPTY);
	eval 'sub IFADDR_READER_FIRST {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_READER_FIRST(($__ifp)-> &if_addr_pslist, \'struct ifaddr\',  &ifa_pslist_entry));
	}' unless defined(&IFADDR_READER_FIRST);
	eval 'sub IFADDR_READER_NEXT {
	    my($__ifa) = @_;
    	    eval q( &PSLIST_READER_NEXT(($__ifa), \'struct ifaddr\',  &ifa_pslist_entry));
	}' unless defined(&IFADDR_READER_NEXT);
	eval 'sub IFADDR_READER_FOREACH {
	    my($__ifa, $__ifp) = @_;
    	    eval q( &PSLIST_READER_FOREACH(($__ifa), ($__ifp)-> &if_addr_pslist, \'struct ifaddr\',  &ifa_pslist_entry));
	}' unless defined(&IFADDR_READER_FOREACH);
	eval 'sub IFADDR_WRITER_INSERT_HEAD {
	    my($__ifp, $__ifa) = @_;
    	    eval q( &PSLIST_WRITER_INSERT_HEAD(($__ifp)-> &if_addr_pslist, ($__ifa),  &ifa_pslist_entry));
	}' unless defined(&IFADDR_WRITER_INSERT_HEAD);
	eval 'sub IFADDR_WRITER_REMOVE {
	    my($__ifa) = @_;
    	    eval q( &PSLIST_WRITER_REMOVE(($__ifa),  &ifa_pslist_entry));
	}' unless defined(&IFADDR_WRITER_REMOVE);
	eval 'sub IFADDR_WRITER_FOREACH {
	    my($__ifa, $__ifp) = @_;
    	    eval q( &PSLIST_WRITER_FOREACH(($__ifa), ($__ifp)-> &if_addr_pslist, \'struct ifaddr\',  &ifa_pslist_entry));
	}' unless defined(&IFADDR_WRITER_FOREACH);
	eval 'sub IFADDR_WRITER_NEXT {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_WRITER_NEXT(($__ifp), \'struct ifaddr\',  &ifa_pslist_entry));
	}' unless defined(&IFADDR_WRITER_NEXT);
	eval 'sub IFADDR_WRITER_INSERT_AFTER {
	    my($__ifp, $__new) = @_;
    	    eval q( &PSLIST_WRITER_INSERT_AFTER(($__ifp), ($__new),  &ifa_pslist_entry));
	}' unless defined(&IFADDR_WRITER_INSERT_AFTER);
	eval 'sub IFADDR_WRITER_EMPTY {
	    my($__ifp) = @_;
    	    eval q(( &PSLIST_WRITER_FIRST(($__ifp)-> &if_addr_pslist, \'struct ifaddr\',  &ifa_pslist_entry) ==  &NULL));
	}' unless defined(&IFADDR_WRITER_EMPTY);
	eval 'sub IFADDR_WRITER_INSERT_TAIL {
	    my($__ifp, $__new) = @_;
    	    eval q( &do {  &if ( &IFADDR_WRITER_EMPTY($__ifp)) {  &IFADDR_WRITER_INSERT_HEAD(($__ifp), ($__new)); }  &else { \'struct ifaddr\' * &__ifa;  &IFADDR_WRITER_FOREACH( &__ifa, ($__ifp)) {  &if ( &IFADDR_WRITER_NEXT( &__ifa) ==  &NULL) {  &IFADDR_WRITER_INSERT_AFTER( &__ifa, ($__new));  &break; } } } }  &while (0));
	}' unless defined(&IFADDR_WRITER_INSERT_TAIL);
	eval 'sub IFNET_GLOBAL_LOCK () {
	    eval q( &mutex_enter( &ifnet_mtx));
	}' unless defined(&IFNET_GLOBAL_LOCK);
	eval 'sub IFNET_GLOBAL_UNLOCK () {
	    eval q( &mutex_exit( &ifnet_mtx));
	}' unless defined(&IFNET_GLOBAL_UNLOCK);
	eval 'sub IFNET_GLOBAL_LOCKED () {
	    eval q( &mutex_owned( &ifnet_mtx));
	}' unless defined(&IFNET_GLOBAL_LOCKED);
	eval 'sub IFNET_READER_EMPTY () {
	    eval q(( &PSLIST_READER_FIRST( &ifnet_pslist, \'struct ifnet\',  &if_pslist_entry) ==  &NULL));
	}' unless defined(&IFNET_READER_EMPTY);
	eval 'sub IFNET_READER_FIRST () {
	    eval q( &PSLIST_READER_FIRST( &ifnet_pslist, \'struct ifnet\',  &if_pslist_entry));
	}' unless defined(&IFNET_READER_FIRST);
	eval 'sub IFNET_READER_NEXT {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_READER_NEXT(($__ifp), \'struct ifnet\',  &if_pslist_entry));
	}' unless defined(&IFNET_READER_NEXT);
	eval 'sub IFNET_READER_FOREACH {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_READER_FOREACH(($__ifp),  &ifnet_pslist, \'struct ifnet\',  &if_pslist_entry));
	}' unless defined(&IFNET_READER_FOREACH);
	eval 'sub IFNET_WRITER_INSERT_HEAD {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_WRITER_INSERT_HEAD( &ifnet_pslist, ($__ifp),  &if_pslist_entry));
	}' unless defined(&IFNET_WRITER_INSERT_HEAD);
	eval 'sub IFNET_WRITER_REMOVE {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_WRITER_REMOVE(($__ifp),  &if_pslist_entry));
	}' unless defined(&IFNET_WRITER_REMOVE);
	eval 'sub IFNET_WRITER_FOREACH {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_WRITER_FOREACH(($__ifp),  &ifnet_pslist, \'struct ifnet\',  &if_pslist_entry));
	}' unless defined(&IFNET_WRITER_FOREACH);
	eval 'sub IFNET_WRITER_NEXT {
	    my($__ifp) = @_;
    	    eval q( &PSLIST_WRITER_NEXT(($__ifp), \'struct ifnet\',  &if_pslist_entry));
	}' unless defined(&IFNET_WRITER_NEXT);
	eval 'sub IFNET_WRITER_INSERT_AFTER {
	    my($__ifp, $__new) = @_;
    	    eval q( &PSLIST_WRITER_INSERT_AFTER(($__ifp), ($__new),  &if_pslist_entry));
	}' unless defined(&IFNET_WRITER_INSERT_AFTER);
	eval 'sub IFNET_WRITER_EMPTY () {
	    eval q(( &PSLIST_WRITER_FIRST( &ifnet_pslist, \'struct ifnet\',  &if_pslist_entry) ==  &NULL));
	}' unless defined(&IFNET_WRITER_EMPTY);
	eval 'sub IFNET_WRITER_INSERT_TAIL {
	    my($__new) = @_;
    	    eval q( &do {  &if ( &IFNET_WRITER_EMPTY()) {  &IFNET_WRITER_INSERT_HEAD($__new); }  &else { \'struct ifnet\' * &__ifp;  &IFNET_WRITER_FOREACH( &__ifp) {  &if ( &IFNET_WRITER_NEXT( &__ifp) ==  &NULL) {  &IFNET_WRITER_INSERT_AFTER( &__ifp, ($__new));  &break; } } } }  &while (0));
	}' unless defined(&IFNET_WRITER_INSERT_TAIL);
	eval 'sub IFNET_LOCK {
	    my($ifp) = @_;
    	    eval q( &mutex_enter(($ifp)-> &if_ioctl_lock));
	}' unless defined(&IFNET_LOCK);
	eval 'sub IFNET_UNLOCK {
	    my($ifp) = @_;
    	    eval q( &mutex_exit(($ifp)-> &if_ioctl_lock));
	}' unless defined(&IFNET_UNLOCK);
	eval 'sub IFNET_LOCKED {
	    my($ifp) = @_;
    	    eval q( &mutex_owned(($ifp)-> &if_ioctl_lock));
	}' unless defined(&IFNET_LOCKED);
	eval 'sub IFNET_ASSERT_UNLOCKED {
	    my($ifp) = @_;
    	    eval q( &KDASSERT( &mutex_ownable(($ifp)-> &if_ioctl_lock)));
	}' unless defined(&IFNET_ASSERT_UNLOCKED);
	eval 'sub IFQCTL_LEN () {1;}' unless defined(&IFQCTL_LEN);
	eval 'sub IFQCTL_MAXLEN () {2;}' unless defined(&IFQCTL_MAXLEN);
	eval 'sub IFQCTL_PEAK () {3;}' unless defined(&IFQCTL_PEAK);
	eval 'sub IFQCTL_DROPS () {4;}' unless defined(&IFQCTL_DROPS);
    }
}
1;
