require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PTREE_H_)) {
    eval 'sub _SYS_PTREE_H_ () {1;}' unless defined(&_SYS_PTREE_H_);
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'stdbool.ph';
	require 'stdint.ph';
    }
    eval("sub PT_DESCENDING () { -1; }") unless defined(&PT_DESCENDING);
    eval("sub PT_ASCENDING () { 1; }") unless defined(&PT_ASCENDING);
    eval 'sub PT_SLOT_LEFT () {0;}' unless defined(&PT_SLOT_LEFT);
    eval 'sub PT_SLOT_RIGHT () {1;}' unless defined(&PT_SLOT_RIGHT);
    if(defined(&_PT_PRIVATE)) {
	eval 'sub PT_SLOT_ROOT () {0;}' unless defined(&PT_SLOT_ROOT);
	eval 'sub PT_SLOT_OTHER () {1;}' unless defined(&PT_SLOT_OTHER);
	eval 'sub PT_SLOT_ODDMAN () {1;}' unless defined(&PT_SLOT_ODDMAN);
	eval 'sub PT_TYPE_LEAF () {(( &uintptr_t)0x);}' unless defined(&PT_TYPE_LEAF);
	eval 'sub PT_TYPE_BRANCH () {(( &uintptr_t)0x1);}' unless defined(&PT_TYPE_BRANCH);
	eval 'sub PT_TYPE_MASK () {(( &uintptr_t)0x1);}' unless defined(&PT_TYPE_MASK);
    }
    if(defined(&_PT_PRIVATE)) {
	eval 'sub PTN_LEAF_POSITION_BITS () {8;}' unless defined(&PTN_LEAF_POSITION_BITS);
	eval 'sub PTN_LEAF_POSITION_SHIFT () {0;}' unless defined(&PTN_LEAF_POSITION_SHIFT);
	eval 'sub PTN_BRANCH_POSITION_BITS () {8;}' unless defined(&PTN_BRANCH_POSITION_BITS);
	eval 'sub PTN_BRANCH_POSITION_SHIFT () {8;}' unless defined(&PTN_BRANCH_POSITION_SHIFT);
	unless(defined(&PTNOMASK)) {
	    eval 'sub PTN_MASK_BITLEN_BITS () {15;}' unless defined(&PTN_MASK_BITLEN_BITS);
	    eval 'sub PTN_MASK_BITLEN_SHIFT () {16;}' unless defined(&PTN_MASK_BITLEN_SHIFT);
	    eval 'sub PTN_MASK_FLAG () {0x80000000;}' unless defined(&PTN_MASK_FLAG);
	}
    }
    if(defined(&_PT_PRIVATE)) {
	eval 'sub PTN_BRANCH_BITOFF_BITS () {15;}' unless defined(&PTN_BRANCH_BITOFF_BITS);
	eval 'sub PTN_BRANCH_BITOFF_SHIFT () {0;}' unless defined(&PTN_BRANCH_BITOFF_SHIFT);
	eval 'sub PTN_BRANCH_BITLEN_BITS () {8;}' unless defined(&PTN_BRANCH_BITLEN_BITS);
	eval 'sub PTN_BRANCH_BITLEN_SHIFT () {16;}' unless defined(&PTN_BRANCH_BITLEN_SHIFT);
	if(0) {
	    eval 'sub PTN_ORIENTATION_BITS () {1;}' unless defined(&PTN_ORIENTATION_BITS);
	    eval 'sub PTN_ORIENTATION_SHIFT () {30;}' unless defined(&PTN_ORIENTATION_SHIFT);
	}
	eval 'sub PTN_BRANCH_UNUSED () {0x3f000000;}' unless defined(&PTN_BRANCH_UNUSED);
	eval 'sub PTN_XBRANCH_FLAG () {0x80000000;}' unless defined(&PTN_XBRANCH_FLAG);
    }
    if(defined(&_PT_PRIVATE)) {
	eval 'sub PT_NODE {
	    my($node) = @_;
    	    eval q((( &pt_node_t *)($node & ~ &PT_TYPE_MASK)));
	}' unless defined(&PT_NODE);
	eval 'sub PT_TYPE {
	    my($node) = @_;
    	    eval q((($node) &  &PT_TYPE_MASK));
	}' unless defined(&PT_TYPE);
	eval 'sub PT_NULL () {0;}' unless defined(&PT_NULL);
	eval 'sub PT_NULL_P {
	    my($node) = @_;
    	    eval q((($node) ==  &PT_NULL));
	}' unless defined(&PT_NULL_P);
	eval 'sub PT_LEAF_P {
	    my($node) = @_;
    	    eval q(( &PT_TYPE($node) ==  &PT_TYPE_LEAF));
	}' unless defined(&PT_LEAF_P);
	eval 'sub PT_BRANCH_P {
	    my($node) = @_;
    	    eval q(( &PT_TYPE($node) ==  &PT_TYPE_BRANCH));
	}' unless defined(&PT_BRANCH_P);
	eval 'sub PTN__TYPELESS {
	    my($ptn) = @_;
    	    eval q(((( &uintptr_t)$ptn) & ~ &PT_TYPE_MASK));
	}' unless defined(&PTN__TYPELESS);
	eval 'sub PTN_LEAF {
	    my($ptn) = @_;
    	    eval q(( &PTN__TYPELESS($ptn) |  &PT_TYPE_LEAF));
	}' unless defined(&PTN_LEAF);
	eval 'sub PTN_BRANCH {
	    my($ptn) = @_;
    	    eval q(( &PTN__TYPELESS($ptn) |  &PT_TYPE_BRANCH));
	}' unless defined(&PTN_BRANCH);
	unless(defined(&PTNOMASK)) {
	    eval 'sub PTN_MARK_MASK {
	        my($ptn) = @_;
    		eval q((($ptn)-> &ptn_nodedata |=  &PTN_MASK_FLAG));
	    }' unless defined(&PTN_MARK_MASK);
	    eval 'sub PTN_ISMASK_P {
	        my($ptn) = @_;
    		eval q(((($ptn)-> &ptn_nodedata &  &PTN_MASK_FLAG) != 0));
	    }' unless defined(&PTN_ISMASK_P);
	}
	eval 'sub PTN_MARK_XBRANCH {
	    my($ptn) = @_;
    	    eval q((($ptn)-> &ptn_branchdata |=  &PTN_XBRANCH_FLAG));
	}' unless defined(&PTN_MARK_XBRANCH);
	eval 'sub PTN_ISXBRANCH_P {
	    my($ptn) = @_;
    	    eval q(((($ptn)-> &ptn_branchdata &  &PTN_XBRANCH_FLAG) != 0));
	}' unless defined(&PTN_ISXBRANCH_P);
	eval 'sub PTN_ISROOT_P {
	    my($pt, $ptn) = @_;
    	    eval q((($ptn) == ($pt)-> &pt_rootnode));
	}' unless defined(&PTN_ISROOT_P);
	eval 'sub PTN_BRANCH_SLOT {
	    my($ptn,$slot) = @_;
    	    eval q((($ptn)-> $ptn_slots[$slot]));
	}' unless defined(&PTN_BRANCH_SLOT);
	eval 'sub PTN_BRANCH_ROOT_SLOT {
	    my($ptn) = @_;
    	    eval q((($ptn)-> $ptn_slots[ &PT_SLOT_ROOT]));
	}' unless defined(&PTN_BRANCH_ROOT_SLOT);
	eval 'sub PTN_BRANCH_ODDMAN_SLOT {
	    my($ptn) = @_;
    	    eval q((($ptn)-> $ptn_slots[ &PT_SLOT_ODDMAN]));
	}' unless defined(&PTN_BRANCH_ODDMAN_SLOT);
	eval 'sub PTN_COPY_BRANCH_SLOTS {
	    my($dst,$src) = @_;
    	    eval q((($dst)-> $ptn_slots[ &PT_SLOT_LEFT ] = ($src)-> $ptn_slots[ &PT_SLOT_LEFT ], ($dst)-> $ptn_slots[ &PT_SLOT_RIGHT] = ($src)-> $ptn_slots[ &PT_SLOT_RIGHT]));
	}' unless defined(&PTN_COPY_BRANCH_SLOTS);
	eval 'sub PTN_ISSLOTVALID_P {
	    my($ptn,$slot) = @_;
    	    eval q((($slot) < (1<<  &PTN_BRANCH_BITLEN( &pt))));
	}' unless defined(&PTN_ISSLOTVALID_P);
	eval 'sub PT__MASK {
	    my($n) = @_;
    	    eval q(((1<< $n   &_BITS) - 1));
	}' unless defined(&PT__MASK);
	eval 'sub PT__SHIFT {
	    my($n) = @_;
    	    eval q(($n   &_SHIFT));
	}' unless defined(&PT__SHIFT);
	eval 'sub PTN__EXTRACT {
	    my($field, $b) = @_;
    	    eval q(((($field) >>  &PT__SHIFT($b)) &  &PT__MASK($b)));
	}' unless defined(&PTN__EXTRACT);
	eval 'sub PTN__INSERT2 {
	    my($field, $v, $shift, $mask) = @_;
    	    eval q((($field) = (($field) & ~(($mask) << ($shift))) | (($v) << ($shift))));
	}' unless defined(&PTN__INSERT2);
	eval 'sub PTN__INSERT {
	    my($field, $b, $v) = @_;
    	    eval q( &PTN__INSERT2($field, $v,  &PT__SHIFT($b),  &PT__MASK($b)));
	}' unless defined(&PTN__INSERT);
	eval 'sub PTN_BRANCH_BITOFF {
	    my($ptn) = @_;
    	    eval q( &PTN__EXTRACT(($ptn)-> &ptn_branchdata,  &PTN_BRANCH_BITOFF));
	}' unless defined(&PTN_BRANCH_BITOFF);
	eval 'sub PTN_BRANCH_BITLEN {
	    my($ptn) = @_;
    	    eval q( &PTN__EXTRACT(($ptn)-> &ptn_branchdata,  &PTN_BRANCH_BITLEN));
	}' unless defined(&PTN_BRANCH_BITLEN);
	eval 'sub PTN_SET_BRANCH_BITOFF {
	    my($ptn,$bitoff) = @_;
    	    eval q( &PTN__INSERT(($ptn)-> &ptn_branchdata,  &PTN_BRANCH_BITOFF, $bitoff));
	}' unless defined(&PTN_SET_BRANCH_BITOFF);
	eval 'sub PTN_SET_BRANCH_BITLEN {
	    my($ptn,$bitlen) = @_;
    	    eval q( &PTN__INSERT(($ptn)-> &ptn_branchdata,  &PTN_BRANCH_BITLEN, $bitlen));
	}' unless defined(&PTN_SET_BRANCH_BITLEN);
	eval 'sub PTN_LEAF_POSITION {
	    my($ptn) = @_;
    	    eval q( &PTN__EXTRACT(($ptn)-> &ptn_nodedata,  &PTN_LEAF_POSITION));
	}' unless defined(&PTN_LEAF_POSITION);
	eval 'sub PTN_BRANCH_POSITION {
	    my($ptn) = @_;
    	    eval q( &PTN__EXTRACT(($ptn)-> &ptn_nodedata,  &PTN_BRANCH_POSITION));
	}' unless defined(&PTN_BRANCH_POSITION);
	eval 'sub PTN_SET_LEAF_POSITION {
	    my($ptn,$slot) = @_;
    	    eval q( &PTN__INSERT(($ptn)-> &ptn_nodedata,  &PTN_LEAF_POSITION, $slot));
	}' unless defined(&PTN_SET_LEAF_POSITION);
	eval 'sub PTN_SET_BRANCH_POSITION {
	    my($ptn,$slot) = @_;
    	    eval q( &PTN__INSERT(($ptn)-> &ptn_nodedata,  &PTN_BRANCH_POSITION, $slot));
	}' unless defined(&PTN_SET_BRANCH_POSITION);
	unless(defined(&PTNOMASK)) {
	    eval 'sub PTN_MASK_BITLEN {
	        my($ptn) = @_;
    		eval q( &PTN__EXTRACT(($ptn)-> &ptn_nodedata,  &PTN_MASK_BITLEN));
	    }' unless defined(&PTN_MASK_BITLEN);
	    eval 'sub PTN_SET_MASK_BITLEN {
	        my($ptn,$masklen) = @_;
    		eval q( &PTN__INSERT(($ptn)-> &ptn_nodedata,  &PTN_MASK_BITLEN, $masklen));
	    }' unless defined(&PTN_SET_MASK_BITLEN);
	}
	if(0) {
	    eval 'sub PTN_ORIENTATION {
	        my($ptn) = @_;
    		eval q( &PTN__EXTRACT(($ptn)-> &ptn_branchdata,  &PTN_ORIENTATION));
	    }' unless defined(&PTN_ORIENTATION);
	    eval 'sub PTN_SET_ORIENTATION {
	        my($ptn,$slot) = @_;
    		eval q( &PTN__INSERT(($ptn)-> &ptn_branchdata,  &PTN_ORIENTATION, $slot));
	    }' unless defined(&PTN_SET_ORIENTATION);
	}
    }
    eval 'sub pt_root () { ($pt_rootnode->{ptn_slots[&PT_SLOT_ROOT]});}' unless defined(&pt_root);
    eval 'sub pt_oddman () { ($pt_rootnode->{ptn_slots[&PT_SLOT_ODDMAN]});}' unless defined(&pt_oddman);
    eval 'sub PT_FILTER_MASK () {0x1;}' unless defined(&PT_FILTER_MASK);
    eval 'sub ptree_find_node {
        my($pt,$key) = @_;
	    eval q( &ptree_find_filtered_node(($pt), ($key),  &NULL,  &NULL));
    }' unless defined(&ptree_find_node);
}
1;
