<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue extends \Google\Model
{
  protected $addressValueType = GoogleTypePostalAddress::class;
  protected $addressValueDataType = '';
  public $booleanValue;
  protected $dateValueType = GoogleTypeDate::class;
  protected $dateValueDataType = '';
  protected $datetimeValueType = GoogleTypeDateTime::class;
  protected $datetimeValueDataType = '';
  public $floatValue;
  public $integerValue;
  protected $moneyValueType = GoogleTypeMoney::class;
  protected $moneyValueDataType = '';
  public $text;

  /**
   * @param GoogleTypePostalAddress
   */
  public function setAddressValue(GoogleTypePostalAddress $addressValue)
  {
    $this->addressValue = $addressValue;
  }
  /**
   * @return GoogleTypePostalAddress
   */
  public function getAddressValue()
  {
    return $this->addressValue;
  }
  public function setBooleanValue($booleanValue)
  {
    $this->booleanValue = $booleanValue;
  }
  public function getBooleanValue()
  {
    return $this->booleanValue;
  }
  /**
   * @param GoogleTypeDate
   */
  public function setDateValue(GoogleTypeDate $dateValue)
  {
    $this->dateValue = $dateValue;
  }
  /**
   * @return GoogleTypeDate
   */
  public function getDateValue()
  {
    return $this->dateValue;
  }
  /**
   * @param GoogleTypeDateTime
   */
  public function setDatetimeValue(GoogleTypeDateTime $datetimeValue)
  {
    $this->datetimeValue = $datetimeValue;
  }
  /**
   * @return GoogleTypeDateTime
   */
  public function getDatetimeValue()
  {
    return $this->datetimeValue;
  }
  public function setFloatValue($floatValue)
  {
    $this->floatValue = $floatValue;
  }
  public function getFloatValue()
  {
    return $this->floatValue;
  }
  public function setIntegerValue($integerValue)
  {
    $this->integerValue = $integerValue;
  }
  public function getIntegerValue()
  {
    return $this->integerValue;
  }
  /**
   * @param GoogleTypeMoney
   */
  public function setMoneyValue(GoogleTypeMoney $moneyValue)
  {
    $this->moneyValue = $moneyValue;
  }
  /**
   * @return GoogleTypeMoney
   */
  public function getMoneyValue()
  {
    return $this->moneyValue;
  }
  public function setText($text)
  {
    $this->text = $text;
  }
  public function getText()
  {
    return $this->text;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue::class, 'Google_Service_Document_GoogleCloudDocumentaiV1beta2DocumentEntityNormalizedValue');
