/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.ui.action.command.BrowserCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.BuildToolsCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.Command;
import org.netbeans.modules.web.clientproject.ui.action.command.CopyCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.DeleteCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.MoveCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.PlatformCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.RenameCommand;
import org.netbeans.modules.web.clientproject.ui.action.command.TestProjectCommand;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;

public class ClientSideProjectActionProvider
implements ActionProvider {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectActionProvider.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final ClientSideProject project;
    private final Map<String, Command> commands = new ConcurrentHashMap<String, Command>();
    private final List<String> supportedActions;

    public ClientSideProjectActionProvider(ClientSideProject project) {
        this.project = project;
        this.fillCommands();
        assert (!this.commands.isEmpty());
        this.supportedActions = new ArrayList<String>(this.commands.keySet());
        this.addDebugCommands();
    }

    private void fillCommands() {
        Command[] allCommands;
        for (Command command : allCommands = new Command[]{new BrowserCommand(this.project, "run.single"), new BrowserCommand(this.project, "run"), new TestProjectCommand(this.project), new BuildToolsCommand(this.project, "build"), new BuildToolsCommand(this.project, "rebuild"), new BuildToolsCommand(this.project, "clean"), new BuildToolsCommand(this.project, "test.single"), new CopyCommand(this.project), new MoveCommand(this.project), new RenameCommand(this.project), new DeleteCommand(this.project)}) {
            Command old = this.commands.put(command.getCommandId(), command);
            assert (old == null) : "Command already set for " + command.getCommandId();
        }
    }

    private void addDebugCommands() {
        Command old = this.commands.put("debug", this.getCommand("run"));
        assert (old == null) : "Command already set for run";
        old = this.commands.put("debug.single", this.getCommand("run.single"));
        assert (old == null) : "Command already set for run.single";
    }

    private boolean isDebugCommand(String commandId) {
        return "debug".equals(commandId) || "debug.single".equals(commandId);
    }

    public String[] getSupportedActions() {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        actions.addAll(this.supportedActions);
        actions.addAll(new BrowserCommand(this.project, "dummy").getSupportedActions());
        actions.addAll(new PlatformCommand(this.project, "dummy").getSupportedActions());
        return new ArrayList(actions).toArray(new String[actions.size()]);
    }

    public boolean isActionEnabled(String commandId, Lookup lookup) {
        if (this.isCommandEnabled(new PlatformCommand(this.project, commandId), lookup)) {
            return true;
        }
        if (this.isCommandEnabled(new BrowserCommand(this.project, commandId), lookup)) {
            return true;
        }
        if (this.isDebugCommand(commandId)) {
            return false;
        }
        return this.getCommand(commandId).isActionEnabled(lookup);
    }

    public void invokeAction(final String commandId, final Lookup lookup) {
        final Command command = this.getCommand(commandId);
        EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                LifecycleManager.getDefault().saveAll();
                AtomicBoolean warnUser = new AtomicBoolean(true);
                ClientSideProjectActionProvider.this.tryBuildTools(commandId);
                ClientSideProjectActionProvider.this.tryPlatform(commandId, lookup, warnUser);
                command.invokeAction(lookup, warnUser);
                ClientSideProjectActionProvider.this.tryBrowser(commandId, lookup, warnUser);
            }
        });
    }

    private Command getCommand(String commandId) {
        Command retval = this.commands.get(commandId);
        assert (retval != null) : commandId;
        return retval;
    }

    private boolean isCommandEnabled(Command command, Lookup context) {
        return command.isActionEnabled(context);
    }

    void tryBuildTools(String commandId) {
        if (this.getCommand(commandId) instanceof BuildToolsCommand) {
            return;
        }
        new BuildToolsCommand(this.project, commandId).tryBuild(false, true);
    }

    void tryPlatform(String commandId, Lookup context, AtomicBoolean warnUser) {
        PlatformCommand platformCommand = new PlatformCommand(this.project, commandId);
        if (this.isCommandEnabled(platformCommand, context)) {
            platformCommand.invokeAction(context, warnUser);
        }
    }

    void tryBrowser(String commandId, Lookup context, AtomicBoolean warnUser) {
        if (this.getCommand(commandId) instanceof BrowserCommand) {
            return;
        }
        BrowserCommand browserCommand = new BrowserCommand(this.project, commandId);
        if (this.isCommandEnabled(browserCommand, context)) {
            browserCommand.invokeAction(context, warnUser);
        }
    }
}

