/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;

public class AttributeValueFinder {
    private final SyntaxSupport syntaxSupport;
    private final int start;
    private int foundOffset = -1;
    private String foundValue;

    public AttributeValueFinder(SyntaxSupport syntaxSupport, int start) {
        this.syntaxSupport = syntaxSupport;
        this.start = start;
    }

    public boolean find(String attrName) throws BadLocationException {
        this.foundOffset = -1;
        this.foundValue = null;
        BaseDocument doc = this.syntaxSupport.getDocument();
        if (!(this.syntaxSupport instanceof ExtSyntaxSupport)) {
            return false;
        }
        TokenItem item = ((ExtSyntaxSupport)this.syntaxSupport).getTokenChain(this.start, Math.min(this.start + 1, doc.getLength()));
        if (item == null || item.getTokenID() != XMLDefaultTokenContext.TAG) {
            return false;
        }
        String currentAttrName = null;
        for (item = item.getNext(); item != null; item = item.getNext()) {
            TokenID id = item.getTokenID();
            if (id == XMLDefaultTokenContext.ARGUMENT) {
                currentAttrName = item.getImage();
                continue;
            }
            if (id == XMLDefaultTokenContext.VALUE) {
                if (currentAttrName == null || !currentAttrName.equals(attrName)) continue;
                this.foundOffset = item.getOffset();
                this.foundValue = item.getImage();
                return true;
            }
            if (id == XMLDefaultTokenContext.TAG) break;
        }
        return false;
    }

    public int getFoundOffset() {
        return this.foundOffset;
    }

    public String getValue() {
        return this.foundValue;
    }
}

