/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.java.JavaCompletionDoc;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.JavaCompletionItemFactory;
import org.netbeans.modules.editor.java.MethodParamsTipPaintComponent;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.completion.JavaCompletionTask;
import org.netbeans.modules.java.completion.JavaDocumentationTask;
import org.netbeans.modules.java.completion.JavaTooltipTask;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        if (typedText != null && typedText.length() == 1 && (Utilities.getJavaCompletionAutoPopupTriggers().indexOf(typedText.charAt(0)) >= 0 || Utilities.autoPopupOnJavaIdentifierPart() && JavaCompletionQuery.isJavaIdentifierPart(typedText)) && Utilities.isJavaContext(component, component.getSelectionStart() - 1, true)) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int type, JTextComponent component) {
        if ((type & 1) != 0 || type == 4 || type == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionQuery(type, component.getSelectionStart()), component);
        }
        return null;
    }

    static CompletionTask createDocTask(ElementHandle element) {
        JavaCompletionQuery query = new JavaCompletionQuery(2, -1);
        query.element = element;
        return new AsyncCompletionTask((AsyncCompletionQuery)query, EditorRegistry.lastFocusedComponent());
    }

    public static List<? extends CompletionItem> query(Source source, int queryType, int offset, int substitutionOffset) throws Exception {
        assert (source != null);
        assert ((queryType & 1) != 0);
        JavaCompletionTask task = JavaCompletionTask.create((int)offset, (JavaCompletionTask.ItemFactory)new JavaCompletionItemFactory(source.getFileObject()), EnumSet.noneOf(JavaCompletionTask.Options.class), null);
        ParserManager.parse(Collections.singletonList(source), (UserTask)task);
        if (offset != substitutionOffset) {
            for (JavaCompletionItem jci : task.getResults()) {
                jci.substitutionOffset += substitutionOffset - offset;
            }
        }
        return task.getResults();
    }

    static final class JavaCompletionQuery
    extends AsyncCompletionQuery {
        static final AtomicBoolean javadocBreak = new AtomicBoolean();
        static final AtomicReference<CompletionDocumentation> outerDocumentation = new AtomicReference();
        private static final String EMPTY = "";
        private static final String SKIP_ACCESSIBILITY_CHECK = "org.netbeans.modules.editor.java.JavaCompletionProvider.skipAccessibilityCheck";
        private List<JavaCompletionItem> results;
        private boolean hasAdditionalItems;
        private MethodParamsTipPaintComponent toolTip;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private int toolTipOffset;
        private JTextComponent component;
        private final int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;

        private JavaCompletionQuery(int queryType, int caretOffset) {
            this.queryType = queryType;
            this.caretOffset = caretOffset;
        }

        protected void preQueryUpdate(JTextComponent component) {
            int newCaretOffset = component.getSelectionStart();
            if (newCaretOffset >= this.caretOffset) {
                try {
                    if (JavaCompletionQuery.isJavaIdentifierPart(component.getDocument().getText(this.caretOffset, newCaretOffset - this.caretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
            if (this.queryType == 4) {
                this.toolTip = new MethodParamsTipPaintComponent(component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            block26: {
                try {
                    JavaTooltipTask task;
                    FileObject fo;
                    ClasspathInfo cpInfo;
                    this.caretOffset = caretOffset;
                    CompletionDocumentation outerDoc = outerDocumentation.getAndSet(null);
                    if (this.queryType == 2 && outerDoc != null) {
                        int offset;
                        MouseEvent lme;
                        resultSet.setDocumentation(outerDoc);
                        ToolTipSupport tts = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)this.component).getToolTipSupport();
                        if (tts != null && (lme = tts.getLastMouseEvent()) != null && (offset = this.component.viewToModel(lme.getPoint())) > -1) {
                            resultSet.setAnchorOffset(offset);
                        }
                        break block26;
                    }
                    if (this.queryType != 4 && !Utilities.isJavaContext(this.component, caretOffset, true)) break block26;
                    this.results = null;
                    this.documentation = null;
                    if (this.toolTip != null) {
                        this.toolTip.clearData();
                    }
                    this.anchorOffset = -1;
                    Source source = null;
                    if (this.queryType == 2 && this.element != null && (cpInfo = ClasspathInfo.create((Document)doc)) != null && (fo = SourceUtils.getFile((ElementHandle)this.element, (ClasspathInfo)cpInfo)) != null) {
                        source = Source.create((FileObject)fo);
                    }
                    if (source == null) {
                        source = Source.create((Document)doc);
                    }
                    if (source == null) break block26;
                    if ((this.queryType & 1) != 0) {
                        Object prop;
                        EnumSet<JavaCompletionTask.Options> options = EnumSet.noneOf(JavaCompletionTask.Options.class);
                        Object object = prop = this.component != null ? this.component.getDocument().getProperty(SKIP_ACCESSIBILITY_CHECK) : null;
                        if (prop instanceof String && Boolean.parseBoolean((String)prop)) {
                            options.add(JavaCompletionTask.Options.SKIP_ACCESSIBILITY_CHECK);
                        }
                        if (this.queryType == 9) {
                            options.add(JavaCompletionTask.Options.ALL_COMPLETION);
                        }
                        JavaCompletionTask task2 = JavaCompletionTask.create((int)caretOffset, (JavaCompletionTask.ItemFactory)new JavaCompletionItemFactory(source.getFileObject()), options, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                return JavaCompletionQuery.this.isTaskCancelled();
                            }
                        });
                        if (this.component != null) {
                            this.component.putClientProperty("completion-active", Boolean.TRUE);
                        }
                        ParserManager.parse(Collections.singletonList(source), (UserTask)task2);
                        if (this.component != null) {
                            this.component.putClientProperty("completion-active", Boolean.FALSE);
                        }
                        this.results = task2.getResults();
                        if (this.results != null) {
                            resultSet.addAllItems(this.results);
                        }
                        this.hasAdditionalItems = task2.hasAdditionalClasses() || task2.hasAdditionalMembers();
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems);
                        if (task2.hasAdditionalClasses()) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JavaCompletionProvider.class, (String)"JCP-imported-items"));
                        }
                        if (task2.hasAdditionalMembers()) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JavaCompletionProvider.class, (String)"JCP-instance-members"));
                        }
                        this.anchorOffset = task2.getAnchorOffset();
                        if (this.anchorOffset > -1) {
                            resultSet.setAnchorOffset(this.anchorOffset);
                        }
                        break block26;
                    }
                    if (this.queryType == 4) {
                        task = JavaTooltipTask.create((int)caretOffset, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                return JavaCompletionQuery.this.isTaskCancelled();
                            }
                        });
                        ParserManager.parse(Collections.singletonList(source), (UserTask)task);
                        if (task.getTooltipData() != null) {
                            this.toolTip.setData(task.getTooltipData(), task.getTooltipIndex());
                            resultSet.setToolTip((JToolTip)this.toolTip);
                            this.toolTipOffset = task.getTooltipOffset();
                        }
                        this.anchorOffset = task.getAnchorOffset();
                        if (this.anchorOffset > -1) {
                            resultSet.setAnchorOffset(this.anchorOffset);
                        }
                        break block26;
                    }
                    if (this.queryType != 2) break block26;
                    task = JavaDocumentationTask.create((int)caretOffset, (ElementHandle)this.element, (JavaDocumentationTask.DocumentationFactory)new JavaDocumentationTask.DocumentationFactory<ElementJavadoc>(){

                        public ElementJavadoc create(CompilationInfo compilationInfo, Element element, Callable<Boolean> cancel) {
                            return ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element, cancel);
                        }
                    }, (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return JavaCompletionQuery.this.isTaskCancelled();
                        }
                    });
                    ParserManager.parse(Collections.singletonList(source), (UserTask)task);
                    if (task.getDocumentation() == null) break block26;
                    this.documentation = new JavaCompletionDoc((ElementJavadoc)task.getDocumentation());
                    while (!this.isTaskCancelled()) {
                        try {
                            if (javadocBreak.getAndSet(false)) {
                                Completion c = Completion.get();
                                c.hideDocumentation();
                                c.showDocumentation();
                            }
                            ((JavaCompletionDoc)this.documentation).getFutureText().get(250L, TimeUnit.MILLISECONDS);
                            resultSet.setDocumentation(this.documentation);
                            break;
                        }
                        catch (TimeoutException timeoutException) {
                        }
                    }
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    resultSet.finish();
                }
            }
        }

        protected boolean canFilter(JTextComponent component) {
            if (component.getCaret() == null) {
                return false;
            }
            this.filterPrefix = null;
            int newOffset = component.getSelectionStart();
            final Document doc = component.getDocument();
            if ((this.queryType & 1) != 0) {
                final int offset = Math.min(this.anchorOffset, this.caretOffset);
                if (offset > -1) {
                    if (newOffset < offset) {
                        return true;
                    }
                    if (newOffset >= this.caretOffset) {
                        try {
                            final int len = newOffset - offset;
                            if (len == 0) {
                                this.filterPrefix = EMPTY;
                            } else if (len > 0) {
                                doc.render(new Runnable(){

                                    @Override
                                    public void run() {
                                        TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)doc), (int)offset);
                                        if (ts != null && ts.move(offset) == 0 && ts.moveNext() && (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) && ts.token().length() >= len) {
                                            JavaCompletionQuery.this.filterPrefix = ts.token().text().toString().substring(0, len);
                                        }
                                    }
                                });
                            }
                            if (this.filterPrefix == null) {
                                String prefix = doc.getText(offset, newOffset - offset);
                                if (prefix.length() > 0 && Utilities.getJavaCompletionAutoPopupTriggers().indexOf(prefix.charAt(prefix.length() - 1)) >= 0) {
                                    return false;
                                }
                            } else if (this.filterPrefix.length() == 0) {
                                this.anchorOffset = newOffset;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        return true;
                    }
                }
                return false;
            }
            if (this.queryType == 4) {
                try {
                    if (newOffset == this.caretOffset) {
                        this.filterPrefix = EMPTY;
                    } else if (newOffset - this.caretOffset > 0) {
                        this.filterPrefix = doc.getText(this.caretOffset, newOffset - this.caretOffset);
                    } else if (newOffset - this.caretOffset < 0) {
                        this.filterPrefix = newOffset > this.toolTipOffset ? doc.getText(newOffset, this.caretOffset - newOffset) : null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return this.filterPrefix != null && this.filterPrefix.indexOf(44) == -1 && this.filterPrefix.indexOf(40) == -1 && this.filterPrefix.indexOf(41) == -1;
            }
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            try {
                if ((this.queryType & 1) != 0) {
                    if (this.results != null) {
                        if (this.filterPrefix != null) {
                            resultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                            resultSet.setHasAdditionalItems(this.hasAdditionalItems);
                        } else {
                            Completion.get().hideDocumentation();
                            Completion.get().hideCompletion();
                        }
                    }
                } else if (this.queryType == 4) {
                    resultSet.setToolTip(this.toolTip != null && this.toolTip.hasData() ? this.toolTip : null);
                }
                resultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            resultSet.finish();
        }

        private static boolean isJavaIdentifierPart(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection<JavaCompletionItem> data, String prefix) {
            if (prefix.length() == 0) {
                return data;
            }
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            boolean camelCase = JavaCompletionQuery.isCamelCasePrefix(prefix);
            block0: for (CompletionItem completionItem : data) {
                CharSequence cs = completionItem != null ? completionItem.getInsertPrefix() : null;
                if (cs == null) continue;
                for (String s : cs.toString().split("\\.")) {
                    if (!org.netbeans.modules.java.completion.Utilities.startsWith((String)s, (String)prefix) && (!camelCase || !org.netbeans.modules.java.completion.Utilities.startsWithCamelCase((String)s, (String)prefix))) continue;
                    ret.add(completionItem);
                    continue block0;
                }
            }
            return ret;
        }

        private static boolean isCamelCasePrefix(String prefix) {
            if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
                return false;
            }
            for (int i = 1; i < prefix.length(); ++i) {
                if (!Character.isUpperCase(prefix.charAt(i))) continue;
                return true;
            }
            return false;
        }
    }
}

