/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.config.ProgressObjectSupport;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasourceManager;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.config.xml.jms.WildflyMessageDestinationHandler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class WildflyMessageDestinationManager
implements MessageDestinationDeployment {
    private static final Logger LOGGER = Logger.getLogger(WildflyMessageDestinationManager.class.getName());
    private final FileObject serverDir;
    private final FileObject configFile;
    private final WildflyDeploymentManager dm;

    public WildflyMessageDestinationManager(WildflyDeploymentManager dm) {
        this.dm = dm;
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)dm.getUrl());
        String serverDirPath = ip.getProperty("server-dir");
        this.serverDir = FileUtil.toFileObject((File)new File(serverDirPath));
        FileObject config = null;
        if (ip.getProperty("config_file") != null) {
            config = FileUtil.toFileObject((File)new File(ip.getProperty("config_file")));
        }
        if (config == null) {
            config = this.serverDir.getFileObject("configuration/standalone.xml");
        }
        if (config == null) {
            config = this.serverDir.getFileObject("configuration/domain.xml");
        }
        this.configFile = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        HashSet<MessageDestination> messageDestinations = new HashSet<MessageDestination>();
        if (this.configFile == null || !this.configFile.isData()) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(WildflyDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"));
            return messageDestinations;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            WildflyMessageDestinationHandler handler = new WildflyMessageDestinationHandler();
            try (BufferedInputStream is = new BufferedInputStream(this.configFile.getInputStream());){
                parser.parse((InputStream)is, (DefaultHandler)handler);
            }
            messageDestinations.addAll(handler.getMessageDestinations());
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(WildflyDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(WildflyDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
        }
        catch (ParserConfigurationException ex) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(WildflyDatasourceManager.class, (String)"ERR_WRONG_JMS_CONFIG_FILE"), ex);
        }
        return messageDestinations;
    }

    private Map<String, MessageDestination> createMap(Set<MessageDestination> destinations) {
        if (destinations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MessageDestination> map = new HashMap<String, MessageDestination>();
        for (MessageDestination destination : destinations) {
            map.put(destination.getName(), destination);
            WildflyMessageDestination jbossMessageDestination = (WildflyMessageDestination)destination;
            for (String jndiName : jbossMessageDestination.getJndiNames()) {
                map.put(jndiName, destination);
            }
        }
        return map;
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
        Set<MessageDestination> deployedDestinations = this.getMessageDestinations();
        Map<String, MessageDestination> deployed = this.createMap(deployedDestinations);
        ArrayList<WildflyMessageDestination> toDeploy = new ArrayList<WildflyMessageDestination>();
        LinkedList<MessageDestination> conflictJMS = new LinkedList<MessageDestination>();
        for (MessageDestination destination : destinations) {
            if (!(destination instanceof WildflyMessageDestination)) {
                LOGGER.log(Level.INFO, "Unable to deploy {0}", destination);
                continue;
            }
            WildflyMessageDestination jbossMessageDestination = (WildflyMessageDestination)destination;
            String name = jbossMessageDestination.getName();
            HashSet<String> jndiNames = new HashSet<String>(jbossMessageDestination.getJndiNames());
            jndiNames.retainAll(deployed.keySet());
            if (deployed.keySet().contains(jbossMessageDestination.getName()) || !jndiNames.isEmpty()) {
                MessageDestination deployedMessageDestination = deployed.get(name);
                if (deployedMessageDestination.equals(jbossMessageDestination)) continue;
                conflictJMS.add(deployed.get(name));
                continue;
            }
            toDeploy.add(jbossMessageDestination);
        }
        if (!conflictJMS.isEmpty()) {
            // empty if block
        }
        ProgressObject po = this.dm.deployMessageDestinations(toDeploy);
        ProgressObjectSupport.waitFor(po);
        if (po.getDeploymentStatus().isFailed()) {
            String msg = NbBundle.getMessage(WildflyMessageDestinationManager.class, (String)"MSG_FailedToDeployJMS");
            throw new ConfigurationException(msg);
        }
    }
}

