/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CompositeComponentModel
extends JsfPageModel {
    private static final Logger LOGGER = Logger.getLogger(CompositeComponentModel.class.getSimpleName());
    static final String LIBRARY_NAME_KEY = "library";
    static final String INTERFACE_ATTRIBUTES_KEY = "interface_attributes";
    static final String INTERFACE_DESCRIPTION_KEY = "interface_description";
    static final String INTERFACE_FACETS = "interface_facets";
    static final String HAS_IMPLEMENTATION_KEY = "has_implementation";
    private static final String WEBAPP_RESOURCES_DIRECTORY = "javax.faces.WEBAPP_RESOURCES_DIRECTORY";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final char VALUES_SEPARATOR = ',';
    private static final char ATTRIBUTES_SEPARATOR = ';';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final String NOT_AVAILABLE_VALUE = "n/a";
    private static final Collection<String> COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES = Arrays.asList("name", "targets", "default", "displayName", "expert", "method-signature", "preferred", "required", "shortDescription", "type");
    protected Collection<Map<String, String>> attributes;
    protected Collection<String> facetsDeclarations;
    protected boolean hasImplementation;
    protected FileObject sourceFile;
    protected String relativePath;
    protected String interfaceDisplayName;
    protected String interfaceShortDescription;

    public CompositeComponentModel(FileObject file, Collection<Map<String, String>> attributes, boolean hasImplementation, Collection<String> facetsDeclarations, String interfaceDisplayName, String interfaceShortDescription) {
        this(file, null, attributes, hasImplementation, facetsDeclarations, interfaceDisplayName, interfaceShortDescription);
    }

    public CompositeComponentModel(FileObject file, String relativePath, Collection<Map<String, String>> attributes, boolean hasImplementation, Collection<String> facetsDeclarations, String interfaceDisplayName, String interfaceShortDescription) {
        this.attributes = attributes;
        this.hasImplementation = hasImplementation;
        this.sourceFile = file;
        this.relativePath = relativePath;
        this.facetsDeclarations = facetsDeclarations;
        this.interfaceDisplayName = interfaceDisplayName;
        this.interfaceShortDescription = interfaceShortDescription;
    }

    public String getComponentName() {
        return this.sourceFile.getName();
    }

    public String getDisplayName() {
        return this.interfaceDisplayName != null && NOT_AVAILABLE_VALUE.equals(this.interfaceDisplayName) ? null : this.interfaceDisplayName;
    }

    public String getShortDescription() {
        return this.interfaceShortDescription != null && NOT_AVAILABLE_VALUE.equals(this.interfaceShortDescription) ? null : this.interfaceShortDescription;
    }

    public FileObject getSourceFile() {
        return this.sourceFile;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isHasImplementation() {
        return this.hasImplementation;
    }

    public Collection<Map<String, String>> getExistingInterfaceAttributes() {
        return this.attributes;
    }

    public Collection<String> getPossibleAttributeTagAttributes() {
        return COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES;
    }

    public Collection<String> getDeclaredFacets() {
        return this.facetsDeclarations;
    }

    @Override
    public String storeToIndex(IndexDocument document) {
        String libraryName = this.getLibraryPath();
        document.addPair(LIBRARY_NAME_KEY, libraryName, true, true);
        StringBuilder buf = new StringBuilder();
        Iterator<Map<String, String>> itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Map<String, String> attrs = itr.next();
            Iterator<Map.Entry<String, String>> attrsKeysItr = attrs.entrySet().iterator();
            while (attrsKeysItr.hasNext()) {
                Map.Entry<String, String> entry = attrsKeysItr.next();
                String key = entry.getKey();
                String value = entry.getValue();
                buf.append(key);
                buf.append('=');
                buf.append(CompositeComponentModel.encode(value));
                if (!attrsKeysItr.hasNext()) continue;
                buf.append(',');
            }
            if (!itr.hasNext()) continue;
            buf.append(';');
        }
        document.addPair(INTERFACE_ATTRIBUTES_KEY, buf.toString(), false, true);
        document.addPair(HAS_IMPLEMENTATION_KEY, Boolean.toString(this.hasImplementation), false, true);
        Iterator<String> fitr = this.facetsDeclarations.iterator();
        StringBuilder sb = new StringBuilder();
        while (fitr.hasNext()) {
            sb.append(CompositeComponentModel.encode(fitr.next()));
            if (!fitr.hasNext()) continue;
            sb.append(',');
        }
        document.addPair(INTERFACE_FACETS, sb.toString(), false, true);
        StringBuilder dsb = new StringBuilder();
        dsb.append(CompositeComponentModel.encode(this.interfaceDisplayName != null ? this.interfaceDisplayName : NOT_AVAILABLE_VALUE));
        dsb.append(',');
        dsb.append(CompositeComponentModel.encode(this.interfaceShortDescription != null ? this.interfaceShortDescription : NOT_AVAILABLE_VALUE));
        document.addPair(INTERFACE_DESCRIPTION_KEY, dsb.toString(), false, true);
        return LibraryUtils.getCompositeLibraryURL((String)libraryName, (boolean)true);
    }

    private String getLibraryPath() {
        FileObject sourceFileFolder = this.sourceFile.getParent();
        FileObject resources = CompositeComponentModel.getResourcesDirectory(this.sourceFile);
        assert (resources != null);
        assert (!sourceFileFolder.equals(resources));
        return FileUtil.getRelativePath((FileObject)resources, (FileObject)sourceFileFolder);
    }

    static boolean isCompositeLibraryMember(FileObject file) {
        FileObject resourcesFolder = CompositeComponentModel.getResourcesDirectory(file);
        return resourcesFolder != null && FileUtil.isParentOf((FileObject)resourcesFolder, (FileObject)file) && !file.getParent().equals(resourcesFolder);
    }

    private static FileObject getResourcesDirectory(FileObject file) {
        FileObject docRoot;
        WebModule wm = WebModule.getWebModule((FileObject)file);
        if (wm != null && (docRoot = wm.getDocumentBase()) != null) {
            FileObject resourcesFolder;
            String relPath = RESOURCES_FOLDER_NAME;
            FileObject dd = wm.getDeploymentDescriptor();
            if (dd != null) {
                try {
                    WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
                    if (ddRoot != null) {
                        InitParam[] parameters;
                        for (InitParam param : parameters = ddRoot.getContextParam()) {
                            if (!param.getParamName().contains(WEBAPP_RESOURCES_DIRECTORY)) continue;
                            relPath = param.getParamValue().trim();
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage());
                }
            }
            if ((resourcesFolder = docRoot.getFileObject(relPath)) != null && FileUtil.isParentOf((FileObject)resourcesFolder, (FileObject)file)) {
                return resourcesFolder;
            }
        }
        FileObject folder = file;
        do {
            FileObject parent;
            if (!folder.getName().equalsIgnoreCase(RESOURCES_FOLDER_NAME) || (parent = folder.getParent()) == null || !parent.getNameExt().startsWith("META-INF")) continue;
            return folder;
        } while ((folder = folder.getParent()) != null);
        return null;
    }

    static String encode(String attributeValue) {
        StringBuilder out = new StringBuilder();
        block6: for (int i = 0; i < attributeValue.length(); ++i) {
            char c = attributeValue.charAt(i);
            switch (c) {
                case ',': {
                    out.append("\\c");
                    continue block6;
                }
                case '=': {
                    out.append("\\e");
                    continue block6;
                }
                case ';': {
                    out.append("\\m");
                    continue block6;
                }
                case '\\': {
                    out.append("\\s");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    static String decode(String attributeValue) {
        StringBuilder out = new StringBuilder();
        boolean encodeChar = false;
        for (int i = 0; i < attributeValue.length(); ++i) {
            char c = attributeValue.charAt(i);
            if (encodeChar) {
                switch (c) {
                    case 'c': {
                        out.append(',');
                        break;
                    }
                    case 'e': {
                        out.append('=');
                        break;
                    }
                    case 'm': {
                        out.append(';');
                        break;
                    }
                    case 's': {
                        out.append('\\');
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                encodeChar = false;
                continue;
            }
            if (c == '\\') {
                encodeChar = true;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static class Factory
    extends JsfPageModelFactory {
        private static final String COMPOSITE_ATTRIBUTE_TAG_NAME = "attribute";
        private static final String INTERFACE_TAG_NAME = "interface";
        private static final String IMPLEMENTATION_TAG_NAME = "implementation";
        private static final String FACET_TAG_NAME = "facet";

        @Override
        public JsfPageModel getModel(HtmlParserResult result) {
            Node node = result.root("http://xmlns.jcp.org/jsf/composite");
            if (node == null || node.children().isEmpty()) {
                node = result.root("http://java.sun.com/jsf/composite");
            }
            if (node == null) {
                return null;
            }
            FileObject file = result.getSnapshot().getSource().getFileObject();
            if (!CompositeComponentModel.isCompositeLibraryMember(file)) {
                return null;
            }
            final ArrayList<Map<String, String>> interfaceAttrs = new ArrayList<Map<String, String>>();
            final ArrayList<String> facetDeclarations = new ArrayList<String>();
            final boolean[] hasInterface = new boolean[1];
            final boolean[] hasImplementation = new boolean[1];
            final AtomicReference interfaceDisplayName = new AtomicReference();
            final AtomicReference interfaceShortDescrption = new AtomicReference();
            ElementUtils.visitChildren((Node)node, (ElementVisitor)new ElementVisitor(){
                private boolean inInterface = false;

                public void visit(Element node) {
                    switch (node.type()) {
                        case OPEN_TAG: {
                            String strVal;
                            Attribute facetName;
                            OpenTag openTag = (OpenTag)node;
                            if (LexerUtils.equals((CharSequence)Factory.INTERFACE_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)true, (boolean)true)) {
                                Attribute shortDescription;
                                this.inInterface = true;
                                Attribute displayName = openTag.getAttribute("displayName");
                                if (displayName != null) {
                                    interfaceDisplayName.set(displayName.unquotedValue().toString());
                                }
                                if ((shortDescription = openTag.getAttribute("shortDescription")) != null) {
                                    interfaceShortDescrption.set(shortDescription.unquotedValue().toString());
                                }
                                hasInterface[0] = true;
                                for (Element child : openTag.children(ElementType.OPEN_TAG)) {
                                    OpenTag openTagInner = (OpenTag)child;
                                    if (!LexerUtils.equals((CharSequence)Factory.COMPOSITE_ATTRIBUTE_TAG_NAME, (CharSequence)openTagInner.unqualifiedName(), (boolean)true, (boolean)true)) continue;
                                    HashMap<String, String> attrs = new HashMap<String, String>();
                                    for (Attribute attr : openTagInner.attributes()) {
                                        String value = attr.unquotedValue() == null ? null : attr.unquotedValue().toString();
                                        attrs.put(attr.unqualifiedName().toString(), value);
                                    }
                                    interfaceAttrs.add(attrs);
                                }
                                break;
                            }
                            if (LexerUtils.equals((CharSequence)Factory.IMPLEMENTATION_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)true, (boolean)true)) {
                                hasImplementation[0] = true;
                                break;
                            }
                            if (!LexerUtils.equals((CharSequence)Factory.FACET_TAG_NAME, (CharSequence)openTag.unqualifiedName(), (boolean)true, (boolean)true) || !this.inInterface || (facetName = openTag.getAttribute("name")) == null) break;
                            CharSequence value = facetName.unquotedValue();
                            String string = strVal = value == null ? null : value.toString().trim();
                            if (strVal == null || strVal.length() <= 0) break;
                            facetDeclarations.add(strVal);
                            break;
                        }
                        case CLOSE_TAG: {
                            CloseTag ct = (CloseTag)node;
                            if (!LexerUtils.equals((CharSequence)Factory.INTERFACE_TAG_NAME, (CharSequence)ct.unqualifiedName(), (boolean)true, (boolean)true)) break;
                            this.inInterface = false;
                            break;
                        }
                    }
                }
            });
            return new CompositeComponentModel(file, interfaceAttrs, hasImplementation[0], facetDeclarations, (String)interfaceDisplayName.get(), (String)interfaceShortDescrption.get());
        }

        @Override
        public JsfPageModel loadFromIndex(IndexResult result) {
            String attrs = result.getValue(CompositeComponentModel.INTERFACE_ATTRIBUTES_KEY);
            boolean hasImplementation = Boolean.parseBoolean(result.getValue(CompositeComponentModel.HAS_IMPLEMENTATION_KEY));
            ArrayList<Map<String, String>> parsedAttrs = new ArrayList<Map<String, String>>();
            ArrayList<String> facetDeclarations = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(attrs, Character.valueOf(';').toString());
            while (st.hasMoreTokens()) {
                String attrText = st.nextToken();
                HashMap<String, String> pairs = new HashMap<String, String>();
                StringTokenizer st2 = new StringTokenizer(attrText, Character.valueOf(',').toString());
                while (st2.hasMoreTokens()) {
                    String pair = st2.nextToken();
                    int key_value_separatorIndex = pair.indexOf(61);
                    if (key_value_separatorIndex == -1) {
                        LOGGER.log(Level.INFO, "Bad interface_attributes section in IndexResult: ", attrs);
                        continue;
                    }
                    String key = pair.substring(0, key_value_separatorIndex);
                    String value = CompositeComponentModel.decode(pair.substring(pair.indexOf(61) + 1));
                    pairs.put(key, value);
                }
                parsedAttrs.add(pairs);
            }
            String facets = result.getValue(CompositeComponentModel.INTERFACE_FACETS);
            StringTokenizer fst = new StringTokenizer(facets, Character.valueOf(',').toString());
            while (fst.hasMoreTokens()) {
                facetDeclarations.add(CompositeComponentModel.decode(fst.nextToken()));
            }
            String displayName = null;
            String shortDescription = null;
            String descr = result.getValue(CompositeComponentModel.INTERFACE_DESCRIPTION_KEY);
            int separatorIndex = descr.indexOf(44);
            if (separatorIndex >= 0) {
                displayName = descr.substring(0, separatorIndex);
                shortDescription = descr.substring(separatorIndex + 1);
            } else {
                LOGGER.log(Level.INFO, "Bad interface_description section in IndexResult: ", descr);
            }
            return new CompositeComponentModel(result.getFile(), result.getRelativePath(), parsedAttrs, hasImplementation, facetDeclarations, displayName, shortDescription);
        }
    }
}

