/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hyperlinks;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.hyperlinks.Bundle;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class HyperlinkProviderImpl
implements HyperlinkProviderExt {
    private static final Logger LOG = Logger.getLogger(HyperlinkProviderImpl.class.getName());

    public boolean isHyperlinkPoint(final Document doc, final int offset, HyperlinkType type) {
        final boolean[] isText = new boolean[1];
        final int[] ftokenOff = new int[1];
        final String[] ftext = new String[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                isText[0] = false;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence xml = th.tokenSequence(XMLTokenId.language());
                xml.move(offset);
                xml.moveNext();
                Token token = xml.token();
                if (token == null) {
                    return;
                }
                if (token.id() == XMLTokenId.TEXT) {
                    isText[0] = true;
                    ftokenOff[0] = xml.offset();
                    ftext[0] = token.text().toString();
                }
            }
        });
        if (isText[0]) {
            int ff;
            FileObject fo = this.getProjectDir(doc);
            String text = ftext[0];
            int tokenOff = ftokenOff[0];
            if (fo != null && this.getPath(fo, text) != null) {
                return true;
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                return true;
            }
            if (text != null && (ff = offset - tokenOff) > -1 && ff < text.length()) {
                String before = text.substring(0, ff);
                String after = text.substring(ff, text.length());
                int bo = before.lastIndexOf("${");
                int bc = before.lastIndexOf("}");
                int ao = after.indexOf("${");
                int ac = after.indexOf("}");
                if (bo > bc && ac > -1 && (ac < ao || ao == -1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int[] getHyperlinkSpan(final Document doc, final int offset, HyperlinkType type) {
        final boolean[] isText = new boolean[1];
        final int[] ftokenOff = new int[1];
        final String[] ftext = new String[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                isText[0] = false;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence xml = th.tokenSequence(XMLTokenId.language());
                xml.move(offset);
                xml.moveNext();
                Token token = xml.token();
                if (token == null) {
                    return;
                }
                if (token.id() == XMLTokenId.TEXT) {
                    isText[0] = true;
                    ftokenOff[0] = xml.offset();
                    ftext[0] = token.text().toString();
                }
            }
        });
        if (isText[0]) {
            Tuple prop;
            FileObject fo = this.getProjectDir(doc);
            int tokenOff = ftokenOff[0];
            String text = ftext[0];
            if (fo != null && this.getPath(fo, text) != null) {
                return new int[]{tokenOff, tokenOff + text.length()};
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                return new int[]{tokenOff, tokenOff + text.length()};
            }
            if (text != null && (prop = this.findProperty(text, tokenOff, offset)) != null) {
                return new int[]{prop.spanStart, prop.spanEnd};
            }
        }
        return null;
    }

    public void performClickAction(final Document doc, final int offset, HyperlinkType type) {
        final boolean[] isText = new boolean[1];
        final int[] ftokenOff = new int[1];
        final String[] ftext = new String[1];
        final FileObject fo = this.getProjectDir(doc);
        doc.render(new Runnable(){

            @Override
            public void run() {
                isText[0] = false;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence xml = th.tokenSequence(XMLTokenId.language());
                xml.move(offset);
                xml.moveNext();
                Token token = xml.token();
                if (token == null) {
                    return;
                }
                if (token.id() == XMLTokenId.TEXT) {
                    isText[0] = true;
                    ftokenOff[0] = xml.offset();
                    ftext[0] = token.text().toString();
                    if (fo != null && HyperlinkProviderImpl.this.getPath(fo, ftext[0]) != null) {
                        xml.movePrevious();
                        token = xml.token();
                        if (token != null && ((XMLTokenId)token.id()).equals((Object)XMLTokenId.TAG) && TokenUtilities.equals((CharSequence)token.text(), (Object)">")) {
                            xml.movePrevious();
                            token = xml.token();
                            if (token != null && ((XMLTokenId)token.id()).equals((Object)XMLTokenId.TAG) && TokenUtilities.equals((CharSequence)token.text(), (Object)"<module") && !ftext[0].endsWith("/pom.xml")) {
                                ftext[0] = ftext[0] + "/pom.xml";
                            }
                        }
                    }
                }
            }
        });
        if (isText[0]) {
            Tuple tup;
            int tokenOff = ftokenOff[0];
            String text = ftext[0];
            if (fo != null && this.getPath(fo, text) != null) {
                FileObject file = this.getPath(fo, text);
                NodeUtils.openPomFile((FileObject)file);
            }
            if (text != null && (text.startsWith("http://") || text.startsWith("https://"))) {
                try {
                    Project nbprj;
                    String urlText = text;
                    if (urlText.contains("${") && (nbprj = this.getProject(doc)) != null) {
                        try {
                            Object exRes = PluginPropertyUtils.createEvaluator((Project)nbprj).evaluate(urlText);
                            if (exRes != null) {
                                urlText = exRes.toString();
                            }
                        }
                        catch (ExpressionEvaluationException ex) {
                            LOG.log(Level.FINE, "Expression evaluation failed", ex);
                        }
                    }
                    URL url = new URL(urlText);
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.FINE, "malformed url for hyperlink", ex);
                }
            } else if (text != null && (tup = this.findProperty(text, tokenOff, offset)) != null) {
                String prop = tup.value.substring("${".length(), tup.value.length() - 1);
                NbMavenProject nbprj = this.getNbMavenProject(doc);
                if (nbprj != null) {
                    InputLocation location;
                    InputLocation propLoc;
                    if (prop != null && (prop.startsWith("project.") || prop.startsWith("pom."))) {
                        String val = prop.substring(prop.indexOf(46) + 1, prop.length());
                        InputLocation iloc = nbprj.getMavenProject().getModel().getLocation((Object)val);
                        if (iloc != null) {
                            ModelUtils.openAtSource((InputLocation)iloc);
                            return;
                        }
                    }
                    if ((propLoc = nbprj.getMavenProject().getModel().getLocation((Object)"properties")) != null && (location = propLoc.getLocation((Object)prop)) != null) {
                        ModelUtils.openAtSource((InputLocation)location);
                    }
                }
            }
        }
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return Collections.singleton(HyperlinkType.GO_TO_DECLARATION);
    }

    public String getTooltipText(final Document doc, final int offset, HyperlinkType type) {
        int tokenOff;
        String text;
        Tuple tup;
        final boolean[] isText = new boolean[1];
        final int[] ftokenOff = new int[1];
        final String[] ftext = new String[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                isText[0] = false;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence xml = th.tokenSequence(XMLTokenId.language());
                xml.move(offset);
                xml.moveNext();
                Token token = xml.token();
                if (token == null) {
                    return;
                }
                if (token.id() == XMLTokenId.TEXT) {
                    isText[0] = true;
                    ftokenOff[0] = xml.offset();
                    ftext[0] = token.text().toString();
                }
            }
        });
        if (isText[0] && (tup = this.findProperty(text = ftext[0], tokenOff = ftokenOff[0], offset)) != null) {
            String prop = tup.value.substring("${".length(), tup.value.length() - 1);
            try {
                Object exRes;
                Project nbprj = this.getProject(doc);
                if (nbprj != null && (exRes = PluginPropertyUtils.createEvaluator((Project)nbprj).evaluate(tup.value)) != null) {
                    return Bundle.Hint_prop_resolution(prop, exRes);
                }
            }
            catch (ExpressionEvaluationException ex) {
                return Bundle.Hint_prop_cannot();
            }
        }
        return null;
    }

    public static void openAtSource(InputLocation location) {
        FileObject fobj;
        InputSource source = location.getSource();
        if (source != null && source.getLocation() != null && (fobj = FileUtilities.convertStringToFileObject((String)source.getLocation())) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile((FileObject)fobj));
                EditCookie edit = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                if (edit != null) {
                    edit.edit();
                }
                LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                lc.getLineSet().getOriginal(location.getLineNumber() - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, location.getColumnNumber() - 1);
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.FINE, "dataobject not found", ex);
            }
        }
    }

    private Tuple findProperty(String textToken, int tokenOffset, int currentOffset) {
        if (textToken == null) {
            return null;
        }
        int ff = currentOffset - tokenOffset;
        if (ff > -1 && ff < textToken.length()) {
            String before = textToken.substring(0, ff);
            String after = textToken.substring(ff, textToken.length());
            int bo = before.lastIndexOf("${");
            int bc = before.lastIndexOf("}");
            int ao = after.indexOf("${");
            int ac = after.indexOf("}");
            if (bo > bc && ac > -1 && (ac < ao || ao == -1)) {
                return new Tuple(textToken.substring(bo, before.length() + ac + 1), tokenOffset + bo, tokenOffset + ff + ac + 1);
            }
            if (before.length() == 0 && ao == 0 && ac > 0) {
                return new Tuple(textToken.substring(0, ac + 1), tokenOffset, tokenOffset + ac + 1);
            }
        }
        return null;
    }

    private FileObject getProjectDir(Document doc) {
        DataObject dObject = NbEditorUtilities.getDataObject((Document)doc);
        if (dObject != null) {
            return dObject.getPrimaryFile().getParent();
        }
        return null;
    }

    private NbMavenProject getNbMavenProject(Document doc) {
        Project prj = this.getProject(doc);
        if (prj != null) {
            return (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        }
        return null;
    }

    private Project getProject(Document doc) {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (dobj != null) {
            return FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile());
        }
        return null;
    }

    private FileObject getPath(FileObject parent, String path) {
        if (path.startsWith("${basedir}/")) {
            path = path.substring("${basedir}/".length());
        }
        while (path.startsWith("../") && parent.getParent() != null) {
            path = path.substring("../".length());
            parent = parent.getParent();
        }
        return parent.getFileObject(path);
    }

    private static class Tuple {
        final int spanStart;
        final int spanEnd;
        final String value;

        public Tuple(String val, int start, int end) {
            this.value = val;
            this.spanStart = start;
            this.spanEnd = end;
        }
    }
}

