/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;

class SQLType {
    private int sqlType;
    private String stringValue;
    private Class[] typeList;
    private boolean supportsFinder;
    private static final SQLType UNKNOWN = new SQLType(1111, "UNKNOWN", new Class[0], false);
    private static SoftReference typeCache = new SoftReference<Object>(null);

    private SQLType(int type, String value, Class[] tList, boolean supportsFinder) {
        this.sqlType = type;
        this.stringValue = value;
        this.typeList = tList;
        this.supportsFinder = supportsFinder;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        return ((SQLType)other).sqlType == this.sqlType;
    }

    public int hashCode() {
        return this.sqlType;
    }

    public String toString() {
        return this.stringValue;
    }

    public int sqlType() {
        return this.sqlType;
    }

    String getMemberType(ColumnElement element) {
        String memberType = Serializable.class.getName();
        Class memberTypeClass = null;
        if (element.isCharacterType()) {
            memberTypeClass = this.getClassForCharType(element.getLength(), element.isNullable());
        } else if (element.isNumericType()) {
            memberTypeClass = this.getClassForNumericType(element.getPrecision(), element.getScale(), element.isNullable());
        }
        if (memberTypeClass != null) {
            return memberTypeClass.getName();
        }
        if (this.typeList.length > 0) {
            memberType = this.typeList[0].getName();
        }
        if (memberType.equals("[B")) {
            memberType = "byte []";
        }
        return memberType;
    }

    public String getFirstNonPrimitiveType() {
        String typeName = null;
        for (Class clazz : this.typeList) {
            if (clazz.isPrimitive()) continue;
            typeName = clazz.getName();
            break;
        }
        if ("[B".equals(typeName)) {
            typeName = "byte []";
        }
        return typeName;
    }

    private Class getClassForCharType(Integer length, boolean isNullable) {
        switch (this.sqlType) {
            case 1: {
                if (length == null || length != 1) break;
                return this.typeList[1];
            }
        }
        return null;
    }

    private Class getClassForNumericType(Integer precision, Integer scale, boolean isNullable) {
        int precValue = precision == null ? -1 : precision;
        int scaleValue = scale == null ? -1 : scale;
        switch (this.sqlType) {
            case 2: 
            case 3: {
                if (precValue <= 0 && scaleValue <= 0) {
                    return BigInteger.class;
                }
                if (scaleValue > 0) {
                    return BigDecimal.class;
                }
                if (precValue > 18) {
                    return BigInteger.class;
                }
                if (precValue > 9) {
                    return isNullable ? Long.class : Long.TYPE;
                }
                if (precValue > 4) {
                    return isNullable ? Integer.class : Integer.TYPE;
                }
                return isNullable ? Short.class : Short.TYPE;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.typeList[isNullable ? 0 : 1];
            }
        }
        return null;
    }

    public boolean supportsFinder() {
        return this.supportsFinder;
    }

    public static SQLType getSQLType(int sqlType) {
        List types = SQLType.getSQLTypes();
        int ind = types.indexOf(new SQLType(sqlType, null, null, false));
        return ind == -1 ? UNKNOWN : (SQLType)types.get(ind);
    }

    private static List getSQLTypes() {
        List types = (List)typeCache.get();
        if (types == null) {
            types = SQLType.getAllSQLTypes();
            typeCache = new SoftReference<List>(types);
        }
        return types;
    }

    private static List getAllSQLTypes() {
        return Arrays.asList(new SQLType(2003, "ARRAY", new Class[0], false), new SQLType(-5, "BIGINT", new Class[]{BigInteger.class, Long.TYPE}, true), new SQLType(3, "DECIMAL", new Class[]{BigDecimal.class, BigInteger.class, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE}, true), new SQLType(2, "NUMERIC", new Class[]{BigDecimal.class, BigInteger.class, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE}, true), new SQLType(2004, "BLOB", new Class[0], false), new SQLType(1, "CHAR", new Class[]{String.class, Character.class, Character.TYPE}, true), new SQLType(-15, "NCHAR", new Class[]{String.class, Character.class, Character.TYPE}, true), new SQLType(-1, "LONGVARCHAR", new Class[]{String.class}, true), new SQLType(-16, "LONGNVARCHAR", new Class[]{String.class}, true), new SQLType(12, "VARCHAR", new Class[]{String.class}, true), new SQLType(-9, "NVARCHAR", new Class[]{String.class}, true), new SQLType(2005, "CLOB", new Class[]{String.class}, false), new SQLType(2011, "NCLOB", new Class[]{String.class}, false), new SQLType(91, "DATE", new Class[]{Date.class}, false), new SQLType(6, "FLOAT", new Class[]{Double.class, Double.TYPE}, true), new SQLType(8, "DOUBLE", new Class[]{Double.class, Double.TYPE}, true), new SQLType(7, "REAL", new Class[]{Float.class, Float.TYPE}, true), new SQLType(4, "INTEGER", new Class[]{Integer.class, Integer.TYPE}, true), new SQLType(2000, "JAVA_OBJECT", new Class[0], false), new SQLType(0, "NULL", new Class[0], false), new SQLType(1111, "OTHER", new Class[]{Object.class}, true), new SQLType(2002, "STRUCT", new Class[0], false), new SQLType(2001, "DISTINCT", new Class[0], false), new SQLType(-2, "BINARY", new Class[]{byte[].class}, false), new SQLType(-7, "BIT", new Class[]{Boolean.class, Boolean.TYPE}, true), new SQLType(16, "BOOLEAN", new Class[]{Boolean.class, Boolean.TYPE}, true), new SQLType(-3, "VARBINARY", new Class[]{byte[].class}, false), new SQLType(-4, "LONGVARBINARY", new Class[]{byte[].class}, false), new SQLType(2006, "REF", new Class[0], false), new SQLType(5, "SMALLINT", new Class[]{Short.class, Short.TYPE}, true), new SQLType(-6, "TINYINT", new Class[]{Short.class, Short.TYPE}, true), new SQLType(92, "TIME", new Class[]{Time.class}, false), new SQLType(93, "TIMESTAMP", new Class[]{Timestamp.class}, false));
    }
}

