/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;

public class CsmCodeTemplateFilter
implements CodeTemplateFilter {
    private static boolean enabled = true;
    private final int startOffset;
    private final int endOffset;
    private final TokenId id;
    private final boolean statementsSelection;

    static void enableAbbreviations(boolean enabled) {
        CsmCodeTemplateFilter.enabled = enabled;
    }

    private CsmCodeTemplateFilter(JTextComponent component, int offset) {
        this.startOffset = offset;
        this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : this.startOffset;
        this.id = this.getID(component, offset);
        this.statementsSelection = this.isStatementSelection(component, offset);
    }

    public synchronized boolean accept(CodeTemplate template) {
        return enabled && (this.startOffset == this.endOffset || this.statementsSelection) && this.isTemplateContext(template);
    }

    private TokenId getID(final JTextComponent component, final int offset) {
        Document doc = component.getDocument();
        final AtomicReference<CppTokenId> out = new AtomicReference<CppTokenId>(CppTokenId.ERROR);
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)offset, (boolean)true, (boolean)false);
                if (ts != null) {
                    if (ts.offset() <= offset && !ts.movePrevious()) {
                        return;
                    }
                    out.set(ts.token().id());
                }
            }
        });
        return (TokenId)out.get();
    }

    private boolean isStatementSelection(JTextComponent component, int offset) {
        final Document doc = component.getDocument();
        final AtomicBoolean applicableSelection = new AtomicBoolean(false);
        if (this.startOffset < this.endOffset) {
            doc.render(new Runnable(){

                @Override
                public void run() {
                    Token token;
                    TokenHierarchy hi = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = hi.tokenSequence();
                    ts.move(CsmCodeTemplateFilter.this.endOffset);
                    boolean res = false;
                    if (ts.moveNext()) {
                        token = ts.token();
                        int from = ts.offset();
                        if (CsmCodeTemplateFilter.this.endOffset == from && "whitespace".equals(token.id().primaryCategory())) {
                            res = true;
                        }
                    }
                    if (!res) {
                        return;
                    }
                    res = false;
                    while (ts.movePrevious()) {
                        token = ts.token();
                        if ("whitespace".equals(token.id().primaryCategory()) || "comment".equals(token.id().primaryCategory())) continue;
                        res = token.id() == CppTokenId.RBRACE || token.id() == CppTokenId.SEMICOLON;
                        break;
                    }
                    if (!res) {
                        return;
                    }
                    ts.move(CsmCodeTemplateFilter.this.startOffset);
                    res = false;
                    if (ts.movePrevious()) {
                        token = ts.token();
                        int to = ts.offset() + token.length();
                        if (CsmCodeTemplateFilter.this.startOffset == to && "whitespace".equals(token.id().primaryCategory())) {
                            res = true;
                        }
                    }
                    if (!res) {
                        return;
                    }
                    res = false;
                    while (ts.movePrevious()) {
                        token = ts.token();
                        if ("whitespace".equals(token.id().primaryCategory()) || "comment".equals(token.id().primaryCategory())) continue;
                        res = token.id() == CppTokenId.LBRACE || token.id() == CppTokenId.RBRACE || token.id() == CppTokenId.SEMICOLON;
                        break;
                    }
                    if (!res) {
                        return;
                    }
                    ts.move(CsmCodeTemplateFilter.this.startOffset);
                    int count = 0;
                    while (ts.moveNext()) {
                        Token token2 = ts.token();
                        if (ts.offset() >= CsmCodeTemplateFilter.this.endOffset) break;
                        if (token2.id() == CppTokenId.LBRACE) {
                            ++count;
                        }
                        if (token2.id() != CppTokenId.RBRACE) continue;
                        --count;
                    }
                    if (count != 0) {
                        return;
                    }
                    applicableSelection.set(true);
                }
            });
        }
        return applicableSelection.get();
    }

    private boolean isTemplateContext(CodeTemplate template) {
        boolean res = true;
        if (this.id instanceof CppTokenId) {
            switch ((CppTokenId)this.id) {
                case DOT: 
                case DOTMBR: 
                case SCOPE: 
                case ARROW: 
                case ARROWMBR: {
                    res = false;
                }
            }
        }
        return res;
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new CsmCodeTemplateFilter(component, offset);
        }
    }
}

