/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class ProjectClassPathImplementation
implements ClassPathImplementation {
    private static final Logger LOGGER = Logger.getLogger(ProjectClassPathImplementation.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ProjectConfigListener projectConfigListener = new ProjectConfigListener();
    private final BuildConfigListener buildConfigListener = new BuildConfigListener();
    private final GrailsProjectConfig projectConfig;
    private final File projectRoot;
    private List<PathResourceImplementation> resources;
    private GrailsPlatform.Version version;
    private File pluginsDir;
    private File globalPluginsDir;
    private PluginsLibListener listenerPluginsLib;

    private ProjectClassPathImplementation(GrailsProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
        this.projectRoot = FileUtil.toFile((FileObject)projectConfig.getProject().getProjectDirectory());
        this.version = projectConfig.getGrailsPlatform().getVersion();
    }

    public static ProjectClassPathImplementation forProject(Project project) {
        GrailsProjectConfig config = GrailsProjectConfig.forProject((Project)project);
        ProjectClassPathImplementation impl = new ProjectClassPathImplementation(config);
        BuildConfig build = ((GrailsProject)config.getProject()).getBuildConfig();
        build.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)impl.buildConfigListener, (Object)build));
        config.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)impl.projectConfigListener, (Object)config));
        return impl;
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    private List<PathResourceImplementation> getPath() {
        String value;
        File gwtDir;
        assert (Thread.holdsLock(this));
        BuildConfig buildConfig = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig();
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        this.addLibs(this.projectRoot, result);
        List<File> compileDeps = buildConfig.getCompileDependencies();
        ProjectClassPathImplementation.addJars(compileDeps.toArray(new File[compileDeps.size()]), result, false);
        GrailsPluginSupport pluginSupport = GrailsPluginSupport.forProject(this.projectConfig.getProject());
        if (pluginSupport != null && pluginSupport.usesPlugin("gwt") && (gwtDir = new File(new File(this.projectRoot, SourceCategory.LIB.getRelativePath()), "gwt")).exists() && gwtDir.isDirectory()) {
            ProjectClassPathImplementation.addJars(gwtDir, result, false);
        }
        if (pluginSupport != null && pluginSupport.usesPlugin("app-engine") && (value = System.getenv("APPENGINE_HOME")) != null) {
            File appEngineLib = new File(new File(value), "lib");
            File lib = new File(appEngineLib, "shared");
            if (lib.exists() && lib.isDirectory()) {
                ProjectClassPathImplementation.addJars(lib, result, true);
            }
            if ((lib = new File(appEngineLib, "user")).exists() && lib.isDirectory()) {
                ProjectClassPathImplementation.addJars(lib, result, true);
            }
        }
        List<GrailsPlugin> localPlugins = buildConfig.getLocalPlugins();
        for (GrailsPlugin plugin : localPlugins) {
            if (plugin.getPath() == null) continue;
            this.addLibs(plugin.getPath(), result);
        }
        File oldPluginsDir = this.pluginsDir;
        File currentPluginsDir = buildConfig.getProjectPluginsDir();
        if (this.pluginsDir == null || !this.pluginsDir.equals(currentPluginsDir)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, currentPluginsDir});
            this.pluginsDir = currentPluginsDir;
        }
        if (pluginSupport != null && this.pluginsDir.isDirectory()) {
            this.addPlugins(this.pluginsDir, result, pluginSupport.getProjectPluginFilter());
        }
        File oldGlobalPluginsDir = this.globalPluginsDir;
        File currentGlobalPluginsDir = buildConfig.getGlobalPluginsDir();
        if (this.globalPluginsDir == null || !this.globalPluginsDir.equals(currentGlobalPluginsDir)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, currentPluginsDir});
            this.globalPluginsDir = currentGlobalPluginsDir;
        }
        if (this.globalPluginsDir != null && this.globalPluginsDir.isDirectory()) {
            this.addPlugins(this.globalPluginsDir, result, null);
        }
        ProjectClassPathImplementation.addJars(buildConfig.getIvyCacheDir(), result, true);
        if (this.listenerPluginsLib == null) {
            File libDir = FileUtil.normalizeFile((File)new File(this.projectRoot, "lib"));
            this.listenerPluginsLib = new PluginsLibListener(this);
            FileUtil.addFileChangeListener((FileChangeListener)this.listenerPluginsLib, (File)libDir);
        }
        this.updateListener(this.listenerPluginsLib, oldPluginsDir, currentPluginsDir);
        this.updateListener(this.listenerPluginsLib, oldGlobalPluginsDir, currentGlobalPluginsDir);
        return Collections.unmodifiableList(result);
    }

    private void updateListener(FileChangeListener listener, File oldDir, File newDir) {
        if (oldDir == null || !oldDir.equals(newDir)) {
            if (oldDir != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)oldDir);
            }
            if (newDir != null) {
                FileUtil.addFileChangeListener((FileChangeListener)listener, (File)newDir);
            }
        }
    }

    private void addPlugins(File dir, List<PathResourceImplementation> result, GrailsPluginSupport.FolderFilter filter) {
        for (String name : dir.list()) {
            File file = new File(dir, name);
            if (!file.isDirectory() || filter != null && !filter.accept(name)) continue;
            this.addLibs(file, result);
        }
    }

    private void addLibs(File root, List<PathResourceImplementation> result) {
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        File libDir = new File(root, SourceCategory.LIB.getRelativePath());
        if (!libDir.exists() || !libDir.isDirectory()) {
            return;
        }
        ProjectClassPathImplementation.addJars(libDir, result, false);
    }

    private static void addJars(File dir, List<PathResourceImplementation> result, boolean recurse) {
        ProjectClassPathImplementation.addJars(dir.listFiles(), result, recurse);
    }

    private static void addJars(File[] jars, List<PathResourceImplementation> result, boolean recurse) {
        if (jars != null) {
            for (File f : jars) {
                try {
                    if (f.isFile()) {
                        URL entry = Utilities.toURI((File)f).normalize().toURL();
                        if (!FileUtil.isArchiveFile((URL)entry)) continue;
                        entry = FileUtil.getArchiveRoot((URL)entry);
                        result.add(ClassPathSupport.createResource((URL)entry));
                        continue;
                    }
                    if (!recurse || !f.isDirectory()) continue;
                    ProjectClassPathImplementation.addJars(f, result, recurse);
                }
                catch (MalformedURLException mue) {
                    assert (false) : mue;
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private static class PluginsLibListener
    implements FileChangeListener {
        private final ProjectClassPathImplementation impl;

        public PluginsLibListener(ProjectClassPathImplementation impl) {
            this.impl = impl;
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ProjectClassPathImplementation projectClassPathImplementation = this.impl;
            synchronized (projectClassPathImplementation) {
                this.impl.resources = null;
            }
            this.impl.support.firePropertyChange("resources", null, null);
        }
    }

    private class BuildConfigListener
    implements PropertyChangeListener {
        private BuildConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (BuildConfig.BUILD_CONFIG_PLUGINS.equals(evt.getPropertyName())) {
                LOGGER.log(Level.INFO, "Project classpath changed due to change in {0}", evt.getPropertyName());
                ProjectClassPathImplementation projectClassPathImplementation = ProjectClassPathImplementation.this;
                synchronized (projectClassPathImplementation) {
                    ProjectClassPathImplementation.this.resources = null;
                }
                ProjectClassPathImplementation.this.support.firePropertyChange("resources", null, null);
            }
        }
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("grails.platform".equals(evt.getPropertyName())) {
                GrailsPlatform platform = ((GrailsProjectConfig)evt.getSource()).getGrailsPlatform();
                GrailsPlatform.Version currentVersion = platform.getVersion();
                if (GrailsPlatform.Version.VERSION_1_1.compareTo(currentVersion) <= 0 && GrailsPlatform.Version.VERSION_1_1.compareTo(ProjectClassPathImplementation.this.version) > 0 || GrailsPlatform.Version.VERSION_1_1.compareTo(currentVersion) > 0 && GrailsPlatform.Version.VERSION_1_1.compareTo(ProjectClassPathImplementation.this.version) <= 0) {
                    LOGGER.log(Level.INFO, "Project classpath changed due to change in {0}", evt.getPropertyName());
                    ProjectClassPathImplementation projectClassPathImplementation = ProjectClassPathImplementation.this;
                    synchronized (projectClassPathImplementation) {
                        ProjectClassPathImplementation.this.resources = null;
                    }
                    ProjectClassPathImplementation.this.support.firePropertyChange("resources", null, null);
                }
                ProjectClassPathImplementation.this.version = currentVersion;
            }
        }
    }
}

