/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.ios.IOSDevice;
import org.netbeans.modules.cordova.platforms.ios.IOSProvisioningProfile;
import org.netbeans.modules.cordova.platforms.ios.IOSSDK;
import org.netbeans.modules.cordova.platforms.ios.WebInspectorJNIBinding;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.ProvisioningProfile;
import org.netbeans.modules.cordova.platforms.spi.SDK;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class IOSPlatform
implements MobilePlatform {
    private static String IOS_SIGN_IDENTITY_PREF = "ios.sign.identity";
    private static String IOS_PROVISIONING_PROFILE_PREF = "ios.provisioning.profile";
    public static final int DEFAULT_TIMEOUT = 30000;
    private boolean isReady = false;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String sdkLocation;
    private SDK DEFAULT = new IOSSDK("Simulator - iOS 6.0", "iphonesimulator6.0");

    public String getType() {
        return "ios";
    }

    public Collection<SDK> getSDKs() {
        try {
            String listSdks = ProcessUtilities.callProcess((String)"xcodebuild", (boolean)true, (int)60000, (String[])new String[]{"-showsdks"});
            return IOSSDK.parse(listSdks);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public synchronized boolean isReady() {
        if (!this.isReady) {
            try {
                String path = ProcessUtilities.callProcess((String)"xcode-select", (boolean)true, (int)30000, (String[])new String[]{"--print-path"});
                if (!"/Applications/Xcode.app/Contents/Developer".equals(path.trim())) {
                    return false;
                }
                File f = new File("/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneSimulator.platform");
                if (!f.exists()) {
                    return false;
                }
                String version = ProcessUtilities.callProcess((String)"xcodebuild", (boolean)true, (int)30000, (String[])new String[]{"-version"});
                String[] lines = version.split(System.getProperty("line.separator"));
                if (lines.length < 1) {
                    return false;
                }
                if (!lines[0].startsWith("Xcode")) {
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
            this.isReady = true;
        }
        return this.isReady;
    }

    public String getSimulatorPath() {
        return InstalledFileLocator.getDefault().locate("bin/ios-sim", "org.netbeans.modules.cordova.platforms.ios", false).getPath();
    }

    public Collection<? extends Device> getConnectedDevices() throws IOException {
        WebInspectorJNIBinding inspector = WebInspectorJNIBinding.getDefault();
        if (inspector.isDeviceConnected()) {
            return Collections.singleton(IOSDevice.CONNECTED);
        }
        return Collections.emptyList();
    }

    public SDK getPrefferedTarget() {
        Collection<SDK> sDKs;
        String preffered = System.getProperty("ios.preffered.sdk");
        if (preffered != null) {
            return new IOSSDK(preffered, preffered);
        }
        if (Utilities.isMac() && !(sDKs = this.getSDKs()).isEmpty()) {
            return (SDK)sDKs.toArray()[sDKs.size() - 1];
        }
        return this.DEFAULT;
    }

    public String getSdkLocation() {
        return this.sdkLocation;
    }

    public void manageDevices() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setSdkLocation(String sdkLocation) {
    }

    public boolean waitEmulatorReady(int timeout) {
        return true;
    }

    public Device getDevice(String name, EditableProperties props) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"props", (Object)props);
        if ("device".equals(props.getProperty("device"))) {
            return IOSDevice.CONNECTED;
        }
        return IOSDevice.IPHONE;
    }

    public Collection<? extends Device> getVirtualDevices() throws IOException {
        return EnumSet.allOf(IOSDevice.class);
    }

    public String getCodeSignIdentity() {
        return NbPreferences.forModule(IOSPlatform.class).get(IOS_SIGN_IDENTITY_PREF, "iPhone Developer");
    }

    public String getProvisioningProfilePath() {
        File[] listFiles;
        String def = null;
        File f = new File(System.getProperty("user.home") + "/Library/MobileDevice/Provisioning Profiles/");
        if (f.exists() && f.isDirectory() && (listFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".mobileprovision");
            }
        })).length > 0) {
            def = listFiles[0].getAbsolutePath();
        }
        return NbPreferences.forModule(IOSPlatform.class).get(IOS_PROVISIONING_PROFILE_PREF, def);
    }

    public void setCodeSignIdentity(String identity) {
        NbPreferences.forModule(IOSPlatform.class).put(IOS_SIGN_IDENTITY_PREF, identity);
        this.propertyChangeSupport.firePropertyChange("SIGN_IDENTITY", null, identity);
    }

    public void setProvisioningProfilePath(String path) {
        NbPreferences.forModule(IOSPlatform.class).put(IOS_PROVISIONING_PROFILE_PREF, path);
        this.propertyChangeSupport.firePropertyChange("PROVISIONING_PROFILE", null, path);
    }

    public Collection<? extends ProvisioningProfile> getProvisioningProfiles() {
        ArrayList<IOSProvisioningProfile> result = new ArrayList<IOSProvisioningProfile>();
        File f = new File(System.getProperty("user.home") + "/Library/MobileDevice/Provisioning Profiles/");
        if (f.exists() && f.isDirectory()) {
            File[] listFiles;
            for (File prov : listFiles = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".mobileprovision");
                }
            })) {
                result.add(new IOSProvisioningProfile(prov.getAbsolutePath()));
            }
        }
        return result;
    }
}

