/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectChangeSupport;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.ConfigurationDescriptorProviderImpl;
import org.netbeans.modules.cnd.makeproject.api.TempEnv;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeLogicalViewModel;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.IncludePathExpansionProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.toolchain.support.ToolchainUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NativeProjectProvider
implements NativeProject,
PropertyChangeListener,
ChangeListener,
NativeProjectChangeSupport {
    private static final boolean TRACE = false;
    private final Project project;
    private final String projectRoot;
    private final FileSystem fileSystem;
    private final ConfigurationDescriptorProviderImpl projectDescriptorProvider;
    private final Set<NativeProjectItemsListener> listeners = new HashSet<NativeProjectItemsListener>();
    private static final RequestProcessor RPCC = new RequestProcessor("NativeProjectProvider.CheckConfiguration", 1);
    private NativeFileItem indexerC;
    private NativeFileItem indexerCpp;
    private Reference<List<NativeProject>> cachedDependency = new SoftReference<Object>(null);
    private final AtomicBoolean fileOperationsProgress = new AtomicBoolean(false);
    public static final SpiAccessor SPI_ACCESSOR = new SpiAccessor();

    public NativeProjectProvider(Project project, RemoteProject remoteProject, ConfigurationDescriptorProviderImpl projectDescriptorProvider) {
        assert (remoteProject != null);
        this.project = project;
        this.fileSystem = NativeProjectProvider.getFileSystem(remoteProject);
        this.projectRoot = NativeProjectProvider.getProjectRoot(remoteProject);
        this.projectDescriptorProvider = projectDescriptorProvider;
        ToolchainUtilities.addCodeAssistanceChangeListener((ChangeListener)this);
    }

    public void runOnProjectReadiness(NamedRunnable task) {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getConfs().runOnProjectReadiness(task);
        }
    }

    private void addMyListeners() {
        this.projectDescriptorProvider.getConfigurationDescriptorImpl().getConfs().addPropertyChangeListener(this);
    }

    private void removeMyListeners() {
        this.projectDescriptorProvider.getConfigurationDescriptorImpl().getConfs().removePropertyChangeListener(this);
    }

    public MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.projectDescriptorProvider.getConfigurationDescriptor();
    }

    public MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getActiveConfiguration();
        }
        return null;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private static FileSystem getFileSystem(RemoteProject remoteProject) {
        ExecutionEnvironment env = remoteProject.getSourceFileSystemHost();
        FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        CndUtils.assertNotNull((Object)fileSystem, (String)"null file system");
        return fileSystem;
    }

    public List<String> getSourceRoots() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getAbsoluteSourceRoots();
        }
        return Collections.emptyList();
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    private static String getProjectRoot(RemoteProject remoteProject) {
        String projectRoot = remoteProject.getSourceBaseDir();
        CndUtils.assertNotNull((Object)projectRoot, (String)"null projectRoot");
        return projectRoot;
    }

    public String getProjectDisplayName() {
        return ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public List<NativeFileItem> getAllFiles() {
        MakeConfiguration conf;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null && (conf = descriptor.getActiveConfiguration()) != null) {
            Item[] items;
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (Item item : items = descriptor.getProjectItems()) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null) continue;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    list.add(item);
                    continue;
                }
                if (!item.hasHeaderOrSourceExtension(true, true)) continue;
                list.add(item);
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NativeFileItem> getStandardHeadersIndexers() {
        MakeConfiguration conf;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null && (conf = descriptor.getActiveConfiguration()) != null) {
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            NativeProjectProvider nativeProjectProvider = this;
            synchronized (nativeProjectProvider) {
                if (this.indexerC == null) {
                    this.indexerC = this.createIndexer(descriptor, this, NativeFileItem.Language.C);
                }
                if (this.indexerC != null) {
                    list.add(this.indexerC);
                }
                if (this.indexerCpp == null) {
                    this.indexerCpp = this.createIndexer(descriptor, this, NativeFileItem.Language.CPP);
                }
                if (this.indexerCpp != null) {
                    list.add(this.indexerCpp);
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    private NativeFileItem createIndexer(MakeConfigurationDescriptor descriptor, NativeProjectProvider nativeProject, NativeFileItem.Language language) {
        FileObject projectDir = descriptor.getProject().getProjectDirectory();
        FileObject indexer = language == NativeFileItem.Language.C ? projectDir.getFileObject("nbproject/private/c_standard_headers_indexer.c") : projectDir.getFileObject("nbproject/private/cpp_standard_headers_indexer.cpp");
        if (indexer != null && indexer.isValid()) {
            return new NativeFileIndexer(nativeProject, indexer, language);
        }
        return null;
    }

    public List<NativeProject> getDependences() {
        List<Object> cachedList = this.cachedDependency.get();
        if (cachedList == null) {
            cachedList = new ArrayList<NativeProject>(0);
            MakeConfiguration makeConfiguration = this.getMakeConfiguration();
            int size = 0;
            NativeProject oneOf = null;
            if (makeConfiguration != null) {
                for (Project lib : makeConfiguration.getSubProjects()) {
                    Project prj = lib;
                    NativeProject nativeProject = (NativeProject)prj.getLookup().lookup(NativeProject.class);
                    if (nativeProject == null) continue;
                    cachedList.add(nativeProject);
                    ++size;
                    oneOf = nativeProject;
                }
            }
            cachedList = size == 0 ? Collections.emptyList() : (size == 1 ? Collections.singletonList(oneOf) : Collections.unmodifiableList(cachedList));
            this.cachedDependency = new SoftReference<List<NativeProject>>(cachedList);
        }
        return cachedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                this.addMyListeners();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.removeMyListeners();
            }
        }
    }

    public void fireFilesAdded(List<NativeFileItem> nativeFileIetms) {
        ArrayList<NativeFileItem> actualList = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileIetm : nativeFileIetms) {
            PredefinedToolKind tool;
            if (nativeFileIetm == null || (tool = ((Item)nativeFileIetm).getDefaultTool()) == PredefinedToolKind.CustomTool && !"text/x-h".equals(((Item)nativeFileIetm).getMIMEType())) continue;
            actualList.add(nativeFileIetm);
        }
        if (!actualList.isEmpty()) {
            this.getListenersCopy().forEach(listener -> listener.filesAdded((List)actualList));
        }
    }

    public void fireFilesRemoved(List<NativeFileItem> nativeFileItems) {
        if (!nativeFileItems.isEmpty()) {
            this.getListenersCopy().forEach(listener -> listener.filesRemoved(nativeFileItems));
        }
    }

    public void fireFileRenamed(String oldPath, NativeFileItem newNativeFileIetm) {
        this.getListenersCopy().forEach(listener -> listener.fileRenamed(oldPath, newNativeFileIetm));
    }

    public void fireFilesPropertiesChanged(List<NativeFileItem> fileItems) {
        this.getListenersCopy().forEach(listener -> listener.filesPropertiesChanged(fileItems));
    }

    public void fireFilesPropertiesChanged() {
        this.getListenersCopy().forEach(listener -> listener.filesPropertiesChanged((NativeProject)this));
    }

    public void fireFileOperationsStarted() {
        if (this.fileOperationsProgress.compareAndSet(false, true)) {
            this.getListenersCopy().forEach(listener -> listener.fileOperationsStarted((NativeProject)this));
        }
    }

    public void fireFileOperationsFinished() {
        if (this.fileOperationsProgress.compareAndSet(true, false)) {
            this.getListenersCopy().forEach(listener -> listener.fileOperationsFinished((NativeProject)this));
        }
    }

    public void fireProjectDeleted() {
        this.getListenersCopy().forEach(listener -> listener.projectDeleted((NativeProject)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NativeProjectItemsListener> getListenersCopy() {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<NativeProjectItemsListener>(this.listeners);
        }
    }

    public NativeFileItem findFileItem(FileObject fileObject) {
        MakeConfigurationDescriptor descr;
        if (this.projectDescriptorProvider.gotDescriptor() && (descr = this.getMakeConfigurationDescriptor()) != null) {
            return descr.findItemByFileObject(fileObject);
        }
        return null;
    }

    private void checkConfigurationChanged(Configuration oldConf, Configuration newConf) {
        if (SwingUtilities.isEventDispatchThread()) {
            RPCC.post(() -> this.checkConfigurationChangedWorker(oldConf, newConf));
        } else {
            this.checkConfigurationChangedWorker(oldConf, newConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigurationChangedWorker(Configuration oldConf, Configuration newConf) {
        MakeConfiguration oldMConf = (MakeConfiguration)oldConf;
        MakeConfiguration newMConf = (MakeConfiguration)newConf;
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> added = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> deleted = new ArrayList<NativeFileItem>();
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
        }
        if (newConf == null) {
            System.err.println("Nativeprojectprovider - checkConfigurationChanged - newConf is null!");
            return;
        }
        if (!newConf.isDefault()) {
            return;
        }
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        Item[] items = descriptor.getProjectItems();
        Project proj = descriptor.getProject();
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_CONFIG_CND", descriptor);
        if (oldConf == null) {
            this.firePropertiesChanged(items, true, true, true);
            MakeLogicalViewModel viewModel = (MakeLogicalViewModel)this.getProject().getLookup().lookup(MakeLogicalViewModel.class);
            if (viewModel != null) {
                viewModel.checkForChangedViewItemNodes(null, null);
                viewModel.checkForChangedName();
            }
            return;
        }
        boolean toolColectionChanged = false;
        if (!oldMConf.getCompilerSet().getName().equals(newMConf.getCompilerSet().getName()) || !oldMConf.getDevelopmentHost().getExecutionEnvironment().equals((Object)newMConf.getDevelopmentHost().getExecutionEnvironment())) {
            MakeLogicalViewModel viewModel = (MakeLogicalViewModel)this.getProject().getLookup().lookup(MakeLogicalViewModel.class);
            if (viewModel != null) {
                viewModel.checkForChangedViewItemNodes(null, null);
            }
            if (!oldMConf.getDevelopmentHost().getExecutionEnvironment().equals((Object)newMConf.getDevelopmentHost().getExecutionEnvironment()) && viewModel != null) {
                viewModel.checkForChangedName();
            }
            toolColectionChanged = true;
        }
        if (toolColectionChanged && newConf.getName().equals(oldConf.getName())) {
            this.fireFilesPropertiesChanged();
            return;
        }
        CompilerSet oldCompilerSet = oldMConf.getCompilerSet().getCompilerSet();
        CompilerSet newCompilerSet = newMConf.getCompilerSet().getCompilerSet();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration oldItemConf = items[i].getItemConfiguration(oldMConf);
            ItemConfiguration newItemConf = items[i].getItemConfiguration(newMConf);
            if (oldItemConf == null || newItemConf == null) continue;
            if (newItemConf.getExcluded().getValue() ^ oldItemConf.getExcluded().getValue() && (newItemConf.getTool() == PredefinedToolKind.CCompiler || newItemConf.getTool() == PredefinedToolKind.CCCompiler || items[i].hasHeaderOrSourceExtension(true, true))) {
                if (newItemConf.getExcluded().getValue()) {
                    deleted.add(items[i]);
                } else {
                    added.add(items[i]);
                }
                MakeLogicalViewModel viewModel = (MakeLogicalViewModel)this.getProject().getLookup().lookup(MakeLogicalViewModel.class);
                if (viewModel == null) continue;
                viewModel.checkForChangedViewItemNodes(null, items[i]);
                continue;
            }
            if (newItemConf.getTool() == PredefinedToolKind.CCompiler) {
                if (oldItemConf.getTool() != PredefinedToolKind.CCompiler) {
                    list.add(items[i]);
                    continue;
                }
                if (oldCompilerSet == null || newCompilerSet == null) {
                    if (oldCompilerSet == null && newCompilerSet == null) continue;
                    list.add(items[i]);
                    continue;
                }
                if (!oldItemConf.getCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                    list.add(items[i]);
                    continue;
                }
                if (oldItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) continue;
                list.add(items[i]);
                continue;
            }
            if (newItemConf.getTool() != PredefinedToolKind.CCCompiler) continue;
            if (oldItemConf.getTool() != PredefinedToolKind.CCCompiler) {
                list.add(items[i]);
                continue;
            }
            if (oldCompilerSet == null || newCompilerSet == null) {
                if (oldCompilerSet == null && newCompilerSet == null) continue;
                list.add(items[i]);
                continue;
            }
            if (!oldItemConf.getCCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                list.add(items[i]);
                continue;
            }
            if (oldItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) continue;
            list.add(items[i]);
        }
        this.fireFilesRemoved(deleted);
        this.fireFilesAdded(added);
        if (!list.isEmpty()) {
            this.fireFilesPropertiesChanged(list);
        }
        if (toolColectionChanged) {
            this.fireFilesPropertiesChanged();
        }
    }

    private void firePropertiesChanged(Item[] items, boolean cFiles, boolean ccFiles, boolean projectChanged) {
        MakeConfiguration conf = this.getMakeConfiguration();
        NativeProjectProvider.firePropertiesChanged(items, cFiles, ccFiles, projectChanged, conf, this);
    }

    public static void firePropertiesChanged(Item[] items, boolean cFiles, boolean ccFiles, boolean projectChanged, MakeConfiguration conf, NativeProjectChangeSupport nativeProjectChangeSupport) {
        if (nativeProjectChangeSupport == null) {
            return;
        }
        ArrayList<Item> list = new ArrayList<Item>();
        ArrayList<Item> deleted = new ArrayList<Item>();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
            if (itemConfiguration == null) continue;
            if (items[i].isExcluded()) {
                deleted.add(items[i]);
                continue;
            }
            if (!(cFiles && itemConfiguration.getTool() == PredefinedToolKind.CCompiler || ccFiles && itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) && !items[i].hasHeaderOrSourceExtension(cFiles, ccFiles)) continue;
            list.add(items[i]);
        }
        if (!deleted.isEmpty()) {
            nativeProjectChangeSupport.fireFilesRemoved(deleted);
        }
        if (projectChanged) {
            nativeProjectChangeSupport.fireFilesPropertiesChanged();
        } else if (!list.isEmpty()) {
            nativeProjectChangeSupport.fireFilesPropertiesChanged(list);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("activeConfiguration")) {
            this.checkConfigurationChanged((Configuration)evt.getOldValue(), (Configuration)evt.getNewValue());
        }
    }

    public List<IncludePath> getSystemIncludePaths() {
        return this.getSystemIncludePaths(NativeFileItem.Language.CPP);
    }

    public List<IncludePath> getSystemIncludePaths(NativeFileItem.Language language) {
        CCCCompilerConfiguration compilerConfiguration;
        AbstractCompiler compiler;
        ArrayList<IncludePath> vec = new ArrayList<IncludePath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration == null) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        if (language == NativeFileItem.Language.C) {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        } else {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        }
        if (compilerConfiguration != null && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(IncludePath.toIncludePathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(this.getImportantFlags(language))));
            } else {
                String importantFlags = SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(IncludePath.toIncludePathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(importantFlags)));
            }
        }
        return SPI_ACCESSOR.expandIncludePaths(vec, compilerConfiguration, compiler, makeConfiguration);
    }

    public List<FSPath> getSystemIncludeHeaders() {
        return this.getSystemIncludeHeaders(NativeFileItem.Language.CPP);
    }

    public List<FSPath> getSystemIncludeHeaders(NativeFileItem.Language language) {
        CCCCompilerConfiguration compilerConfiguration;
        AbstractCompiler compiler;
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration == null) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        if (language == NativeFileItem.Language.C) {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        } else {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        }
        if (compiler != null) {
            FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            vec.addAll(CndFileUtils.toFSPathList((FileSystem)compilerFS, (Collection)compiler.getSystemIncludeHeaders()));
        }
        if (compilerConfiguration != null && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeHeaders(this.getImportantFlags(language))));
            } else {
                String importantFlags = SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeHeaders(importantFlags)));
            }
        }
        return vec;
    }

    public List<IncludePath> getUserIncludePaths() {
        return this.getUserIncludePaths(NativeFileItem.Language.CPP);
    }

    public List<IncludePath> getUserIncludePaths(NativeFileItem.Language language) {
        CCCCompilerConfiguration compilerConfiguration;
        AbstractCompiler compiler;
        ArrayList<IncludePath> vec = new ArrayList<IncludePath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration == null) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        if (language == NativeFileItem.Language.C) {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        } else {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        }
        ArrayList<String> vec2 = new ArrayList<String>();
        vec2.addAll(compilerConfiguration.getIncludeDirectories().getValue());
        ExecutionEnvironment env = compiler.getExecutionEnvironment();
        MacroConverter macroConverter = null;
        FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        FileSystem projectFS = this.fileSystem;
        ArrayList<IncludePath> result = new ArrayList<IncludePath>();
        for (String p : vec2) {
            boolean compilerContext = false;
            if (p.contains("$")) {
                if (macroConverter == null) {
                    macroConverter = new MacroConverter(env);
                }
                p = macroConverter.expand(p);
                compilerContext = true;
            }
            if (p.startsWith("///")) {
                compilerContext = true;
            }
            if (compilerContext && CndPathUtilities.isPathAbsolute((FileSystem)compilerFS, (String)p)) {
                result.add(IncludePath.toIncludePath((FileSystem)compilerFS, (String)p));
                continue;
            }
            if (CndPathUtilities.isPathAbsolute((FileSystem)projectFS, (String)p)) {
                result.add(IncludePath.toIncludePath((FileSystem)projectFS, (String)p));
                continue;
            }
            String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.projectDescriptorProvider.getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
            result.add(IncludePath.toIncludePath((FileSystem)projectFS, (String)absPath));
        }
        List<IncludePath> vec3 = new ArrayList<IncludePath>();
        vec3 = SPI_ACCESSOR.getItemUserIncludePaths(vec3, compilerConfiguration, compiler, makeConfiguration);
        result.addAll(vec3);
        return SPI_ACCESSOR.expandIncludePaths(result, compilerConfiguration, compiler, makeConfiguration);
    }

    public List<FSPath> getIncludeFiles() {
        return this.getIncludeFiles(NativeFileItem.Language.CPP);
    }

    public List<FSPath> getIncludeFiles(NativeFileItem.Language language) {
        CCCCompilerConfiguration compilerConfiguration;
        AbstractCompiler compiler;
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration == null) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        if (language == NativeFileItem.Language.C) {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        } else {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        }
        ArrayList<String> vec2 = new ArrayList<String>();
        vec2.addAll(compilerConfiguration.getIncludeFiles().getValue());
        ExecutionEnvironment env = compiler.getExecutionEnvironment();
        FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        FileSystem projectFS = this.fileSystem;
        MacroConverter macroConverter = null;
        for (String p : vec2) {
            boolean compilerContext = false;
            if (p.contains("$")) {
                if (macroConverter == null) {
                    macroConverter = new MacroConverter(env);
                }
                p = macroConverter.expand(p);
                compilerContext = true;
            }
            if (p.startsWith("///")) {
                compilerContext = true;
            }
            if (compilerContext && CndPathUtilities.isPathAbsolute((FileSystem)compilerFS, (String)p)) {
                vec.add(new FSPath(compilerFS, p));
                continue;
            }
            if (CndPathUtilities.isPathAbsolute((FileSystem)projectFS, (String)p)) {
                vec.add(new FSPath(projectFS, p));
                continue;
            }
            String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.projectDescriptorProvider.getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
            vec.add(new FSPath(projectFS, absPath));
        }
        return vec;
    }

    public List<String> getSystemMacroDefinitions() {
        return this.getSystemMacroDefinitions(NativeFileItem.Language.CPP);
    }

    public List<String> getSystemMacroDefinitions(NativeFileItem.Language language) {
        List<String> undefinedMacros;
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCCompilerConfiguration compilerConfiguration;
            AbstractCompiler compiler;
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            if (language == NativeFileItem.Language.C) {
                compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
                compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
            } else {
                compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
                compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            }
            if (compiler != null) {
                if (makeConfiguration.isMakefileConfiguration()) {
                    vec.addAll(compiler.getSystemPreprocessorSymbols(this.getImportantFlags(language)));
                } else {
                    String importantFlags = SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                    vec.addAll(compiler.getSystemPreprocessorSymbols(importantFlags));
                }
            }
        }
        if ((undefinedMacros = this.getUndefinedMacros(language)).size() > 0) {
            ArrayList<String> out = new ArrayList<String>();
            for (String macro : vec) {
                boolean remove = true;
                for (String undef : undefinedMacros) {
                    if (!macro.equals(undef) && !macro.startsWith(undef + "=")) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                out.add(macro);
            }
            vec = out;
        }
        return vec;
    }

    private String getImportantFlags(NativeFileItem.Language language) {
        CCCCompilerConfiguration compilerConfiguration;
        AbstractCompiler compiler;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration == null) {
            return "";
        }
        CompilerSet2Configuration compilerSetConfiguration = makeConfiguration.getCompilerSet();
        if (compilerSetConfiguration == null) {
            return "";
        }
        CompilerSet compilerSet = compilerSetConfiguration.getCompilerSet();
        if (compilerSet == null) {
            return "";
        }
        if (language == NativeFileItem.Language.C) {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        } else {
            compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        }
        String res = "";
        if (makeConfiguration.isMakefileConfiguration()) {
            res = compilerConfiguration.getImportantFlags().getValue();
        } else if (compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0 && (res = SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration)) == null) {
            res = "";
        }
        if (res.isEmpty()) {
            NativeFileItem.LanguageFlavor languageFlavor = this.getLanguageFlavor(language);
            switch (languageFlavor) {
                case C11: {
                    res = "-std=c11";
                    break;
                }
                case CPP11: {
                    res = "-std=c++11";
                    break;
                }
                case CPP14: {
                    res = "-std=c++14";
                    break;
                }
            }
        }
        return res;
    }

    public List<String> getUserMacroDefinitions() {
        return this.getUserMacroDefinitions(NativeFileItem.Language.CPP);
    }

    public List<String> getUserMacroDefinitions(NativeFileItem.Language language) {
        List<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCCompilerConfiguration compilerConfiguration;
            AbstractCompiler compiler;
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            if (language == NativeFileItem.Language.C) {
                compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
                compilerConfiguration = makeConfiguration.getCCompilerConfiguration();
            } else {
                compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
                compilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            }
            vec.addAll(compilerConfiguration.getPreprocessorConfiguration().getValue());
            vec = SPI_ACCESSOR.getItemUserMacros(vec, compilerConfiguration, compiler, makeConfiguration);
        }
        return vec;
    }

    private List<String> getUndefinedMacros(NativeFileItem.Language language) {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCCompilerConfiguration compilerConfiguration = language == NativeFileItem.Language.C ? makeConfiguration.getCCompilerConfiguration() : makeConfiguration.getCCCompilerConfiguration();
            vec.addAll(compilerConfiguration.getUndefinedPreprocessorConfiguration().getValue());
        }
        return vec;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor(NativeFileItem.Language language) {
        MakeConfiguration conf;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null && (conf = descriptor.getActiveConfiguration()) != null) {
            if (language == NativeFileItem.Language.C) {
                CCompilerConfiguration cCompilerConfiguration = conf.getCCompilerConfiguration();
                if (cCompilerConfiguration != null) {
                    switch (cCompilerConfiguration.getCStandard().getValue()) {
                        case 1: {
                            return NativeFileItem.LanguageFlavor.C89;
                        }
                        case 2: {
                            return NativeFileItem.LanguageFlavor.C99;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.C11;
                        }
                    }
                    return NativeFileItem.LanguageFlavor.DEFAULT;
                }
            } else {
                CCCompilerConfiguration ccCompilerConfiguration = conf.getCCCompilerConfiguration();
                if (ccCompilerConfiguration != null) {
                    switch (ccCompilerConfiguration.getCppStandard().getValue()) {
                        case 1: {
                            return NativeFileItem.LanguageFlavor.CPP;
                        }
                        case 2: {
                            return NativeFileItem.LanguageFlavor.CPP11;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.CPP14;
                        }
                    }
                    return NativeFileItem.LanguageFlavor.DEFAULT;
                }
            }
        }
        return NativeFileItem.LanguageFlavor.DEFAULT;
    }

    public String toString() {
        return this.getProjectDisplayName() + " " + this.getProjectRoot();
    }

    private void clearCache() {
        this.cachedDependency.clear();
    }

    NativeProjectSupport.NativeExitStatus execute(String executable, String[] env, String ... args) throws IOException {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ExecutionEnvironment ev = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        return NativeProjectProvider.execute(ev, executable, env, args);
    }

    static NativeProjectSupport.NativeExitStatus execute(ExecutionEnvironment ee, String executable, String[] env, String ... args) throws IOException {
        ServerRecord record = ServerList.get((ExecutionEnvironment)ee);
        if (!record.isOnline()) {
            return new NativeProjectSupport.NativeExitStatus(-1, "", NativeProjectProvider.getString("HOST_OFFLINE", ee.getHost()));
        }
        try {
            if (ee.isLocal()) {
                String exePath = Path.findCommand((String)executable);
                if (exePath == null) {
                    throw new IOException(NativeProjectProvider.getString("NOT_FOUND", executable));
                }
                executable = exePath;
            }
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ee);
            npb.setExecutable(executable);
            npb.setArguments(args);
            if (env != null) {
                for (String envEntry : env) {
                    String[] varValuePair = envEntry.split("=");
                    npb.getEnvironment().put(varValuePair[0], varValuePair[1]);
                }
            }
            ProcessUtils.ExitStatus exitStatus = ProcessUtils.execute((NativeProcessBuilder)npb);
            return new NativeProjectSupport.NativeExitStatus(exitStatus.exitCode, exitStatus.getOutputString(), exitStatus.getErrorString());
        }
        catch (Exception e) {
            return new NativeProjectSupport.NativeExitStatus(-1, "", e.getMessage());
        }
    }

    String getPlatformName() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        String platformName = makeConfiguration.getDevelopmentHost().getBuildPlatformName();
        return platformName;
    }

    private static String getString(String s, String s2) {
        return NbBundle.getMessage(NativeProjectProvider.class, (String)s, (Object)s2);
    }

    NativeFileSearch getNativeFileSearch() {
        return (NativeFileSearch)Lookup.getDefault().lookup(NativeFileSearch.class);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireFilesPropertiesChanged();
    }

    private static class NativeFileIndexer
    implements NativeFileItem {
        private final FileObject indexer;
        private final NativeFileItem.Language language;
        private final NativeProjectProvider nativeProject;
        private final String normalizedAbsPath;

        public NativeFileIndexer(NativeProjectProvider nativeProject, FileObject indexer, NativeFileItem.Language language) {
            this.nativeProject = nativeProject;
            this.indexer = indexer;
            this.language = language;
            this.normalizedAbsPath = CndFileUtils.normalizePath((FileObject)indexer);
        }

        public NativeProject getNativeProject() {
            return this.nativeProject;
        }

        public String getAbsolutePath() {
            return this.normalizedAbsPath;
        }

        public String getName() {
            return this.indexer.getNameExt();
        }

        public FileObject getFileObject() {
            return this.indexer;
        }

        public List<IncludePath> getSystemIncludePaths() {
            return this.nativeProject.getSystemIncludePaths(this.language);
        }

        public List<IncludePath> getUserIncludePaths() {
            return this.nativeProject.getUserIncludePaths(this.language);
        }

        public List<FSPath> getSystemIncludeHeaders() {
            return this.nativeProject.getSystemIncludeHeaders(this.language);
        }

        public List<FSPath> getIncludeFiles() {
            return this.nativeProject.getIncludeFiles(this.language);
        }

        public List<String> getSystemMacroDefinitions() {
            return this.nativeProject.getSystemMacroDefinitions(this.language);
        }

        public List<String> getUserMacroDefinitions() {
            return this.nativeProject.getUserMacroDefinitions(this.language);
        }

        public NativeFileItem.Language getLanguage() {
            return this.language;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return this.nativeProject.getLanguageFlavor(this.language);
        }

        public boolean isExcluded() {
            return false;
        }
    }

    public static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables = new HashMap<String, String>();

        public MacroConverter(ExecutionEnvironment env) {
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            TempEnv.getInstance(env).addTemporaryEnv(this.envVariables);
            this.expander = this.envVariables == null ? null : MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        public String expand(String in) {
            try {
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return in;
            }
        }
    }

    public static final class SpiAccessor {
        private Collection<? extends UserOptionsProvider> uoProviders;
        private Collection<? extends IncludePathExpansionProvider> ipeProviders;

        private synchronized Collection<? extends UserOptionsProvider> getUserOptionsProviders() {
            if (this.uoProviders == null) {
                this.uoProviders = Lookup.getDefault().lookupAll(UserOptionsProvider.class);
            }
            return this.uoProviders;
        }

        private synchronized Collection<? extends IncludePathExpansionProvider> getIncludePathExpansionProviders() {
            if (this.ipeProviders == null) {
                this.ipeProviders = Lookup.getDefault().lookupAll(IncludePathExpansionProvider.class);
            }
            return this.ipeProviders;
        }

        private SpiAccessor() {
        }

        public List<IncludePath> getItemUserIncludePaths(List<IncludePath> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                ArrayList<IncludePath> res = new ArrayList<IncludePath>(includes);
                this.getUserOptionsProviders().forEach(provider -> res.addAll(provider.getItemUserIncludePaths(includes, compilerOptions, compiler, makeConfiguration)));
                return res;
            }
            return includes;
        }

        public List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                ArrayList<String> res = new ArrayList<String>(macros);
                this.getUserOptionsProviders().forEach(provider -> res.addAll(provider.getItemUserMacros(macros, compilerOptions, compiler, makeConfiguration)));
                return res;
            }
            return macros;
        }

        public String getImportantFlags(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    String itemImportantFlags = userOptionsProvider.getItemImportantFlags(compilerOptions, compiler, makeConfiguration);
                    if (itemImportantFlags == null) continue;
                    return itemImportantFlags;
                }
            }
            return null;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (!this.getUserOptionsProviders().isEmpty()) {
                for (UserOptionsProvider userOptionsProvider : this.getUserOptionsProviders()) {
                    NativeFileItem.LanguageFlavor languageFlavor = userOptionsProvider.getLanguageFlavor(compilerOptions, compiler, makeConfiguration);
                    if (languageFlavor == null || languageFlavor == NativeFileItem.LanguageFlavor.UNKNOWN) continue;
                    return languageFlavor;
                }
                return NativeFileItem.LanguageFlavor.UNKNOWN;
            }
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public List<IncludePath> expandIncludePaths(List<IncludePath> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            for (IncludePathExpansionProvider includePathExpansionProvider : this.getIncludePathExpansionProviders()) {
                includes = includePathExpansionProvider.expandIncludePaths(includes, compilerOptions, compiler, makeConfiguration);
            }
            return includes;
        }
    }
}

