/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class SvnMetadataFolderLoader
extends DataLoader {
    public SvnMetadataFolderLoader() {
        super(DataFolder.class.getName());
    }

    protected DataObject handleFindDataObject(FileObject fo, DataLoader.RecognizedFiles recognized) throws IOException {
        if (!fo.isFolder() || !fo.getName().endsWith("svn")) {
            return null;
        }
        VCSFileProxy f = VCSFileProxy.createFileProxy((FileObject)fo);
        if (f == null) {
            return null;
        }
        if (SvnUtils.isPartOfSubversionMetadata(f)) {
            IOException e = new IOException("Do not create DO for .svn metadata: " + f);
            Exceptions.attachSeverity((Throwable)e, (Level)Level.FINE);
            throw e;
        }
        return null;
    }
}

