/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.diff;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.diff.DiffAction;
import org.netbeans.modules.subversion.remote.ui.diff.DiffTopComponent;
import org.netbeans.modules.subversion.remote.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.remote.ui.diff.SelectDiffTree;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DiffToAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_DiffTo";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes) && SvnUtils.getActionRoots(this.getCachedContext(nodes), false) != null;
    }

    @Override
    protected int getFileEnabledStatus() {
        return this.getDirectoryEnabledStatus();
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        SvnProgressSupport supp = new SvnProgressSupport(ctx.getFileSystem()){

            @Override
            protected void perform() {
                if (this.isCanceled()) {
                    return;
                }
                if (!Subversion.getInstance().checkClientAvailable(ctx)) {
                    Logger.getLogger(DiffToAction.class.getName()).log(Level.FINE, "Client is unavailable, cannot perform Diff To");
                    return;
                }
                final String contextName = DiffToAction.this.getContextDisplayName(nodes);
                SVNUrl repositoryUrl = null;
                SVNUrl fileUrl = null;
                VCSFileProxy[] roots = SvnUtils.getActionRoots(ctx, false);
                VCSFileProxy interestingFile = null;
                if (roots != null) {
                    try {
                        interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
                        repositoryUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
                        fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
                    }
                    catch (SVNClientException ex) {
                        Logger.getLogger(DiffToAction.class.getName()).log(Level.INFO, null, ex);
                    }
                }
                if (repositoryUrl == null || fileUrl == null) {
                    Logger.getLogger(DiffToAction.class.getName()).log(Level.FINE, "No repository URL: {0} or file URL: {1} for roots: {2}", new Object[]{repositoryUrl, fileUrl, Arrays.asList(roots)});
                }
                final SelectDiffTree panel = new SelectDiffTree(new RepositoryFile(ctx.getFileSystem(), repositoryUrl, fileUrl, SVNRevision.HEAD), interestingFile);
                final SVNUrl fRepositoryUrl = repositoryUrl;
                final SVNUrl fFileUrl = fileUrl;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!panel.showDialog()) {
                            return;
                        }
                        RepositoryFile left = panel.getRepositoryFile();
                        MultiDiffPanel panel2 = new MultiDiffPanel(ctx, -1, contextName, false, fRepositoryUrl, fFileUrl, left, new RepositoryFile(ctx.getFileSystem(), fRepositoryUrl, fFileUrl, SVNRevision.WORKING));
                        DiffTopComponent tc = new DiffTopComponent(panel2);
                        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
                        tc.open();
                        tc.requestActive();
                    }
                });
            }
        };
        supp.start(Subversion.getInstance().getRequestProcessor(), null, ActionUtils.cutAmpersand(this.getRunningName(nodes)));
    }
}

