/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.config.SvnConfigFiles;
import org.netbeans.modules.subversion.remote.ui.repository.HttpPanel;
import org.netbeans.modules.subversion.remote.ui.repository.Repository;
import org.netbeans.modules.subversion.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.remote.ui.repository.SvnSSHCliPanel;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public abstract class ConnectionType
implements ActionListener,
DocumentListener,
FocusListener {
    private static final String LOCAL_URL_HELP = "file:///repository_path[@REV]";
    private static final String HTTP_URL_HELP = "http://hostname/repository_path[@REV]";
    private static final String HTTPS_URL_HELP = "https://hostname/repository_path[@REV]";
    private static final String SVN_URL_HELP = "svn://hostname/repository_path[@REV]";
    private static final String SVN_SSH_URL_HELP = "svn+{0}://hostname/repository_path[@REV]";
    protected final Repository repository;
    private List<JTextField> selectOnFocusFields = null;
    protected final FileSystem fileSystem;

    public ConnectionType(FileSystem fileSystem, Repository repository) {
        this.repository = repository;
        this.fileSystem = fileSystem;
    }

    abstract String getTip(String var1);

    abstract JPanel getPanel();

    abstract void setEditable(boolean var1);

    protected void refresh(RepositoryConnection rc) {
    }

    protected void setEnabled(boolean enabled) {
    }

    protected void textChanged(Document d) {
    }

    protected void storeConfigValues() {
    }

    protected void onSelectedRepositoryChange(String urlString) {
    }

    protected void showHints(boolean b) {
    }

    protected void fillRC(RepositoryConnection editedrc) {
    }

    protected void updateVisibility(String selectedUrlString) {
    }

    boolean savePassword() {
        return true;
    }

    boolean isValid(RepositoryConnection rc) {
        return true;
    }

    protected void addSelectOnFocusFields(JTextField ... txts) {
        if (this.selectOnFocusFields == null) {
            this.selectOnFocusFields = new ArrayList<JTextField>();
        }
        this.selectOnFocusFields.addAll(Arrays.asList(txts));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    private void textChanged(final DocumentEvent e) {
        Runnable awt = new Runnable(){

            @Override
            public void run() {
                ConnectionType.this.textChanged(e.getDocument());
                ConnectionType.this.repository.validateSvnUrl();
            }
        };
        SwingUtilities.invokeLater(awt);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.selectOnFocusFields == null) {
            return;
        }
        for (JTextField txt : this.selectOnFocusFields) {
            if (focusEvent.getSource() != txt) continue;
            txt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    protected void onBrowse(JTextField txt) {
        VCSFileProxy oldFile = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)txt.getText()).normalizeFile();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(Repository.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.showDialog(this.getPanel(), NbBundle.getMessage(Repository.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            txt.setText(f.getPath());
        }
    }

    static class SvnSSHCli
    extends ConnectionType {
        private final SvnSSHCliPanel panel = new SvnSSHCliPanel();

        public SvnSSHCli(FileSystem fileSystem, Repository repository) {
            super(fileSystem, repository);
            this.panel.tunnelCommandTextField.getDocument().addDocumentListener(this);
        }

        @Override
        JPanel getPanel() {
            return this.panel;
        }

        @Override
        protected void refresh(RepositoryConnection rc) {
            this.panel.tunnelCommandTextField.setText(rc.getExternalCommand());
        }

        @Override
        void setEditable(boolean editable) {
            this.panel.tunnelCommandTextField.setEditable(editable);
        }

        @Override
        protected void showHints(boolean b) {
            this.panel.tunnelHelpLabel.setVisible(b);
        }

        @Override
        protected void textChanged(Document d) {
            if (d == this.panel.tunnelCommandTextField.getDocument()) {
                this.onTunnelCommandChange(this.repository.getSelectedRCIntern());
            }
        }

        private void onTunnelCommandChange(RepositoryConnection rc) {
            if (rc != null) {
                rc.setExternalCommand(this.panel.tunnelCommandTextField.getText());
            }
        }

        @Override
        protected void storeConfigValues() {
            RepositoryConnection rc = this.repository.getSelectedRCIntern();
            if (rc == null) {
                return;
            }
            try {
                SVNUrl repositoryUrl = rc.getSvnUrl();
                if (repositoryUrl.getProtocol().startsWith("svn+")) {
                    SvnConfigFiles.getInstance(this.fileSystem).setExternalCommand(SvnUtils.getTunnelName(repositoryUrl.getProtocol()), this.panel.tunnelCommandTextField.getText());
                }
            }
            catch (MalformedURLException mue) {
                Subversion.LOG.log(Level.INFO, null, mue);
            }
        }

        @Override
        protected boolean savePassword() {
            return true;
        }

        @Override
        protected boolean isValid(RepositoryConnection rc) {
            return !rc.getUrl().startsWith("svn+") || !this.panel.tunnelCommandTextField.getText().trim().equals("");
        }

        @Override
        public void onSelectedRepositoryChange(String urlString) {
            if (urlString.startsWith("svn+")) {
                String tunnelName = SvnUtils.getTunnelName(urlString).trim();
                if (this.panel.tunnelCommandTextField.getText().trim().equals("") && !tunnelName.isEmpty()) {
                    this.panel.tunnelCommandTextField.setText(SvnConfigFiles.getInstance(this.fileSystem).getExternalCommand(tunnelName));
                }
            }
        }

        @Override
        protected void fillRC(RepositoryConnection editedrc) {
            editedrc.setExternalCommand(this.panel.tunnelCommandTextField.getText());
        }

        @Override
        String getTip(String url) {
            String tunnelName = SvnUtils.getTunnelName(url);
            return MessageFormat.format(ConnectionType.SVN_SSH_URL_HELP, tunnelName).trim();
        }
    }

    static class Http
    extends ConnectionType {
        private final HttpPanel panel = new HttpPanel();

        public Http(FileSystem fileSystem, Repository repository) {
            super(fileSystem, repository);
            this.panel.proxySettingsButton.addActionListener(this);
            this.panel.savePasswordCheckBox.addActionListener(this);
            this.addSelectOnFocusFields(this.panel.userPasswordField);
            this.panel.browseButton.addActionListener(this);
            this.panel.userPasswordField.getDocument().addDocumentListener(this);
            this.panel.certPasswordField.getDocument().addDocumentListener(this);
            this.panel.userPasswordField.addFocusListener(this);
            this.panel.certPasswordField.addFocusListener(this);
            this.panel.userTextField.getDocument().addDocumentListener(this);
            this.panel.certFileTextField.getDocument().addDocumentListener(this);
            this.panel.proxySettingsButton.setVisible(repository.isSet(64));
        }

        @Override
        JPanel getPanel() {
            return this.panel;
        }

        @Override
        protected void refresh(RepositoryConnection rc) {
            this.panel.userTextField.setText(rc.getUsername());
            this.panel.userPasswordField.setText(rc.getPassword() == null ? "" : new String(rc.getPassword()));
            this.panel.savePasswordCheckBox.setSelected(rc.getSavePassword());
            this.panel.certFileTextField.setText(rc.getCertFile());
            this.panel.certPasswordField.setText(rc.getCertPassword() == null ? "" : new String(rc.getCertPassword()));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.panel.proxySettingsButton.setEnabled(enabled);
            this.panel.userPasswordField.setEnabled(enabled);
            this.panel.userTextField.setEnabled(enabled);
            this.panel.savePasswordCheckBox.setEnabled(enabled);
            this.panel.certFileTextField.setEnabled(enabled);
            this.panel.certPasswordField.setEnabled(enabled);
            this.panel.browseButton.setEnabled(enabled);
        }

        @Override
        public void setEditable(boolean editable) {
            this.panel.userPasswordField.setEditable(editable);
            this.panel.userTextField.setEditable(editable);
            this.panel.proxySettingsButton.setEnabled(editable);
            this.panel.savePasswordCheckBox.setEnabled(editable);
            this.panel.certFileTextField.setEnabled(editable);
            this.panel.certPasswordField.setEnabled(editable);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.panel.proxySettingsButton) {
                this.onProxyConfiguration();
            } else if (e.getSource() == this.panel.savePasswordCheckBox) {
                this.onSavePasswordChange();
            } else if (e.getSource() == this.panel.browseButton) {
                this.onBrowse(this.panel.certFileTextField);
            } else {
                super.actionPerformed(e);
            }
        }

        private void onProxyConfiguration() {
            OptionsDisplayer.getDefault().open("General");
        }

        private void onSavePasswordChange() {
            Runnable awt = new Runnable(){

                @Override
                public void run() {
                    RepositoryConnection rc = Http.this.repository.getSelectedRCIntern();
                    if (rc != null) {
                        rc.setSavePassword(((Http)Http.this).panel.savePasswordCheckBox.isSelected());
                    }
                    Http.this.repository.validateSvnUrl();
                }
            };
            SwingUtilities.invokeLater(awt);
        }

        @Override
        protected void storeConfigValues() {
        }

        @Override
        protected boolean savePassword() {
            return this.panel.savePasswordCheckBox.isSelected();
        }

        @Override
        public void onSelectedRepositoryChange(String urlString) {
        }

        @Override
        protected void textChanged(Document d) {
            if (d == this.panel.userTextField.getDocument()) {
                this.onUsernameChange(this.repository.getSelectedRCIntern());
            } else if (d == this.panel.userPasswordField.getDocument()) {
                this.onPasswordChange(this.repository.getSelectedRCIntern());
            } else if (d == this.panel.certFileTextField.getDocument()) {
                this.onCertFileChange(this.repository.getSelectedRCIntern());
            } else if (d == this.panel.certPasswordField.getDocument()) {
                this.onCertPasswordChange(this.repository.getSelectedRCIntern());
            }
        }

        private void onUsernameChange(RepositoryConnection rc) {
            if (rc != null) {
                rc.setUsername(this.panel.userTextField.getText());
            }
            this.repository.setValid(true, "");
        }

        private void onPasswordChange(RepositoryConnection rc) {
            if (rc != null) {
                rc.setPassword(this.panel.userPasswordField.getPassword());
            }
            this.repository.setValid(true, "");
        }

        private void onCertPasswordChange(RepositoryConnection rc) {
            if (rc != null) {
                rc.setCertPassword(this.panel.certPasswordField.getPassword());
            }
        }

        private void onCertFileChange(RepositoryConnection rc) {
            if (rc != null) {
                rc.setCertFile(this.panel.certFileTextField.getText());
            }
        }

        @Override
        protected void fillRC(RepositoryConnection editedrc) {
            editedrc.setUsername(this.panel.userTextField.getText());
            editedrc.setPassword(this.panel.userPasswordField.getPassword());
            editedrc.setSavePassword(this.panel.savePasswordCheckBox.isSelected());
            editedrc.setCertFile(this.panel.certFileTextField.getText());
            editedrc.setCertPassword(this.panel.certPasswordField.getPassword());
        }

        @Override
        String getTip(String url) {
            if (url.startsWith("http:")) {
                return ConnectionType.HTTP_URL_HELP;
            }
            if (url.startsWith("https:")) {
                return ConnectionType.HTTPS_URL_HELP;
            }
            if (url.startsWith("svn:")) {
                return ConnectionType.SVN_URL_HELP;
            }
            return null;
        }

        @Override
        protected void updateVisibility(String url) {
            this.panel.sslPanel.setVisible(url.startsWith("https:"));
        }
    }

    static class InvalidUrl
    extends FileUrl {
        public InvalidUrl(FileSystem fileSystem, Repository repository) {
            super(fileSystem, repository);
        }

        @Override
        String getTip(String url) {
            return NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{ConnectionType.LOCAL_URL_HELP, ConnectionType.HTTP_URL_HELP, ConnectionType.HTTPS_URL_HELP, ConnectionType.SVN_URL_HELP, ConnectionType.SVN_SSH_URL_HELP});
        }
    }

    static class FileUrl
    extends ConnectionType {
        private final JPanel panel = new JPanel();

        public FileUrl(FileSystem fileSystem, Repository repository) {
            super(fileSystem, repository);
        }

        @Override
        JPanel getPanel() {
            return this.panel;
        }

        @Override
        String getTip(String url) {
            return ConnectionType.LOCAL_URL_HELP;
        }

        @Override
        void setEditable(boolean editable) {
        }
    }
}

