/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.status;

import java.util.HashMap;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.ISVNDirEntryWithLock;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNLock;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;

public class StatusAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/remote/resources/icons/show_changes.png";
    private static final int enabledForStatus = -2;

    public StatusAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ShowChanges";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -2;
    }

    @Override
    public void performContextAction(Node[] nodes) {
        Context ctx = SvnUtils.getCurrentContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
        stc.setContentTitle(this.getContextDisplayName(nodes));
        stc.setContext(ctx);
        stc.open();
        stc.requestActive();
        stc.performRefreshAction();
    }

    public static void executeStatus(Context context, SVNUrl repository, SvnProgressSupport support, boolean contactServer) {
        if (context == null || context.getRoots().isEmpty()) {
            return;
        }
        try {
            SvnClient client;
            try {
                client = repository == null ? Subversion.getInstance().getClient(context, support) : Subversion.getInstance().getClient(context, repository, support);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, true, true);
                return;
            }
            Subversion.getInstance().getStatusCache().refreshCached(context);
            VCSFileProxy[] roots = context.getRootFiles();
            for (int i = 0; i < roots.length; ++i) {
                StatusAction.executeStatus(roots[i], client, support, contactServer);
                if (!support.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException ex) {
            if (!support.isCanceled()) {
                support.annotate(ex);
            }
            Subversion.LOG.log(Level.INFO, "Action canceled", ex);
        }
    }

    public static void executeStatus(VCSFileProxy root, SvnClient client, SvnProgressSupport support, boolean contactServer) throws SVNClientException {
        ISVNStatus[] statuses;
        HashMap<VCSFileProxy, ISVNLock> locks;
        block12: {
            if (support != null && support.isCanceled()) {
                return;
            }
            locks = new HashMap<VCSFileProxy, ISVNLock>();
            try {
                statuses = client.getStatus(root, true, false, contactServer);
                if (!contactServer || !SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)root)).isGetRemoteLocks()) break block12;
                try {
                    ISVNDirEntryWithLock[] entries;
                    ISVNInfo info = client.getInfoFromWorkingCopy(root);
                    if (info != null && info.getUrl() != null && !info.isCopied() && (entries = client.getListWithLocks(info.getUrl(), info.getRevision(), info.getRevision(), true)) != null) {
                        for (ISVNDirEntryWithLock entry : entries) {
                            if (entry.getLock() == null) continue;
                            locks.put(root.isFile() ? root : VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)entry.getDirEntry().getPath()), entry.getLock());
                        }
                    }
                }
                catch (SVNClientException ex) {
                    Subversion.LOG.log(SvnClientExceptionHandler.isNotUnderVersionControl(ex.getMessage()) || SvnClientExceptionHandler.isWrongUrl(ex.getMessage()) ? Level.FINE : Level.INFO, null, ex);
                }
            }
            catch (SVNClientException ex) {
                if (contactServer && SvnClientExceptionHandler.isNotUnderVersionControl(ex.getMessage())) {
                    Subversion.LOG.log(Level.INFO, "StatusAction.executeStatus: file under {0} not under version control, trying offline", root.getPath());
                    statuses = client.getStatus(root, true, false, false);
                }
                throw ex;
            }
        }
        if (support != null && support.isCanceled()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int s = 0; s < statuses.length; ++s) {
            if (support != null && support.isCanceled()) {
                return;
            }
            ISVNStatus status = statuses[s];
            VCSFileProxy file = status.getFile();
            if (file.isDirectory() && status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                cache.refreshRecursively(file);
                continue;
            }
            cache.refresh(file, new FileStatusCache.RepositoryStatus(status, (ISVNLock)locks.get(file)));
        }
    }
}

