/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import org.netbeans.api.xml.parsers.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SAXEntityParser
implements XMLReader {
    private static final long RANDOM = System.currentTimeMillis();
    private static final String FAKE_SYSTEM_ID = "NetBeans:Fake-System-ID-" + RANDOM;
    private static final String FAKE_PUBLIC_ID = "-//NetBeans//Fake Public ID " + RANDOM + "//EN";
    private final XMLReader peer;
    private final boolean generalEntity;
    private boolean used = false;

    public SAXEntityParser(XMLReader peer) {
        this(peer, true);
    }

    public SAXEntityParser(XMLReader peer, boolean generalEntity) {
        if (peer == null) {
            throw new NullPointerException();
        }
        this.peer = peer;
        this.generalEntity = generalEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource entity) throws IOException, SAXException {
        InputSource fakeInput;
        if (entity == null) {
            throw new NullPointerException();
        }
        SAXEntityParser sAXEntityParser = this;
        synchronized (sAXEntityParser) {
            this.checkUsed();
            this.used = true;
        }
        String originalSID = entity.getSystemId();
        if (originalSID == null && Util.THIS.isLoggable(Level.WARNING)) {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            new IllegalArgumentException("WARNING: Missing system ID may cause serious errors while resolving relative references!").printStackTrace(out);
            out.flush();
            Util.THIS.debug(Level.WARNING, writer.getBuffer().toString());
        }
        EntityResolver resolver = this.peer.getEntityResolver();
        this.peer.setEntityResolver(new ER(resolver, entity));
        ErrorHandler errorHandler = this.peer.getErrorHandler();
        if (errorHandler != null) {
            this.peer.setErrorHandler(new EH(errorHandler));
        }
        if ((fakeInput = this.wrapInputSource(entity)).getSystemId() == null) {
            fakeInput.setSystemId(originalSID);
        }
        if (fakeInput.getPublicId() == null) {
            fakeInput.setPublicId(FAKE_PUBLIC_ID);
        }
        this.peer.parse(fakeInput);
    }

    protected InputSource wrapInputSource(InputSource input) {
        String fakeDocument;
        String sid = input.getSystemId();
        InputSource fakeInput = new InputSource(FAKE_SYSTEM_ID);
        if (this.generalEntity) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<!DOCTYPE fakeDocument" + RANDOM + " [\n");
            String entityRef = " PUBLIC '" + FAKE_PUBLIC_ID + "' '" + sid + "'";
            buffer.append("<!ENTITY fakeEntity" + RANDOM + entityRef + ">\n");
            buffer.append("]>\n");
            buffer.append("<fakeDocument" + RANDOM + ">\n");
            buffer.append("&fakeEntity" + RANDOM + ";\n");
            buffer.append("</fakeDocument" + RANDOM + ">\n");
            fakeDocument = buffer.toString();
        } else {
            StringBuffer buffer = new StringBuffer();
            String extRef = " PUBLIC '" + FAKE_PUBLIC_ID + "' '" + sid + "'";
            buffer.append("<!DOCTYPE fakeDocument" + RANDOM + extRef + ">\n");
            buffer.append("<fakeDocument" + RANDOM + "/>\n");
            fakeDocument = buffer.toString();
        }
        fakeInput.setCharacterStream(new StringReader(fakeDocument));
        return fakeInput;
    }

    protected boolean propagateException(SAXParseException ex) {
        if (ex == null) {
            return false;
        }
        return !FAKE_SYSTEM_ID.equals(ex.getSystemId());
    }

    public ContentHandler getContentHandler() {
        return this.peer.getContentHandler();
    }

    public DTDHandler getDTDHandler() {
        return this.peer.getDTDHandler();
    }

    public EntityResolver getEntityResolver() {
        return this.peer.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.peer.getErrorHandler();
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.peer.getFeature(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.peer.getProperty(name);
    }

    public void parse(String sid) throws IOException, SAXException {
        this.parse(new InputSource(sid));
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.peer.setContentHandler(contentHandler);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.peer.setDTDHandler(dTDHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.peer.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.peer.setErrorHandler(errorHandler);
    }

    public void setFeature(String name, boolean val) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.peer.setFeature(name, val);
    }

    public void setProperty(String name, Object val) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.peer.setProperty(name, val);
    }

    private synchronized void checkUsed() {
        if (this.used) {
            throw new IllegalStateException();
        }
    }

    private class EH
    implements ErrorHandler {
        private final ErrorHandler peer;

        public EH(ErrorHandler peer) {
            this.peer = peer;
        }

        public void error(SAXParseException ex) throws SAXException {
            if (SAXEntityParser.this.propagateException(ex)) {
                this.peer.error(ex);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", ex);
            }
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            if (SAXEntityParser.this.propagateException(ex)) {
                this.peer.fatalError(ex);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", ex);
            }
        }

        public void warning(SAXParseException ex) throws SAXException {
            if (SAXEntityParser.this.propagateException(ex)) {
                this.peer.warning(ex);
            } else {
                Util.THIS.debug("SAXEntityParser: filtering out:", ex);
            }
        }
    }

    private class ER
    implements EntityResolver {
        private boolean entityResolved;
        private final EntityResolver peer;
        private final InputSource entity;

        public ER(EntityResolver peer, InputSource entity) {
            this.peer = peer;
            this.entity = entity;
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException, IOException {
            Util.THIS.debug("SAXEntityParser:resolving PID: " + pid + " SID: " + sid);
            if (this.isFirstRequest()) {
                Util.THIS.debug("SAXEntityParser:redirecting to " + this.entity + " SID: " + this.entity.getSystemId());
                if (this.peer != null && this.entity.getByteStream() == null && this.entity.getCharacterStream() == null) {
                    return this.peer.resolveEntity(this.entity.getPublicId(), this.entity.getSystemId());
                }
                return this.entity;
            }
            if (this.peer == null) {
                return null;
            }
            return this.peer.resolveEntity(pid, sid);
        }

        private synchronized boolean isFirstRequest() {
            if (!this.entityResolved) {
                this.entityResolved = true;
                return true;
            }
            return false;
        }
    }
}

