/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import java.awt.dnd.DropTargetDragEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.NewComponentDrop;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class DBConnectionDrop
implements NewComponentDrop {
    private DatabaseMetaDataTransfer.Connection connection;
    private boolean bindingOnly;
    FormModel model;
    Project project;
    boolean assistantInitialized;

    public DBConnectionDrop(FormModel model, DatabaseMetaDataTransfer.Connection connection) {
        this.model = model;
        this.connection = connection;
    }

    public PaletteItem getPaletteItem(DropTargetDragEvent dtde) {
        PaletteItem pItem = new PaletteItem(new ClassSource("javax.persistence.EntityManager", new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(LibraryManager.getDefault().getLibrary("eclipselink"))}), null);
        pItem.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/j2ee/resources/EntityManager.png", (boolean)false).getImage());
        return pItem;
    }

    public void componentAdded(String componentId, String droppedOverId) {
        try {
            FileObject formFile = FormEditor.getFormDataObject((FormModel)this.model).getFormFile();
            this.project = FileOwnerQuery.getOwner((FileObject)formFile);
            FileObject persistenceXML = J2EEUtils.getPersistenceXML(this.project, true);
            PersistenceUnit unit = J2EEUtils.initPersistenceUnit(persistenceXML, this.connection.getDatabaseConnection());
            J2EEUtils.updateProjectForUnit(formFile, unit, this.connection.getJDBCDriver());
            RADComponent entityManager = this.model.getMetaComponent(componentId);
            entityManager.getPropertyByName("persistenceUnit").setValue((Object)unit.getName());
            J2EEUtils.renameComponent(entityManager, true, unit.getName() + "EntityManager", "entityManager");
        }
        catch (IOException ioex) {
            Logger.getLogger(DBConnectionDrop.class.getName()).log(Level.INFO, null, ioex);
        }
        catch (InvalidPersistenceXmlException ipxex) {
            Logger.getLogger(DBConnectionDrop.class.getName()).log(Level.INFO, null, ipxex);
        }
        catch (IllegalAccessException iaex) {
            Logger.getLogger(DBConnectionDrop.class.getName()).log(Level.INFO, null, iaex);
        }
        catch (InvocationTargetException itex) {
            Logger.getLogger(DBConnectionDrop.class.getName()).log(Level.INFO, null, itex);
        }
    }

    protected RADComponent initEntityManagerBean(PersistenceUnit unit) throws Exception {
        String puName = unit.getName();
        RADComponent entityManager = J2EEUtils.findEntityManager(this.model, puName);
        if (entityManager == null) {
            entityManager = J2EEUtils.createEntityManager(this.model, puName);
        }
        return entityManager;
    }

    void setBindingOnly(boolean bindingOnly) {
        this.bindingOnly = bindingOnly;
    }

    boolean isBindingOnly() {
        return this.bindingOnly;
    }
}

