/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.content.file.ReferencesIndex;
import org.netbeans.modules.cnd.modelimpl.csm.core.AccessorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryNotifier;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.FileNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ModelImpl
implements CsmModel,
LowMemoryListener {
    private final String clientTaskPrefix = "Code Model Client Request";
    private static final String modelTaskPrefix = "Code Model Request Processor";
    private final Object lock = new Lock();
    private final Map<Object, CsmUID<CsmProject>> platf2csm = new ConcurrentHashMap<Object, CsmUID<CsmProject>>();
    private volatile CsmModelState state;
    private final double warningThreshold = 0.98;
    private final Set<Object> disabledProjects = Collections.synchronizedSet(new HashSet());
    private final Set<NativeProject> projectsBeingCreated = Collections.synchronizedSet(new HashSet());
    private final RequestProcessor modelProcessor = new RequestProcessor("Code model request processor", 1);
    private final Set<Runnable> modelProcessorTasks = new HashSet<Runnable>();
    private final RequestProcessor userTasksProcessor = new RequestProcessor("User model tasks processor", 4);
    private final Set<Runnable> userProcessorTasks = new HashSet<Runnable>();

    public ModelImpl() {
        this.startup();
    }

    static boolean isClosedProject(Key startFileProject) {
        ModelImpl instance = ModelSupport.instance().getModel();
        if (instance != null) {
            return instance.isClosedImpl(startFileProject);
        }
        return true;
    }

    private boolean isClosedImpl(Key proj) {
        ArrayList<CsmUID<CsmProject>> vals = new ArrayList<CsmUID<CsmProject>>(this.platf2csm.values());
        for (CsmUID csmUID : vals) {
            if (!proj.equals(RepositoryUtils.UIDtoKey(csmUID))) continue;
            return false;
        }
        return true;
    }

    ProjectBase findProject(Object id) {
        ProjectBase prj = null;
        if (id != null) {
            prj = this.obj2Project(id);
        }
        return prj;
    }

    private ProjectBase obj2Project(Object obj) {
        CsmUID<CsmProject> prjUID = this.platf2csm.get(obj);
        ProjectBase prj = (ProjectBase)UIDCsmConverter.UIDtoProject(prjUID);
        assert (prj != null || prjUID == null) : "null object for UID " + prjUID;
        return prj;
    }

    public ProjectBase getProject(Object id) {
        NativeProject prj;
        if (id instanceof Project && (prj = (NativeProject)((Project)id).getLookup().lookup(NativeProject.class)) != null) {
            id = prj;
        }
        return this.findProject(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CsmProject _getProject(Object id) {
        ProjectBase prj = null;
        if (id != null) {
            Object object = this.lock;
            synchronized (object) {
                prj = this.obj2Project(id);
                if (prj == null && id instanceof Project) {
                    if (TraceFlags.DEBUG) {
                        System.err.println("getProject called with Project... expected NativeProject");
                        new Throwable().printStackTrace(System.err);
                    }
                    ProjectBase projectBase = prj = (id = ((Project)id).getLookup().lookup(NativeProject.class)) != null ? this.obj2Project(id) : null;
                }
                if (prj == null) {
                    String name;
                    if (this.disabledProjects.contains(id)) {
                        return null;
                    }
                    if (id instanceof NativeProject) {
                        name = ((NativeProject)id).getProjectDisplayName();
                    } else {
                        new IllegalStateException("CsmProject does not exist: " + id).printStackTrace(System.err);
                        name = "<unnamed>";
                    }
                    NativeProject nativeProject = (NativeProject)id;
                    try {
                        this.projectsBeingCreated.add(nativeProject);
                        prj = ProjectImpl.createInstance(this, nativeProject, name);
                        if (prj != null) {
                            this.putProject2Map(id, prj);
                        }
                    }
                    finally {
                        this.projectsBeingCreated.remove(nativeProject);
                    }
                }
            }
        }
        return prj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ProjectBase addProject(NativeProject id, String name, boolean enableModel) {
        prj = null;
        if (!ModelImpl.$assertionsDisabled && id == null) {
            throw new AssertionError((Object)"The platform project is null");
        }
        if (enableModel && !this.disabledProjects.contains(id)) {
            fireOpened = false;
            var6_7 = this.lock;
            synchronized (var6_7) {
                if (this.state != CsmModelState.ON) {
                    if (TraceFlags.TRACE_MODEL_STATE) {
                        System.err.println("project " + name + " wasn't added because model is " + this.state + "\n\t" + id);
                    }
                    return null;
                }
                prj = this.obj2Project(id);
                if (prj == null) {
                    try {
                        this.projectsBeingCreated.add(id);
                        prj = ProjectImpl.createInstance(this, id, name);
                        if (prj == null) ** GOTO lbl34
                        this.putProject2Map(id, prj);
                        fireOpened = true;
                    }
                    finally {
                        this.projectsBeingCreated.remove(id);
                    }
                } else {
                    expectedUniqueName = ProjectBase.getUniqueName(id).toString();
                    defactoUniqueName = prj.getUniqueName().toString();
                    if (!defactoUniqueName.equals(expectedUniqueName)) {
                        new IllegalStateException("Existing project unique name differ: " + defactoUniqueName + " - expected " + expectedUniqueName).printStackTrace(System.err);
                    }
                }
            }
lbl34:
            // 3 sources

            if (fireOpened) {
                ListenersImpl.getImpl().fireProjectOpened(prj);
            }
        } else {
            var5_6 = this.lock;
            synchronized (var5_6) {
                this.disabledProjects.add(id);
            }
        }
        return prj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase testAddProject(ProjectBase prj) {
        Object object = this.lock;
        synchronized (object) {
            Object id = prj.getPlatformProject();
            assert (id != null) : "It is expected that prj.getPlatformProject() is not NULL here";
            if (this.obj2Project(id) != null) {
                new IllegalStateException("CsmProject already exists: " + id).printStackTrace(System.err);
                return null;
            }
            this.putProject2Map(id, prj);
        }
        ListenersImpl.getImpl().fireProjectOpened(prj);
        return prj;
    }

    private void putProject2Map(Object id, ProjectBase prj) {
        CsmUID<CsmProject> uid = UIDCsmConverter.projectToUID(prj);
        this.platf2csm.put(id, uid);
    }

    public void closeProject(NativeProject platformProject) {
        this._closeProject(null, platformProject, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public void closeProject(NativeProject platformProject, boolean cleanRepository) {
        this._closeProject(null, platformProject, cleanRepository);
    }

    public void closeProject(Object platformProject, boolean cleanRepository) {
        this._closeProject(null, platformProject, cleanRepository);
    }

    public void closeProjectBase(ProjectBase prj) {
        this._closeProject(prj, prj.getPlatformProject(), !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public void closeProjectBase(ProjectBase prj, boolean cleanRepository) {
        this._closeProject(prj, prj.getPlatformProject(), cleanRepository);
    }

    private void _closeProject(final ProjectBase csmProject, final Object platformProjectKey, final boolean cleanRepository) {
        try {
            this._closeProject2_pre(csmProject, platformProjectKey);
            if (SwingUtilities.isEventDispatchThread()) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        ModelImpl.this._closeProject2(csmProject, platformProjectKey, cleanRepository);
                    }
                };
                this.enqueueModelTask(task, "Closing Project " + (csmProject == null ? platformProjectKey + "" : csmProject.getDisplayName()));
            } else {
                this._closeProject2(csmProject, platformProjectKey, cleanRepository);
            }
        }
        catch (Throwable thr) {
            DiagnosticExceptoins.register(thr);
        }
    }

    private void _closeProject2_pre(ProjectBase csmProject, Object platformProjectKey) {
        ProjectBase prj;
        ProjectBase projectBase = prj = csmProject == null ? this.getProject(platformProjectKey) : csmProject;
        if (prj != null) {
            prj.setDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeProject2(ProjectBase csmProject, Object platformProjectKey, boolean cleanRepository) {
        boolean cleanModel;
        ProjectBase prj = csmProject;
        Object object = this.lock;
        synchronized (object) {
            if (platformProjectKey != null) {
                CsmUID<CsmProject> uid = this.platf2csm.remove(platformProjectKey);
                if (uid != null) {
                    ProjectBase projectBase = prj = prj == null ? (ProjectBase)UIDCsmConverter.UIDtoProject(uid) : prj;
                    assert (prj != null) : "null object for UID " + uid;
                }
                this.disabledProjects.remove(platformProjectKey);
            }
            cleanModel = this.platf2csm.isEmpty();
        }
        if (prj != null) {
            this.disposeProject(prj, cleanRepository);
            if (!prj.isArtificial()) {
                LibraryManager.getInstance(prj.getUnitId()).onProjectClose(prj.getUID(), cleanRepository);
            }
        }
        if (cleanModel) {
            this.cleanCaches();
        }
    }

    void disposeProject(ProjectBase prj) {
        this.disposeProject(prj, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    void disposeProject(ProjectBase prj, boolean cleanRepository) {
        assert (prj != null);
        if (prj != null) {
            CharSequence name = prj.getName();
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("dispose project " + name);
            }
            prj.setDisposed();
            ListenersImpl.getImpl().fireProjectClosed(prj);
            ParserThreadManager.instance().waitEmptyProjectQueue(prj);
            prj.dispose(cleanRepository);
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("project closed " + name);
            }
        }
    }

    public Collection<CsmProject> projects() {
        ArrayList<CsmUID<CsmProject>> vals = new ArrayList<CsmUID<CsmProject>>(this.platf2csm.values());
        ArrayList<CsmProject> out = new ArrayList<CsmProject>(vals.size());
        for (CsmUID csmUID : vals) {
            ProjectBase prj = (ProjectBase)UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)csmUID);
            assert (prj != null) : "null project for UID " + csmUID;
            if (prj == null) continue;
            out.add(prj);
        }
        return out;
    }

    public Cancellable enqueue(Runnable task, CharSequence name) {
        return this.enqueueOrCreate(this.userTasksProcessor, task, "Code Model Client Request :" + name, false);
    }

    public static ModelImpl instance() {
        return (ModelImpl)CsmModelAccessor.getModel();
    }

    public RequestProcessor.Task enqueueModelTask(Runnable task, String name) {
        return this.enqueueOrCreate(this.modelProcessor, task, "Code Model Request Processor: " + name, false);
    }

    public RequestProcessor.Task createModelTask(Runnable task, String name) {
        return this.enqueueOrCreate(this.modelProcessor, task, "Code Model Request Processor: " + name, false);
    }

    public static boolean isModelRequestProcessorThread() {
        return ModelImpl.instance().modelProcessor.isRequestProcessorThread();
    }

    public void waitModelTasks() {
        RequestProcessor.Task task = this.enqueueOrCreate(this.modelProcessor, new Runnable(){

            @Override
            public void run() {
            }
        }, "wait finished other tasks", true);
        task.waitFinished();
    }

    private RequestProcessor.Task enqueueOrCreate(RequestProcessor processor, final Runnable task, final String taskName, boolean force) {
        if (!force && !CsmModelAccessor.isModelAlive()) {
            if (TraceFlags.TRACE_MODEL_STATE) {
                System.err.println("Reject task [" + taskName + "] on model closing");
            }
            return null;
        }
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception(taskName).printStackTrace(System.err);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String oldName = Thread.currentThread().getName();
                Thread.currentThread().setName(taskName);
                try {
                    task.run();
                }
                catch (Throwable thr) {
                    DiagnosticExceptoins.register(thr);
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        };
        return processor.post(r);
    }

    public CsmFile[] findFiles(FSPath absPath, boolean createIfPossible, boolean snapShot) {
        CsmFile[] out;
        CndUtils.assertAbsolutePathInConsole((String)absPath.getPath());
        Collection<CsmProject> projects = this.projects();
        HashSet<CsmFile> ret = new HashSet<CsmFile>();
        for (CsmProject curPrj : projects) {
            CsmFile csmFile;
            ProjectBase ownerPrj;
            if (!(curPrj instanceof ProjectBase) || (ownerPrj = ((ProjectBase)curPrj).findFileProject(absPath, createIfPossible)) == null || (csmFile = ownerPrj.findFile(absPath, createIfPossible, snapShot)) == null) continue;
            ret.add(csmFile);
        }
        FSPath canonical = null;
        try {
            FileObject fo = absPath.getFileObject();
            if (fo != null) {
                canonical = FSPath.toFSPath((FileObject)CndFileUtils.getCanonicalFileObject((FileObject)fo));
            }
        }
        catch (IOException ex) {
            canonical = null;
        }
        if (canonical != null && !canonical.equals((Object)absPath) && (out = this.findFiles(canonical, createIfPossible, snapShot)) != null) {
            ret.addAll(Arrays.asList(out));
        }
        return ret.toArray(new CsmFile[ret.size()]);
    }

    public CsmFile findFile(FSPath absPath, boolean createIfPossible, boolean snapShot) {
        CsmFile out;
        CndUtils.assertAbsolutePathInConsole((String)absPath.getPath());
        Collection<CsmProject> projects = this.projects();
        CsmFile ret = null;
        for (CsmProject curPrj : projects) {
            CsmFile csmFile;
            ProjectBase ownerPrj;
            if (!(curPrj instanceof ProjectBase) || (ownerPrj = ((ProjectBase)curPrj).findFileProject(absPath, createIfPossible)) == null || (csmFile = ownerPrj.findFile(absPath, createIfPossible, snapShot)) == null) continue;
            ret = csmFile;
            if (CsmStandaloneFileProvider.getDefault().isStandalone(csmFile)) continue;
            return ret;
        }
        FSPath canonical = null;
        try {
            FileObject fo = absPath.getFileObject();
            if (fo != null) {
                canonical = FSPath.toFSPath((FileObject)CndFileUtils.getCanonicalFileObject((FileObject)fo));
            }
        }
        catch (IOException ex) {
            canonical = null;
        }
        if (canonical != null && !canonical.equals((Object)absPath) && (out = this.findFile(canonical, createIfPossible, snapShot)) != null) {
            ret = out;
        }
        return ret;
    }

    public CsmModelState getState() {
        return this.state;
    }

    public final void startup() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.startup");
        }
        ModelSupport.instance().setModel(this);
        this.setState(CsmModelState.ON);
        if (TraceFlags.CHECK_MEMORY) {
            LowMemoryNotifier.instance().addListener(this);
            LowMemoryNotifier.instance().setThresholdPercentage(0.98);
        }
        ParserThreadManager.instance().startup(CndUtils.isStandalone());
        RepositoryUtils.startup();
        ReferencesIndex.startup();
    }

    void notifyClosing() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.closing");
        }
        this.setState(CsmModelState.CLOSING);
        ParserThreadManager.instance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Collection<CsmProject> prjsColl;
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.shutdown");
        }
        this.setState(CsmModelState.CLOSING);
        ParserThreadManager.instance().shutdown();
        this.waitModelTasks();
        if (TraceFlags.CHECK_MEMORY) {
            LowMemoryNotifier.instance().removeListener(this);
        }
        HashSet libs = new HashSet();
        Object object = this.lock;
        synchronized (object) {
            prjsColl = this.projects();
            this.platf2csm.clear();
        }
        for (ProjectBase projectBase : prjsColl) {
            libs.addAll(projectBase.getLibraries());
            this.disposeProject(projectBase);
        }
        Iterator<Object> projIter = libs.iterator();
        while (projIter.hasNext()) {
            this.disposeProject((ProjectBase)projIter.next());
        }
        LibraryManager.shutdown();
        this.cleanCaches();
        this.setState(CsmModelState.OFF);
        ReferencesIndex.shutdown();
        RepositoryUtils.shutdown();
        ModelSupport.instance().setModel(null);
    }

    @Override
    public void memoryLow(final LowMemoryEvent event) {
        double percentage = (double)event.getUsedMemory() / (double)event.getMaxMemory();
        boolean warning = percentage >= 0.98 && this.projects().size() > 0;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Code model low memory handler");
                ModelSupport.instance().onMemoryLow(event, false);
            }
        };
        new Thread(runner).start();
    }

    private void setState(CsmModelState newState) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("  ModelImpl.setState " + this.state + " -> " + newState);
        }
        if (newState != this.state) {
            CsmModelState oldState = this.state;
            this.state = newState;
            ListenersImpl.getImpl().fireModelStateChanged(newState, oldState);
        }
    }

    private void suspend() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.suspend");
        }
        this.setState(CsmModelState.SUSPENDED);
        ParserQueue.instance().suspend();
    }

    private void resume() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.resume");
        }
        this.setState(CsmModelState.ON);
        ParserQueue.instance().resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableProject(Object id) {
        NativeProject nativeProject = (NativeProject)id;
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject " + nativeProject.getProjectDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.disabledProjects.add(nativeProject);
        }
        ProjectBase csmProject = this.findProject(nativeProject);
        if (csmProject != null) {
            this.disableProject2(csmProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableProjectBase(ProjectBase csmProject) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject " + csmProject);
        }
        if (csmProject != null) {
            Object object = this.lock;
            synchronized (object) {
                Object id = csmProject.getPlatformProject();
                assert (id != null) : "It is expected that csmProject.getPlatformProject() is not NULL here";
                this.disabledProjects.add(id);
            }
            this.disableProject2(csmProject);
        }
    }

    private void disableProject2(ProjectBase csmProject) {
        csmProject.setDisposed();
        Lookup.Provider project = ModelImpl.findProjectByNativeProject(ModelSupport.getNativeProject(csmProject.getPlatformProject()));
        this.setCodeAssistanceEnabled(project, false);
        this.disableProject3(csmProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableProject3(ProjectBase csmProject) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject3");
        }
        this.suspend();
        try {
            boolean cleanModel;
            while (ParserQueue.instance().isParsing(csmProject)) {
                try {
                    if (TraceFlags.TRACE_MODEL_STATE) {
                        System.err.println("ModelImpl.disableProject3: waiting for current parse...");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.closeProjectBase(csmProject);
            Object object = this.lock;
            synchronized (object) {
                cleanModel = this.platf2csm.isEmpty();
            }
            if (cleanModel) {
                this.cleanCaches();
            }
        }
        finally {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableProject(Object id) {
        assert (id instanceof NativeProject) : "unexpected class " + id;
        NativeProject nativeProject = (NativeProject)id;
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.enableProject " + nativeProject.getProjectDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.disabledProjects.remove(nativeProject);
        }
        Lookup.Provider project = ModelImpl.findProjectByNativeProject(nativeProject);
        this.setCodeAssistanceEnabled(project, true);
        this.addProject(nativeProject, nativeProject.getProjectDisplayName(), Boolean.TRUE);
    }

    private void setCodeAssistanceEnabled(Lookup.Provider project, boolean enable) {
        NativeProjectSettings settings;
        boolean actionPerformed = false;
        if (project != null && (settings = (NativeProjectSettings)project.getLookup().lookup(NativeProjectSettings.class)) != null) {
            settings.setCodeAssistanceEnabled(enable);
            actionPerformed = true;
        }
    }

    public static Lookup.Provider findProjectByNativeProject(NativeProject nativeProjectToSearch) {
        for (NativeProject nativeProject : NativeProjectRegistry.getDefault().getOpenProjects()) {
            if (nativeProject != nativeProjectToSearch) continue;
            return nativeProject.getProject();
        }
        return null;
    }

    @SuppressWarnings(value={"NP"})
    public Boolean isProjectEnabled(Object nativeProject) {
        assert (nativeProject instanceof NativeProject) : "unexpected class " + nativeProject;
        if (this.projectsBeingCreated.contains((NativeProject)nativeProject)) {
            return null;
        }
        ProjectBase project = this.getProject(nativeProject);
        return project != null && !project.isDisposing();
    }

    public boolean isProjectDisabled(Object nativeProject) {
        assert (nativeProject instanceof NativeProject) : "unexpected class " + nativeProject;
        return this.disabledProjects.contains((NativeProject)nativeProject);
    }

    private void cleanCaches() {
        TextCache.getManager().dispose();
        FilePathCache.getManager().dispose();
        QualifiedNameCache.getManager().dispose();
        NameCache.getManager().dispose();
        UniqueNameCache.getManager().dispose();
        FileNameCache.getManager().dispose();
        ProjectNameCache.getManager().dispose();
        APTDriver.close();
        ClankDriver.close();
        APTFileCacheManager.close();
        UIDManager.instance().dispose();
        KeyManager.instance().dispose();
        CndFileUtils.clearFileExistenceCache();
        APTFileCacheManager.invalidateAll();
        APTSystemStorage.dispose();
    }

    public void scheduleReparse(final Collection<CsmProject> projects) {
        this.enqueueModelTask(new Runnable(){

            @Override
            public void run() {
                Object platformProject;
                CndFileUtils.clearFileExistenceCache();
                ParserQueue.instance().clearParseWatch();
                ClankDriver.invalidateAll();
                APTFileCacheManager.invalidateAll();
                APTSystemStorage.dispose();
                HashSet<LibProjectImpl> libs = new HashSet<LibProjectImpl>();
                HashSet<ProjectBase> toReparse = new HashSet<ProjectBase>();
                for (CsmProject csmProject : projects) {
                    if (!(csmProject instanceof ProjectBase)) continue;
                    ProjectBase projectBase = (ProjectBase)csmProject;
                    toReparse.add(projectBase);
                    for (CsmProject csmLib : projectBase.getLibraries()) {
                        LibProjectImpl lib;
                        if (!(csmLib instanceof LibProjectImpl) || libs.contains(lib = (LibProjectImpl)csmLib)) continue;
                        libs.add(lib);
                    }
                }
                for (CsmProject csmProject : ModelImpl.this.projects()) {
                    if (projects.contains(csmProject) || !(csmProject instanceof ProjectBase)) continue;
                    ProjectBase projectBase = (ProjectBase)csmProject;
                    for (CsmProject csmLib : projectBase.getLibraries()) {
                        if (!(csmLib instanceof LibProjectImpl)) continue;
                        libs.remove((LibProjectImpl)csmLib);
                    }
                }
                for (LibProjectImpl lib : libs) {
                    lib.initFields();
                }
                ArrayList<Object> platformProjects = new ArrayList<Object>();
                for (ProjectBase projectBase : toReparse) {
                    platformProject = projectBase.getPlatformProject();
                    if (platformProject == null) continue;
                    platformProjects.add(platformProject);
                    ModelImpl.this.closeProject(platformProject, true);
                }
                for (LibProjectImpl libProjectImpl : libs) {
                    platformProject = libProjectImpl.getPlatformProject();
                    CndUtils.assertTrue((platformProject != null || libProjectImpl.isDisposing() ? 1 : 0) != 0, (String)"No Platform project for ", (Object)libProjectImpl);
                    if (platformProject == null) continue;
                    ModelImpl.this.closeProject(platformProject, true);
                }
                LibraryManager.cleanLibrariesData(libs);
                for (Object e : platformProjects) {
                    ProjectBase newPrj = (ProjectBase)ModelImpl.this._getProject(e);
                    if (newPrj == null) continue;
                    newPrj.scheduleReparse();
                    ListenersImpl.getImpl().fireProjectOpened(newPrj);
                }
            }
        }, "Reparse projects");
    }

    public void dumpInfo(PrintWriter printOut, boolean withContainers) {
        printOut.printf("ModelImpl: disabled=%d, projects=%d%n", this.disabledProjects.size(), this.platf2csm.size());
        int ind = 1;
        for (Object object : this.disabledProjects) {
            printOut.printf("D[%d] %s%n", ind++, object);
        }
        ind = 1;
        for (Map.Entry entry : this.platf2csm.entrySet()) {
            Object key = entry.getKey();
            CsmUID value = (CsmUID)entry.getValue();
            printOut.printf("[%d] key=[%s] %s%n\tprj=(%d)%s%n", ind, key.getClass().getSimpleName(), key, System.identityHashCode(value), value);
            CsmProject prj = UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)value);
            if (prj == null) {
                printOut.printf("Project was NOT restored from repository%n", new Object[0]);
            } else if (prj instanceof ProjectBase) {
                printOut.printf("[%d] disposing?=%s%n", ind, ((ProjectBase)prj).isDisposing());
                Collection libraries = prj.getLibraries();
                int libInd = 0;
                for (CsmProject lib : libraries) {
                    printOut.printf("\tlib[%d]=%s%n", ++libInd, lib);
                }
                Object platformProject = prj.getPlatformProject();
                printOut.printf("platformProjec=%s%n", platformProject);
                if (platformProject instanceof NativeProject) {
                    NativeProject np = (NativeProject)platformProject;
                    List dependences = np.getDependences();
                    libInd = 0;
                    for (NativeProject nativeLib : dependences) {
                        printOut.printf("\tnativeLib[%d]=%s%n", ++libInd, nativeLib);
                    }
                }
                if (withContainers) {
                    ProjectBase.dumpFileContainer(prj, printOut);
                }
            } else {
                printOut.printf("Project has unexpected class type %s%n", prj.getClass().getName());
            }
            ++ind;
        }
    }

    static {
        CsmCorePackageAccessor.register(new AccessorImpl());
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

