/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.spi.CsmDisplayUtilitiesProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class CsmDisplayUtilitiesProviderImpl
extends CsmDisplayUtilitiesProvider {
    private static final char SPACE = ' ';

    public CharSequence getTooltipText(CsmObject item) {
        try {
            CharSequence tooltipText = null;
            if (CsmKindUtilities.isMethod((CsmObject)item)) {
                CharSequence functionDisplayName = this.getFunctionText((CsmFunction)item);
                CsmMethod meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)item));
                CsmClass methodDeclaringClass = meth.getContainingClass();
                CharSequence displayClassName = methodDeclaringClass.getQualifiedName();
                String key = "DSC_MethodTooltip";
                if (CsmKindUtilities.isConstructor((CsmObject)item)) {
                    key = "DSC_ConstructorTooltip";
                } else if (CsmKindUtilities.isDestructor((CsmObject)item)) {
                    key = "DSC_DestructorTooltip";
                }
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString(key, functionDisplayName, displayClassName);
            } else if (CsmKindUtilities.isFunction((CsmObject)item)) {
                CharSequence functionDisplayName = this.getFunctionText((CsmFunction)item);
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_FunctionTooltip", functionDisplayName);
            } else if (CsmKindUtilities.isClass((CsmObject)item)) {
                CsmDeclaration.Kind classKind = ((CsmDeclaration)item).getKind();
                String key = classKind == CsmDeclaration.Kind.STRUCT ? "DSC_StructTooltip" : (classKind == CsmDeclaration.Kind.UNION ? "DSC_UnionTooltip" : "DSC_ClassTooltip");
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString(key, ((CsmClassifier)item).getQualifiedName());
            } else if (CsmKindUtilities.isTypedef((CsmObject)item) || CsmKindUtilities.isTypeAlias((CsmObject)item)) {
                CharSequence tdName = ((CsmTypedef)item).getQualifiedName();
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_TypedefTooltip", tdName, ((CsmTypedef)item).getText());
            } else if (CsmKindUtilities.isEnum((CsmObject)item)) {
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_EnumTooltip", ((CsmEnum)item).getQualifiedName());
            } else if (CsmKindUtilities.isEnumerator((Object)item)) {
                CsmEnumerator enmtr = (CsmEnumerator)item;
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_EnumeratorTooltip", enmtr.getName(), enmtr.getEnumeration().getQualifiedName());
            } else if (CsmKindUtilities.isField((CsmObject)item)) {
                CharSequence fieldName = ((CsmField)item).getName();
                CsmClass containingClass = ((CsmField)item).getContainingClass();
                CharSequence displayClassName = containingClass.getQualifiedName();
                String classKind = "class";
                if (containingClass.getKind() == CsmDeclaration.Kind.STRUCT) {
                    classKind = "struct";
                } else if (containingClass.getKind() == CsmDeclaration.Kind.UNION) {
                    classKind = "union";
                }
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_FieldTooltip", fieldName, classKind, displayClassName, ((CsmField)item).getText());
            } else if (CsmKindUtilities.isParamVariable((CsmObject)item)) {
                CharSequence varName = ((CsmParameter)item).getName();
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_ParameterTooltip", varName, ((CsmParameter)item).getText());
            } else if (CsmKindUtilities.isVariable((CsmObject)item)) {
                CharSequence varName = ((CsmVariable)item).getName();
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_VariableTooltip", varName, this.getVariableText((CsmVariable)item));
            } else if (CsmKindUtilities.isFile((CsmObject)item)) {
                CharSequence fileName = ((CsmFile)item).getName();
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_FileTooltip", fileName);
            } else if (CsmKindUtilities.isNamespace((Object)item)) {
                CharSequence nsName = ((CsmNamespace)item).getQualifiedName();
                tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_NamespaceTooltip", nsName);
            } else if (CsmKindUtilities.isMacro((CsmObject)item)) {
                CsmMacro macro = (CsmMacro)item;
                switch (macro.getKind()) {
                    case DEFINED: {
                        tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_MacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case COMPILER_PREDEFINED: {
                        tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_SysMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case POSITION_PREDEFINED: {
                        tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_PosMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    case USER_SPECIFIED: {
                        tooltipText = CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_ProjectMacroTooltip", macro.getName(), macro.getText());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected macro kind:" + macro.getKind() + " in macro:" + macro);
                    }
                }
            } else {
                CsmInclude incl;
                CsmFile target;
                tooltipText = CsmKindUtilities.isErrorDirective((CsmObject)item) ? CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_ErrorDirectiveTooltip", ((CsmErrorDirective)item).getErrorMessage()) : (CsmKindUtilities.isInclude((CsmObject)item) ? ((target = (incl = (CsmInclude)item).getIncludeFile()) == null ? (incl.getIncludeState() == CsmInclude.IncludeState.Recursive ? CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_IncludeRecursiveTooltip", incl.getText()) : CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_IncludeErrorTooltip", incl.getText())) : (target.getProject().isArtificial() ? CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_IncludeLibraryTooltip", target.getAbsolutePath()) : CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_IncludeTooltip", target.getAbsolutePath(), target.getProject().getName()))) : (CsmKindUtilities.isQualified((CsmObject)item) ? ((CsmQualifiedNamedElement)item).getQualifiedName() : (CsmKindUtilities.isLabel((CsmObject)item) ? CsmDisplayUtilitiesProviderImpl.getHtmlizedString("DSC_LabelTooltip", ((CsmLabel)item).getLabel()) : (CsmKindUtilities.isNamedElement((CsmObject)item) ? ((CsmNamedElement)item).getName() : "unhandled object " + item))));
            }
            return tooltipText;
        }
        catch (Exception e) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("can not get text for " + item + " due to " + e));
            return "";
        }
    }

    public CharSequence getTypeText(CsmType type, boolean expandInstantiations, boolean evaluateExpressions) {
        if (type != null) {
            CsmClassifier resolvedCls;
            CsmUtilities.Qualificator qual;
            StringBuilder itemTextBuilder = new StringBuilder();
            DisplayTypeInfoCollector dtc = new DisplayTypeInfoCollector();
            type = CsmUtilities.iterateTypeChain((CsmType)type, (CsmUtilities.Predicate)dtc);
            List quals = dtc.infoCollector.qualificators;
            ListIterator qualIter = quals.listIterator(quals.size());
            CsmUtilities.Qualificator qualificator = qual = qualIter.hasPrevious() ? (CsmUtilities.Qualificator)qualIter.previous() : null;
            if (CsmUtilities.Qualificator.CONST.equals((Object)qual)) {
                CsmDisplayUtilitiesProviderImpl.appendQual(itemTextBuilder, qual).append(' ');
                CsmUtilities.Qualificator qualificator2 = qual = qualIter.hasPrevious() ? (CsmUtilities.Qualificator)qualIter.previous() : null;
            }
            if ((resolvedCls = type.getClassifier()) != null) {
                itemTextBuilder.append(resolvedCls.getQualifiedName());
                if (type.isInstantiation() && type.hasInstantiationParams()) {
                    itemTextBuilder.append(Instantiation.getInstantiationCanonicalText(type.getInstantiationParams()));
                } else if (CsmKindUtilities.isInstantiation((CsmObject)resolvedCls)) {
                    List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> fullInstParams = InstantiationProviderImpl.getInstantiationParams((CsmObject)resolvedCls);
                    InstantiationProviderImpl.InstantiationParametersInfoImpl paramsInfo = new InstantiationProviderImpl.InstantiationParametersInfoImpl((CsmObject)resolvedCls, fullInstParams);
                    itemTextBuilder.append(Instantiation.getInstantiationCanonicalText(paramsInfo, new SpecParamsTextProvider(expandInstantiations, evaluateExpressions)));
                }
            } else {
                itemTextBuilder.append(type.getClassifierText());
            }
            boolean needSpace = true;
            while (qual != null && !CsmUtilities.Qualificator.REFERENCE.equals((Object)qual) && !CsmUtilities.Qualificator.RVALUE_REFERENCE.equals((Object)qual)) {
                if (needSpace) {
                    itemTextBuilder.append(' ');
                }
                CsmDisplayUtilitiesProviderImpl.appendQual(itemTextBuilder, qual);
                CsmUtilities.Qualificator prev = qualIter.hasPrevious() ? (CsmUtilities.Qualificator)qualIter.previous() : null;
                needSpace = CsmDisplayUtilitiesProviderImpl.isSpaceRequired(qual, prev);
                qual = prev;
            }
            if (qual != null) {
                CsmDisplayUtilitiesProviderImpl.appendQual(needSpace ? itemTextBuilder.append(' ') : itemTextBuilder, qual);
            }
            return itemTextBuilder.toString();
        }
        return "<null>";
    }

    private CharSequence getVariableText(CsmVariable var) {
        CharSequence itemText = var.getText();
        if (CsmUtilities.isAutoType((CsmType)var.getType())) {
            DisplayResolvedTypeHandler handler = new DisplayResolvedTypeHandler();
            CsmExpressionResolver.resolveType((CharSequence)var.getName(), (CsmFile)var.getContainingFile(), (int)var.getType().getEndOffset(), null, (CsmExpressionResolver.ResolvedTypeHandler)handler);
            if (handler.typeText != null) {
                return handler.typeText;
            }
        }
        return itemText;
    }

    private CharSequence getFunctionText(CsmFunction fun) {
        StringBuilder txt = new StringBuilder();
        if (CsmKindUtilities.isMethod((CsmObject)fun) && ((CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun)).isVirtual()) {
            txt.append("virtual ");
        }
        txt.append(fun.getReturnType().getText()).append(' ');
        txt.append(fun.getName());
        txt.append('(');
        Iterator params = fun.getParameters().iterator();
        while (params.hasNext()) {
            CsmParameter param = (CsmParameter)params.next();
            txt.append(param.getText());
            if (!params.hasNext()) continue;
            txt.append(", ");
        }
        txt.append(')');
        if (CsmKindUtilities.isMethod((CsmObject)fun)) {
            CsmMethod mtd = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun);
            if (mtd.isConst()) {
                txt.append(" const");
            }
            if (mtd.isAbstract()) {
                txt.append(" = 0");
            }
        }
        return txt.toString();
    }

    private static boolean isSpaceRequired(CsmUtilities.Qualificator current, CsmUtilities.Qualificator next) {
        return CsmUtilities.Qualificator.CONST.equals((Object)current) || CsmUtilities.Qualificator.CONST.equals((Object)next);
    }

    private static String getHtmlizedString(String key, CharSequence value) {
        return CsmDisplayUtilitiesProviderImpl.getString(key, CsmDisplayUtilities.htmlize((CharSequence)value));
    }

    private static String getHtmlizedString(String key, CharSequence value1, CharSequence value2) {
        return CsmDisplayUtilitiesProviderImpl.getString(key, CsmDisplayUtilities.htmlize((CharSequence)value1), CsmDisplayUtilities.htmlize((CharSequence)value2));
    }

    private static String getHtmlizedString(String key, CharSequence value1, CharSequence value2, CharSequence value3, CharSequence value4) {
        return CsmDisplayUtilitiesProviderImpl.getString(key, CsmDisplayUtilities.htmlize((CharSequence)value1), CsmDisplayUtilities.htmlize((CharSequence)value2), CsmDisplayUtilities.htmlize((CharSequence)value3), CsmDisplayUtilities.htmlize((CharSequence)value4));
    }

    private static String getString(String key, CharSequence value) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object)value);
    }

    private static String getString(String key, CharSequence value1, CharSequence value2) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object)value1, (Object)value2);
    }

    private static String getString(String key, CharSequence value1, CharSequence value2, CharSequence value3, CharSequence value4) {
        return NbBundle.getMessage(CsmDisplayUtilities.class, (String)key, (Object[])new Object[]{value1, value2, value3, value4});
    }

    private static StringBuilder appendQual(StringBuilder sb, CsmUtilities.Qualificator qual) {
        for (CppTokenId token : qual.getTokens()) {
            sb.append(token.fixedText());
        }
        return sb;
    }

    private static class DisplayTypeInfoCollector
    implements CsmUtilities.Predicate<CsmType> {
        public final CsmUtilities.TypeInfoCollector infoCollector = new CsmUtilities.TypeInfoCollector();
        private final CsmUtilities.SmartTypeUnrollPredicate smartPredicate = new CsmUtilities.SmartTypeUnrollPredicate();

        private DisplayTypeInfoCollector() {
        }

        public boolean check(CsmType value) {
            this.infoCollector.check(value);
            return this.smartPredicate.check(value);
        }
    }

    private class SpecParamsTextProvider
    implements Instantiation.CsmSpecializationParamTextProvider {
        private final boolean expandInstantiations;
        private final boolean evaluateExpressions;

        public SpecParamsTextProvider(boolean expandInstantiations, boolean evaluateExpressions) {
            this.expandInstantiations = expandInstantiations;
            this.evaluateExpressions = evaluateExpressions;
        }

        @Override
        public CharSequence getSpecParamText(CsmSpecializationParameter param, CsmType paramType, List<CsmInstantiation> context) {
            if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                if (this.expandInstantiations) {
                    return CsmDisplayUtilitiesProviderImpl.this.getTypeText(paramType, this.expandInstantiations, this.evaluateExpressions);
                }
                return paramType.getCanonicalText();
            }
            if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)param)) {
                if (this.evaluateExpressions) {
                    return param.getText();
                }
                return param.getText();
            }
            if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
                return param.getText();
            }
            return "";
        }
    }

    private class DisplayResolvedTypeHandler
    implements CsmExpressionResolver.ResolvedTypeHandler {
        public CharSequence typeText;

        private DisplayResolvedTypeHandler() {
        }

        public void process(CsmType resolvedType) {
            this.typeText = CsmDisplayUtilitiesProviderImpl.this.getTypeText(resolvedType, true, false);
        }
    }
}

