/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class GuardBlockWalker
extends APTWalker {
    private APT guardCheck;
    private Boolean hasGuard = null;

    public GuardBlockWalker(APTFile apt) {
        super(apt, null);
    }

    public Token getGuard() {
        if (this.hasGuard == Boolean.TRUE && this.guardCheck != null) {
            if (this.guardCheck instanceof APTIfndef) {
                return ((APTIfndef)this.guardCheck).getMacroName();
            }
            if (this.guardCheck instanceof APTPragma) {
                return ((APTPragma)this.guardCheck).getName();
            }
            APTDefine fileOnce = APTUtils.createAPTDefine((String)this.getCurFile().getPath().toString());
            fileOnce.getName();
        }
        return null;
    }

    protected void onDefine(APT apt) {
        this.hasGuard = Boolean.FALSE;
    }

    protected void onUndef(APT apt) {
        this.hasGuard = Boolean.FALSE;
    }

    protected boolean onIf(APT apt) {
        this.hasGuard = Boolean.FALSE;
        return false;
    }

    protected boolean onIfdef(APT apt) {
        this.hasGuard = Boolean.FALSE;
        return false;
    }

    protected boolean onIfndef(APT apt) {
        this.guardCheck = (APTIfndef)apt;
        this.hasGuard = this.hasGuard == null ? Boolean.TRUE : Boolean.FALSE;
        return false;
    }

    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        this.hasGuard = Boolean.FALSE;
        return false;
    }

    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        this.hasGuard = Boolean.FALSE;
        return false;
    }

    protected void onEndif(APT apt, boolean wasInBranch) {
        this.hasGuard = this.hasGuard == Boolean.TRUE ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void onInclude(APT apt) {
        this.hasGuard = Boolean.FALSE;
    }

    protected void onIncludeNext(APT apt) {
        this.hasGuard = Boolean.FALSE;
    }

    protected void onPragmaNode(APT apt) {
        APTPragma pragma = (APTPragma)apt;
        APTToken name = pragma.getName();
        if (name != null && "once".contentEquals(name.getTextID())) {
            this.hasGuard = Boolean.TRUE;
            this.guardCheck = apt;
            super.stop();
        }
    }

    protected void onOtherNode(APT apt) {
        this.hasGuard = Boolean.FALSE;
    }

    public void clearGuard() {
        this.hasGuard = Boolean.FALSE;
    }
}

