/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.repository.AbstractKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;

abstract class ProjectNameBasedKey
extends AbstractKey {
    private final int unitIndex;
    static final CharSequence NO_PROJECT = CharSequences.create((CharSequence)"<No Project Name>");

    protected ProjectNameBasedKey(int unitIndex) {
        this.unitIndex = unitIndex;
        CndUtils.assertTrue((this.unitIndex > 10000 ? 1 : 0) != 0, (String)"Impossible unit index: ", (Object)unitIndex);
    }

    protected ProjectNameBasedKey(KeyDataPresentation presentation) {
        this.unitIndex = presentation.getUnitPresentation();
        CndUtils.assertTrue((this.unitIndex > 10000 ? 1 : 0) != 0, (String)"Impossible unit index: ", (Object)this.unitIndex);
    }

    @Override
    public String toString() {
        return this.getProjectName().toString();
    }

    public int hashCode(int unitID) {
        return 37 * this.getHandler() + unitID;
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.unitIndex);
    }

    @Override
    public final int getUnitId() {
        return this.unitIndex;
    }

    public boolean equals(int thisUnitID, Key object, int objectUnitID) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return thisUnitID == objectUnitID;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectNameBasedKey other = (ProjectNameBasedKey)obj;
        return this.equals(this.unitIndex, other, other.unitIndex);
    }

    public void write(RepositoryDataOutput aStream) throws IOException {
        aStream.writeUnitId(this.unitIndex);
    }

    protected ProjectNameBasedKey(RepositoryDataInput aStream) throws IOException {
        this.unitIndex = aStream.readUnitId();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public CharSequence getAt(int level) {
        throw new UnsupportedOperationException();
    }

    protected CharSequence getProjectName() {
        return KeyUtilities.getUnitNameSafe(this.unitIndex);
    }

    @Override
    public CharSequence getUnit() {
        if (this.unitIndex < 0) {
            return NO_PROJECT;
        }
        return KeyUtilities.getUnitName(this.unitIndex);
    }

    public final int getUnitPresentation() {
        return this.unitIndex;
    }
}

