/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.Collection;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.api.FilePath;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.spi.RepositoryPathMapperImplementation;
import org.netbeans.modules.cnd.repository.spi.UnitDescriptorsMatcherImplementation;
import org.netbeans.modules.cnd.spi.project.NativeProjectRelocationMapperProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public class RepositoryMapperProvider
implements RepositoryPathMapperImplementation,
UnitDescriptorsMatcherImplementation {
    public CharSequence map(UnitDescriptor unitDescriptor, FilePath sourceFilePath) {
        Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
        NativeProject np = this.findProjectsByDescriptor(projects, unitDescriptor);
        if (np == null) {
            return sourceFilePath.getPath();
        }
        Collection providers = Lookup.getDefault().lookupAll(NativeProjectRelocationMapperProvider.class);
        for (NativeProjectRelocationMapperProvider provider : providers) {
            CharSequence destinationPath = provider.getDestinationPath(np, (CharSequence)sourceFilePath.getPath());
            if (destinationPath == null) continue;
            return destinationPath;
        }
        return sourceFilePath.getPath();
    }

    public boolean matches(UnitDescriptor descriptor1, UnitDescriptor descriptor2) {
        boolean matches;
        UnitDescriptor mapDescriptor = this.destinationDescriptor(descriptor1.getFileSystem(), descriptor2);
        boolean bl = matches = mapDescriptor != null && mapDescriptor.equals((Object)descriptor1);
        if (matches) {
            return true;
        }
        mapDescriptor = this.sourceDescriptor(descriptor1.getFileSystem(), descriptor2);
        matches = mapDescriptor.equals((Object)descriptor1);
        return matches;
    }

    private NativeProject findProjectsByDescriptor(Collection<NativeProject> projects, UnitDescriptor unitDescriptor) {
        for (NativeProject np : projects) {
            UnitDescriptor currDescriptor = KeyUtilities.createUnitDescriptor(np);
            if (!currDescriptor.equals((Object)unitDescriptor)) continue;
            return np;
        }
        return null;
    }

    public UnitDescriptor destinationDescriptor(FileSystem targetFileSystem, UnitDescriptor sourceUnitDescriptor) {
        Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
        NativeProject sourceProject = this.findProjectsByDescriptor(projects, sourceUnitDescriptor);
        if (sourceProject != null) {
            Collection providers = Lookup.getDefault().lookupAll(NativeProjectRelocationMapperProvider.class);
            for (NativeProjectRelocationMapperProvider provider : providers) {
                CharSequence destinationName = provider.getSourceProjectName(sourceProject);
                if (destinationName == null) continue;
                return KeyUtilities.createUnitDescriptor(targetFileSystem, destinationName);
            }
            return new UnitDescriptor(sourceUnitDescriptor.getName(), targetFileSystem);
        }
        return null;
    }

    public UnitDescriptor sourceDescriptor(FileSystem targetFileSystem, UnitDescriptor destinationDescriptor) {
        Collection providers = Lookup.getDefault().lookupAll(NativeProjectRelocationMapperProvider.class);
        for (NativeProjectRelocationMapperProvider provider : providers) {
            NativeProject destinationProject = provider.findDestinationProject(destinationDescriptor.getName());
            if (destinationProject == null || !destinationProject.getFileSystem().equals(targetFileSystem)) continue;
            return KeyUtilities.createUnitDescriptor(destinationProject);
        }
        return new UnitDescriptor(destinationDescriptor.getName(), targetFileSystem);
    }
}

