/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SeparatorWidget
extends Widget {
    private Orientation orientation;
    private int thickness;

    public SeparatorWidget(Scene scene, Orientation orientation) {
        super(scene);
        assert (orientation != null);
        this.orientation = orientation;
        this.thickness = 1;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        assert (orientation != null);
        this.orientation = orientation;
        this.revalidate();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        assert (thickness >= 0);
        this.thickness = thickness;
        this.revalidate();
    }

    @Override
    protected Rectangle calculateClientArea() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return new Rectangle(0, 0, 0, this.thickness);
        }
        return new Rectangle(0, 0, this.thickness, 0);
    }

    @Override
    protected void paintWidget() {
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        if (this.orientation == Orientation.HORIZONTAL) {
            gr.fillRect(0, 0, bounds.width - insets.left - insets.right, this.thickness);
        } else {
            gr.fillRect(0, 0, this.thickness, bounds.height - insets.top - insets.bottom);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

