/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.output;

import java.io.IOException;
import java.io.PrintWriter;
import org.netbeans.modules.mobility.end2end.codegenerator.ConnectionGenerator;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class OutputLogger {
    private static final String WARNING = "TXT_Warning";
    private static final String JAVON_TAB = "LBL_JavonTab";
    private InputOutput myOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ConnectionGenerator.class, (String)"LBL_JavonTab"), true);
    private static final OutputLogger INSTANCE = new OutputLogger();

    private OutputLogger() {
        try {
            this.myOutput.getIn().close();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void open() {
        this.myOutput.select();
    }

    public static OutputLogger getInstance() {
        return INSTANCE;
    }

    public void log(LogLevel level, String message, boolean appendNewLine) {
        if (appendNewLine) {
            this.getOutputWriter(level, false).println(message);
        } else {
            this.getOutputWriter(level, false).print(message);
        }
    }

    public void log(Exception e) {
        e.printStackTrace((PrintWriter)this.getOutput().getErr());
    }

    public void logAppend(LogLevel level, String message, boolean appendNewLine) {
        if (appendNewLine) {
            this.getOutputWriter(level, true).println(message);
        } else {
            this.getOutputWriter(level, true).print(message);
        }
    }

    public void log(LogLevel level, String message) {
        this.log(level, message, true);
    }

    public void log(String message) {
        this.log(LogLevel.NOTICE, message, true);
    }

    private InputOutput getOutput() {
        return this.myOutput;
    }

    private OutputWriter getOutputWriter(LogLevel level, boolean append) {
        if (level == LogLevel.ERROR) {
            return this.getOutput().getErr();
        }
        if (level == LogLevel.WARNING) {
            OutputWriter writer = this.getOutput().getOut();
            if (!append) {
                String warning = NbBundle.getMessage(OutputLogger.class, (String)WARNING);
                writer.append((CharSequence)warning);
                writer.append((CharSequence)" ");
            }
            return writer;
        }
        return this.getOutput().getOut();
    }

    public void close() {
        this.getOutput().getOut().close();
        this.getOutput().getErr().close();
    }

    public static enum LogLevel {
        NOTICE,
        WARNING,
        ERROR;

    }
}

