/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.launchers.Launcher;
import org.netbeans.modules.cnd.makeproject.api.launchers.LaunchersRegistry;
import org.netbeans.modules.cnd.makeproject.api.launchers.LaunchersRegistryFactory;
import org.netbeans.modules.cnd.makeproject.ui.actions.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.ui.launchers.actions.LauncherAction;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class RunDialogAction
extends NodeAction {
    protected JButton runButton = null;
    private Object[] options;
    private FileObject contextFileObject;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private static final RequestProcessor RP = new RequestProcessor("RunDialogAction", 1);

    private void init(boolean isRun) {
        if (this.runButton == null) {
            this.runButton = new JButton(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
            this.options = new Object[]{this.runButton, DialogDescriptor.CANCEL_OPTION};
        }
        if (isRun) {
            this.runButton.setText(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
        } else {
            this.runButton.setText(this.getString("CreateButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("CreateButtonAD"));
        }
    }

    public String getName() {
        return this.getString("RUN_COMMAND");
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.contextFileObject = (FileObject)actionContext.lookup(FileObject.class);
        return super.createContextAwareInstance(actionContext);
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject executableFO = null;
        boolean isRun = true;
        if (activatedNodes != null && activatedNodes.length == 1) {
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null) {
                executableFO = fo;
            }
        } else if (this.contextFileObject != null) {
            executableFO = this.contextFileObject;
            isRun = false;
        }
        if (executableFO != null) {
            this.perform(executableFO, isRun);
        }
    }

    protected String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    public void perform(FileObject executableFO, boolean isRun) {
        this.init(isRun);
        try {
            this.perform(new RunDialogPanel(executableFO, this.runButton, isRun), isRun);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void perform(RunDialogPanel runDialogPanel, boolean isRun) {
        if (WindowManager.getDefault().getRegistry().getOpened().isEmpty()) {
            WindowManager.getDefault().invokeWhenUIReady(() -> RP.post(() -> runDialogPanel.getSelectedProject(null)));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.running.get()) {
                return;
            }
            this.running.set(true);
            try {
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, isRun ? this.getString("RunDialogTitle") : this.getString("CreateDialogTitle"), true, this.options, (Object)this.runButton, 0, null, null);
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (ret == this.runButton) {
                    runDialogPanel.getSelectedProject(project -> this.performRun(project, runDialogPanel.getExecutablePath(), isRun));
                }
            }
            finally {
                this.running.set(false);
            }
        });
    }

    private void performRun(Project project, String executable, boolean isRun) {
        if (isRun) {
            LaunchersRegistry registry = LaunchersRegistryFactory.getInstance((FileObject)project.getProjectDirectory());
            Launcher launcher = null;
            if (registry.hasLaunchers()) {
                for (Launcher l : registry.getLaunchers()) {
                    if (!executable.startsWith(l.getCommand())) continue;
                    launcher = l;
                    break;
                }
            }
            if (launcher == null) {
                launcher = new Launcher(executable, null);
                registry.add(launcher);
            }
            LauncherAction action = LauncherAction.runAsAction();
            action.createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project}));
            LauncherAction launcherAction = action;
            launcherAction.getClass();
            new LauncherAction.LauncherExecutableAction(launcherAction, launcher).actionPerformed(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        return NbBundle.getMessage(RunDialogAction.class, (String)s);
    }

    protected boolean asynchronous() {
        return false;
    }

    public final class SimpleRunActionProxy
    extends AbstractAction {
        private final Project project;
        private final String executable;

        public SimpleRunActionProxy(Project project, String executable) {
            this.project = project;
            this.executable = executable;
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return RunDialogAction.this.getName();
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunDialogAction.this.performRun(this.project, this.executable, true);
        }
    }
}

