/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.configurations.LibrariesNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.VectorNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class LinkerGeneralCustomizerNode
extends CustomizerNode {
    public LinkerGeneralCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        switch (this.getContext().getKind()) {
            case Folder: {
                Folder[] folders = this.getContext().getFolders();
                ArrayList<Sheet> folderSheets = new ArrayList<Sheet>();
                for (Folder folder : folders) {
                    if (folder.isTest()) {
                        folderSheets.add(this.getGeneralSheet(this.getContext().getProject(), (MakeConfigurationDescriptor)this.getContext().getConfigurationDescriptor(), (MakeConfiguration)configuration, this.getContext().isQtMode(), false, folder.getFolderConfiguration(configuration).getLinkerConfiguration()));
                        continue;
                    }
                    folderSheets.add(this.getGeneralSheet(this.getContext().getProject(), (MakeConfigurationDescriptor)this.getContext().getConfigurationDescriptor(), (MakeConfiguration)configuration, this.getContext().isQtMode(), true, folder.getFolderConfiguration(configuration).getLinkerConfiguration()));
                }
                return folderSheets.toArray(new Sheet[folderSheets.size()]);
            }
            case Project: {
                return new Sheet[]{this.getGeneralSheet(this.getContext().getProject(), (MakeConfigurationDescriptor)this.getContext().getConfigurationDescriptor(), (MakeConfiguration)configuration, this.getContext().isQtMode(), false, ((MakeConfiguration)configuration).getLinkerConfiguration())};
            }
        }
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsLinking");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(LinkerGeneralCustomizerNode.class, (String)s);
    }

    private Sheet getGeneralSheet(Project project, MakeConfigurationDescriptor configurationDescriptor, MakeConfiguration conf, boolean isQtMode, boolean inheritablePropertiesOnly, LinkerConfiguration lc) {
        String[] texts;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        ToolchainManager.LinkerDescriptor linker = null;
        String linkDriver = null;
        if (compilerSet != null) {
            linker = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (conf.hasCPPFiles(configurationDescriptor)) {
                AbstractCompiler ccCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
                linkDriver = ccCompiler.getName();
            } else {
                AbstractCompiler cCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
                linkDriver = cCompiler.getName();
            }
        }
        Sheet.Set set1 = new Sheet.Set();
        set1.setName("General");
        set1.setDisplayName(LinkerGeneralCustomizerNode.getString("GeneralTxt"));
        set1.setShortDescription(LinkerGeneralCustomizerNode.getString("GeneralHint"));
        if (!isQtMode) {
            if (!inheritablePropertiesOnly) {
                set1.put((Node.Property)new OutputNodeProp(lc.getOutput(), lc.getOutputDefault(), "Output", LinkerGeneralCustomizerNode.getString("OutputTxt"), LinkerGeneralCustomizerNode.getString("OutputHint")));
            }
            set1.put((Node.Property)new VectorNodeProp(lc.getAdditionalLibs(), null, lc.getMakeConfiguration().getBaseFSPath(), new String[]{"AdditionalLibraryDirectories", LinkerGeneralCustomizerNode.getString("AdditionalLibraryDirectoriesTxt"), LinkerGeneralCustomizerNode.getString("AdditionalLibraryDirectoriesHint")}, true, 1, new HelpCtx("AddtlLibraryDirectories")){

                @Override
                protected List<String> convertToList(String text) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
                }

                @Override
                protected String convertToString(List<String> list) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
                }
            });
        }
        if (linker != null && linker.getDynamicLibrarySearchFlag() != null && linker.getDynamicLibrarySearchFlag().length() > 0) {
            set1.put((Node.Property)new VectorNodeProp(lc.getDynamicSearch(), null, lc.getMakeConfiguration().getBaseFSPath(), new String[]{"RuntimeSearchDirectories", LinkerGeneralCustomizerNode.getString("RuntimeSearchDirectoriesTxt"), LinkerGeneralCustomizerNode.getString("RuntimeSearchDirectoriesHint")}, false, 1, new HelpCtx("RuntimeSearchDirectories")){

                @Override
                protected List<String> convertToList(String text) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
                }

                @Override
                protected String convertToString(List<String> list) {
                    return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
                }
            });
        }
        sheet.put(set1);
        if (!isQtMode) {
            Sheet.Set set2 = new Sheet.Set();
            if (!inheritablePropertiesOnly) {
                set2.setName("Options");
                set2.setDisplayName(LinkerGeneralCustomizerNode.getString("OptionsTxt"));
                set2.setShortDescription(LinkerGeneralCustomizerNode.getString("OptionsHint"));
                set2.put((Node.Property)new BooleanNodeProp(lc.getStripOption(), true, "StripSymbols", LinkerGeneralCustomizerNode.getString("StripSymbolsTxt"), LinkerGeneralCustomizerNode.getString("StripSymbolsHint")));
                if (conf.isDynamicLibraryConfiguration()) {
                    set2.put((Node.Property)new BooleanNodeProp(lc.getPICOption(), true, "PositionIndependantCode", LinkerGeneralCustomizerNode.getString("PositionIndependantCodeTxt"), LinkerGeneralCustomizerNode.getString("PositionIndependantCodeHint")));
                    if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                        set2.put((Node.Property)new BooleanNodeProp(lc.getNorunpathOption(), true, "NoRunPath", LinkerGeneralCustomizerNode.getString("NoRunPathTxt"), LinkerGeneralCustomizerNode.getString("NoRunPathHint")));
                        set2.put((Node.Property)new BooleanNodeProp(lc.getNameassignOption(), true, "AssignName", LinkerGeneralCustomizerNode.getString("AssignNameTxt"), LinkerGeneralCustomizerNode.getString("AssignNameHint")));
                    }
                }
                sheet.put(set2);
            }
            Sheet.Set set3 = new Sheet.Set();
            texts = new String[]{LinkerGeneralCustomizerNode.getString("AdditionalDependenciesTxt1"), LinkerGeneralCustomizerNode.getString("AdditionalDependenciesHint"), LinkerGeneralCustomizerNode.getString("AdditionalDependenciesTxt2"), LinkerGeneralCustomizerNode.getString("InheritedValuesTxt")};
            set3.setName("Input");
            set3.setDisplayName(LinkerGeneralCustomizerNode.getString("InputTxt"));
            set3.setShortDescription(LinkerGeneralCustomizerNode.getString("InputHint"));
            set3.put((Node.Property)new OptionsNodeProp(lc.getAdditionalDependencies(), null, new AdditionalDependenciesOptions(lc), null, ",", texts));
            sheet.put(set3);
            Sheet.Set set4 = new Sheet.Set();
            if (!inheritablePropertiesOnly) {
                set4.setName("Tool");
                set4.setDisplayName(LinkerGeneralCustomizerNode.getString("ToolTxt1"));
                set4.setShortDescription(LinkerGeneralCustomizerNode.getString("ToolHint1"));
                if (linkDriver != null) {
                    set4.put((Node.Property)new StringNodeProp(lc.getTool(), linkDriver, "Tool", LinkerGeneralCustomizerNode.getString("ToolTxt1"), LinkerGeneralCustomizerNode.getString("ToolHint1")));
                }
                sheet.put(set4);
            }
        }
        texts = new String[]{LinkerGeneralCustomizerNode.getString("LibrariesTxt1"), LinkerGeneralCustomizerNode.getString("LibrariesHint"), LinkerGeneralCustomizerNode.getString("LibrariesTxt2"), LinkerGeneralCustomizerNode.getString("AllOptionsTxt2")};
        Sheet.Set set5 = new Sheet.Set();
        set5.setName("Libraries");
        set5.setDisplayName(LinkerGeneralCustomizerNode.getString("LibrariesTxt1"));
        set5.setShortDescription(LinkerGeneralCustomizerNode.getString("LibrariesHint"));
        set5.put((Node.Property)new LibrariesNodeProp(lc.getLibrariesConfiguration(), project, conf, lc.getMakeConfiguration().getBaseFSPath(), texts));
        set5.put((Node.Property)new IntNodeProp(lc.getLibrariesRunTimeSearchPathKind(), true, "RunTimeSerchPath", LinkerGeneralCustomizerNode.getString("RunTimeSerchPathTxt"), LinkerGeneralCustomizerNode.getString("RunTimeSerchPathHint")));
        set5.put((Node.Property)new BooleanNodeProp(lc.getCopyLibrariesConfiguration(), true, "CopyLibraries", LinkerGeneralCustomizerNode.getString("CopyLibrariesTxt"), LinkerGeneralCustomizerNode.getString("CopyLibrariesHint")));
        sheet.put(set5);
        if (!isQtMode) {
            texts = new String[]{LinkerGeneralCustomizerNode.getString("AdditionalOptionsTxt1"), LinkerGeneralCustomizerNode.getString("AdditionalOptionsHint"), LinkerGeneralCustomizerNode.getString("AdditionalOptionsTxt2"), LinkerGeneralCustomizerNode.getString("AllOptionsTxt")};
            Sheet.Set set6 = new Sheet.Set();
            set6.setName("CommandLine");
            set6.setDisplayName(LinkerGeneralCustomizerNode.getString("CommandLineTxt"));
            set6.setShortDescription(LinkerGeneralCustomizerNode.getString("CommandLineHint"));
            set6.put((Node.Property)new OptionsNodeProp(lc.getCommandLineConfiguration(), null, (AllOptionsProvider)lc, null, null, texts));
            sheet.put(set6);
        }
        return sheet;
    }

    private static class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            if (CndPathUtilities.hasMakeSpecialCharacters((String)v)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)LinkerGeneralCustomizerNode.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(v);
        }
    }

    private static final class AdditionalDependenciesOptions
    implements AllOptionsProvider {
        private final LinkerConfiguration lc;

        public AdditionalDependenciesOptions(LinkerConfiguration lc) {
            this.lc = lc;
        }

        public String getAllOptions(Tool tool) {
            String options = "";
            options = options + this.lc.getAdditionalDependencies().getPreDefined();
            return MakeProjectOptionsFormat.reformatWhitespaces((String)options);
        }
    }
}

