/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PackagingNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class PackagingCustomizerNode
extends CustomizerNode {
    private TypePropertyChangeListener typePropertyChangeListener;

    public PackagingCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        Sheet generalSheet = this.getGeneralSheet(this.getContext().getContainer(), ((MakeConfiguration)configuration).getPackagingConfiguration(), this);
        return new Sheet[]{generalSheet};
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsPackaging");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(PackagingCustomizerNode.class, (String)s);
    }

    private Sheet getGeneralSheet(JPanel makeCustomizer, PackagingConfiguration conf, PackagingCustomizerNode cust) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(PackagingCustomizerNode.getString("GeneralTxt"));
        set.setShortDescription(PackagingCustomizerNode.getString("GeneralHint"));
        PackagerIntConfiguration tmpIntConfiguration = new PackagerIntConfiguration(null, 0, PackagerManager.getDefault().getDisplayNames(), null, conf);
        PackagerIntNodeProp intNodeprop = new PackagerIntNodeProp(tmpIntConfiguration, true, "PackageType", PackagingCustomizerNode.getString("PackageTypeName"), PackagingCustomizerNode.getString("PackageTypeHint"), conf);
        set.put((Node.Property)intNodeprop);
        OutputNodeProp outputNodeProp = new OutputNodeProp(conf.getOutput(), conf.getOutputDefault(), "Output", PackagingCustomizerNode.getString("OutputTxt"), PackagingCustomizerNode.getString("OutputHint"));
        set.put((Node.Property)outputNodeProp);
        String[] texts = new String[]{"Files", PackagingCustomizerNode.getString("FilesName"), PackagingCustomizerNode.getString("FilesHint")};
        set.put((Node.Property)new PackagingNodeProp(conf, conf.getMakeConfiguration(), texts));
        StringNodeProp toolNodeProp = new StringNodeProp(conf.getTool(), conf.getToolDefault(), "Tool", PackagingCustomizerNode.getString("ToolTxt1"), PackagingCustomizerNode.getString("ToolHint1"));
        set.put((Node.Property)toolNodeProp);
        StringNodeProp optionsNodeProp = new StringNodeProp(conf.getOptions(), conf.getOptionsDefault(), "AdditionalOptions", PackagingCustomizerNode.getString("AdditionalOptionsTxt1"), PackagingCustomizerNode.getString("AdditionalOptionsHint"));
        set.put((Node.Property)optionsNodeProp);
        set.put((Node.Property)new BooleanNodeProp(conf.getVerbose(), true, "Verbose", PackagingCustomizerNode.getString("VerboseName"), PackagingCustomizerNode.getString("VerboseHint")));
        sheet.put(set);
        cust.typePropertyChangeListener = new TypePropertyChangeListener(makeCustomizer, outputNodeProp, toolNodeProp, optionsNodeProp, conf);
        intNodeprop.getPropertyEditor().addPropertyChangeListener(cust.typePropertyChangeListener);
        return sheet;
    }

    private static class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String def, String txt1, String txt2, String txt3) {
            super(stringConfiguration, def, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            if (CndPathUtilities.hasMakeSpecialCharacters((String)v)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PackagingCustomizerNode.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(v);
        }
    }

    private static class TypePropertyChangeListener
    implements PropertyChangeListener {
        private final JPanel makeCustomizer;
        private final OutputNodeProp outputNodeProp;
        private final StringNodeProp toolNodeProp;
        private final StringNodeProp optionsNodeProp;
        private final PackagingConfiguration conf;

        TypePropertyChangeListener(JPanel makeCustomizer, OutputNodeProp outputNodeProp, StringNodeProp toolNodeProp, StringNodeProp optionsNodeProp, PackagingConfiguration conf) {
            this.makeCustomizer = makeCustomizer;
            this.outputNodeProp = outputNodeProp;
            this.toolNodeProp = toolNodeProp;
            this.optionsNodeProp = optionsNodeProp;
            this.conf = conf;
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.toolNodeProp.setCanWrite(this.conf.getToolDefault().length() > 0);
            this.optionsNodeProp.setCanWrite(this.conf.getToolDefault().length() > 0);
            if (!this.conf.getOutput().getModified()) {
                this.outputNodeProp.setDefaultValue(this.conf.getOutputDefault());
                this.conf.getOutput().reset();
            }
            if (!this.conf.getTool().getModified()) {
                this.toolNodeProp.setDefaultValue(this.conf.getToolDefault());
                this.conf.getTool().reset();
            }
            if (!this.conf.getOptions().getModified()) {
                this.optionsNodeProp.setDefaultValue(this.conf.getOptionsDefault());
                this.conf.getOptions().reset();
            }
            this.makeCustomizer.validate();
            this.makeCustomizer.repaint();
        }
    }

    private static class PackagerIntNodeProp
    extends IntNodeProp {
        private final PackagingConfiguration conf;

        public PackagerIntNodeProp(IntConfiguration intConfiguration, boolean canWrite, String name, String displayName, String description, PackagingConfiguration conf) {
            super(intConfiguration, canWrite, name, displayName, description);
            this.conf = conf;
        }

        @Override
        public Object getValue() {
            return PackagerManager.getDefault().getNameIndex(this.conf.getType().getValue());
        }

        @Override
        public void setValue(Object v) {
            String displayName = (String)v;
            String name = PackagerManager.getDefault().getName(displayName);
            if (name != null) {
                this.conf.getType().setValue(name);
            } else assert (false);
        }
    }

    private static class PackagerIntConfiguration
    extends IntConfiguration {
        private final PackagingConfiguration conf;

        PackagerIntConfiguration(IntConfiguration master, int def, String[] names, String[] options, PackagingConfiguration conf) {
            super(master, def, names, options);
            this.conf = conf;
        }

        public void setValue(String s) {
            if (s != null) {
                String displayName = s;
                String name = PackagerManager.getDefault().getName(displayName);
                if (name != null) {
                    this.conf.getType().setValue(name);
                } else assert (false);
            }
        }

        public int getValue() {
            int i = PackagerManager.getDefault().getNameIndex(this.conf.getType().getValue());
            return i;
        }
    }
}

