/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.CompilerHacks;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspProperty;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserControllerProxy;

public class ExtractPageData {
    private final JspCompilationContext ctxt;
    private final Options options;
    private final CompilerHacks compHacks;
    private boolean isXml;
    private String sourceEnc;

    public ExtractPageData(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
        this.compHacks = new CompilerHacks(ctxt);
    }

    public boolean isXMLSyntax() throws JasperException, FileNotFoundException, IOException {
        if (this.sourceEnc == null) {
            this.extractPageData();
        }
        return this.isXml;
    }

    public String getEncoding() throws JasperException, FileNotFoundException, IOException {
        if (this.sourceEnc == null) {
            this.extractPageData();
        }
        return this.sourceEnc;
    }

    private void extractPageData() throws JasperException, FileNotFoundException, IOException {
        Compiler comp = this.compHacks.getCompiler();
        PageInfo pageInfo = comp.getPageInfo();
        JspConfig jspConfig = this.options.getJspConfig();
        JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        pageInfo.setELIgnored(JspUtil.booleanValue((String)jspProperty.isELIgnored()));
        pageInfo.setScriptingInvalid(JspUtil.booleanValue((String)jspProperty.isScriptingInvalid()));
        if (jspProperty.getIncludePrelude() != null) {
            pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        JspUtil.resetTemporaryVariableName();
        ParserControllerProxy parserCtl = new ParserControllerProxy(this.ctxt, comp);
        parserCtl.extractSyntaxAndEncoding(this.ctxt.getJspFile());
        this.isXml = parserCtl.isXml;
        this.sourceEnc = parserCtl.sourceEnc;
    }
}

